/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.execution;

import com.ibatis.common.Objects;
import com.ibatis.sqlmap.client.BatchResult;
import com.ibatis.sqlmap.client.event.PageHandler;
import com.ibatis.sqlmap.client.event.RowSetHandler;
import com.ibatis.sqlmap.client.event.TotalRowHandler;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.dialect.PageDialect;
import com.ibatis.sqlmap.engine.execution.Batch;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactoryUtil;
import com.ibatis.sqlmap.engine.mapping.statement.DefaultRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.MappedRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DefaultSqlExecutor
implements SqlExecutor {
    SqlMapExecutorDelegate delegate;

    public DefaultSqlExecutor(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("executing update");
        if (errorContext.getSql() == null) {
            errorContext.setSql(sql);
        }
        PreparedStatement ps = null;
        this.setupResultObjectFactory(statementScope);
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            ps = DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql, false);
            DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), ps);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            Object[] args = statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
            errorContext.setArgs(args);
            errorContext.setMoreInfo("Check the statement (update failed).");
            ps.execute();
            rows = ps.getUpdateCount();
        }
        catch (Throwable throwable) {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
            this.cleanupResultObjectFactory();
            throw throwable;
        }
        DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
        this.cleanupResultObjectFactory();
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeInsert(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters, ResultMap keyResultMap) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("executing update");
        if (errorContext.getSql() == null) {
            errorContext.setSql(sql);
        }
        PreparedStatement ps = null;
        this.setupResultObjectFactory(statementScope);
        T object = null;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            ps = DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql, true);
            DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), ps);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            Object[] args = statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
            errorContext.setArgs(args);
            errorContext.setMoreInfo("Check the statement (update failed).");
            ps.execute();
            ResultSet rs = ps.getGeneratedKeys();
            DefaultRowHandler rowHandler = new DefaultRowHandler();
            statementScope.setResultMap(keyResultMap);
            RowHandlerCallback callback = new RowHandlerCallback(keyResultMap, null, rowHandler);
            this.handleResults(statementScope, rs, 0, 1, callback);
            List list = (List)Objects.uncheckedCast(rowHandler.getList());
            if (list.size() > 0) {
                object = (T)list.get(0);
            }
        }
        catch (Throwable throwable) {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
            this.cleanupResultObjectFactory();
            throw throwable;
        }
        DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
        this.cleanupResultObjectFactory();
        return object;
    }

    @Override
    public int addBatch(StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        return this.doAddBatch(false, statementScope, conn, sql, parameters);
    }

    public int doAddBatch(boolean debug, StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        Batch batch = statementScope.getSession().getBatch();
        if (batch == null || batch.isCleanup()) {
            batch = new Batch(statementScope.getSession().getBatchSize(), debug);
            statementScope.getSession().setBatch(batch);
        }
        batch.addBatch(statementScope, conn, sql, parameters);
        if (batch.batchSize > 0 && batch.getSize() >= batch.batchSize) {
            return this.executeBatch(statementScope.getSession());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeBatch(SessionScope sessionScope) throws SQLException {
        int rows = 0;
        Batch batch = sessionScope.getBatch();
        if (batch != null && !batch.isCleanup()) {
            try {
                rows = batch.executeBatch();
            }
            finally {
                batch.cleanupBatch(sessionScope);
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchResult> executeBatchDetailed(SessionScope sessionScope) throws SQLException, BatchException {
        List<BatchResult> answer = null;
        Batch batch = sessionScope.getBatch();
        if (batch != null && !batch.isCleanup()) {
            try {
                answer = batch.executeBatchDetailed();
            }
            finally {
                batch.cleanupBatch(sessionScope);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQueryPage(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters, int skip, int max, RowHandlerCallback callback, PageHandler pageHandler) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block15: {
            ErrorContext errorContext = statementScope.getErrorContext();
            errorContext.setActivity("executing query page");
            PageDialect pageDialect = this.delegate.getPageDialect(id, sql, true, skip, max);
            String countSql = null;
            if (pageDialect != null) {
                sql = pageDialect.getPageSql(errorContext);
                countSql = pageDialect.getCountSql(errorContext);
            }
            if (errorContext.getSql() == null) {
                errorContext.setSql(sql);
            }
            ps = null;
            rs = null;
            this.setupResultObjectFactory(statementScope);
            try {
                Integer fetchSize;
                errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
                boolean nostat = statementScope.getStatement() == null;
                Integer rsType = nostat ? null : statementScope.getStatement().getResultSetType();
                ps = rsType != null ? DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql, rsType) : DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql, false);
                DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), ps);
                Integer n = fetchSize = nostat ? null : statementScope.getStatement().getFetchSize();
                if (fetchSize != null) {
                    try {
                        ps.setFetchSize(fetchSize);
                    }
                    catch (Exception e) {
                        statementScope.getStatement().setFetchSize(null);
                    }
                }
                errorContext.setMoreInfo("Check the parameters (set parameters failed).");
                Object[] args = statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
                errorContext.setArgs(args);
                errorContext.setMoreInfo("Check the statement (query failed).");
                ps.execute();
                errorContext.setMoreInfo("Check the results (failed to retrieve results).");
                if (pageDialect != null) {
                    rs = this.getFirstResultSet(statementScope, ps);
                    this.handleResults(statementScope, rs, 0, -1, callback);
                    DefaultSqlExecutor.closeResultSet(rs);
                    DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
                    errorContext.setMoreInfo("Check the results (failed to count total).");
                    ps = DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, countSql, false);
                    if (countSql.contains("?")) {
                        statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
                    }
                    rs = ps.executeQuery();
                    rs.next();
                    int total = rs.getInt(1);
                    pageHandler.setTotal(total);
                    errorContext.setTotal(total);
                    break block15;
                }
                rs = this.handleMultipleResults(ps, statementScope, skip, max, callback);
            }
            catch (Throwable throwable) {
                try {
                    DefaultSqlExecutor.closeResultSet(rs);
                }
                finally {
                    DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
                    this.cleanupResultObjectFactory();
                }
                throw throwable;
            }
        }
        try {
            DefaultSqlExecutor.closeResultSet(rs);
        }
        finally {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
            this.cleanupResultObjectFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters, int skip, int max, RowHandlerCallback callback) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block14: {
            ErrorContext errorContext = statementScope.getErrorContext();
            errorContext.setActivity("executing query");
            PageDialect pageDialect = this.delegate.getPageDialect(id, sql, false, skip, max);
            if (pageDialect != null) {
                sql = pageDialect.getPageSql(errorContext);
            }
            if (errorContext.getSql() == null) {
                errorContext.setSql(sql);
            }
            ps = null;
            rs = null;
            this.setupResultObjectFactory(statementScope);
            try {
                Integer fetchSize;
                errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
                boolean nostat = statementScope.getStatement() == null;
                Integer rsType = nostat ? null : statementScope.getStatement().getResultSetType();
                ps = rsType != null ? DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql, rsType) : DefaultSqlExecutor.prepareStatement(statementScope.getSession(), conn, sql, false);
                DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), ps);
                Integer n = fetchSize = nostat ? null : statementScope.getStatement().getFetchSize();
                if (fetchSize != null) {
                    try {
                        ps.setFetchSize(fetchSize);
                    }
                    catch (Exception e) {
                        statementScope.getStatement().setFetchSize(null);
                    }
                }
                errorContext.setMoreInfo("Check the parameters (set parameters failed).");
                Object[] args = statementScope.getParameterMap().setParameters(statementScope, ps, parameters);
                errorContext.setArgs(args);
                errorContext.setMoreInfo("Check the statement (query failed).");
                ps.execute();
                errorContext.setMoreInfo("Check the results (failed to retrieve results).");
                if (pageDialect != null) {
                    rs = this.getFirstResultSet(statementScope, ps);
                    this.handleResults(statementScope, rs, 0, -1, callback);
                    break block14;
                }
                rs = this.handleMultipleResults(ps, statementScope, skip, max, callback);
            }
            catch (Throwable throwable) {
                try {
                    DefaultSqlExecutor.closeResultSet(rs);
                }
                finally {
                    DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
                    this.cleanupResultObjectFactory();
                }
                throw throwable;
            }
        }
        try {
            DefaultSqlExecutor.closeResultSet(rs);
        }
        finally {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), ps);
            this.cleanupResultObjectFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdateProcedure(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("executing update procedure");
        if (errorContext.getSql() == null) {
            errorContext.setSql(sql);
        }
        CallableStatement cs = null;
        this.setupResultObjectFactory(statementScope);
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            cs = DefaultSqlExecutor.prepareCall(statementScope.getSession(), conn, sql);
            DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), cs);
            ParameterMap parameterMap = statementScope.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            Object[] args = parameterMap.setParameters(statementScope, cs, parameters);
            errorContext.setArgs(args);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            rows = cs.getUpdateCount();
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(statementScope, cs, mappings, parameters, null);
        }
        catch (Throwable throwable) {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), cs);
            this.cleanupResultObjectFactory();
            throw throwable;
        }
        DefaultSqlExecutor.closeStatement(statementScope.getSession(), cs);
        this.cleanupResultObjectFactory();
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQueryProcedure(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters, int skip, int max, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("executing query procedure");
        if (errorContext.getSql() == null) {
            errorContext.setSql(sql);
        }
        CallableStatement cs = null;
        ResultSet rs = null;
        this.setupResultObjectFactory(statementScope);
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            Integer rsType = statementScope.getStatement().getResultSetType();
            cs = rsType != null ? DefaultSqlExecutor.prepareCall(statementScope.getSession(), conn, sql, rsType) : DefaultSqlExecutor.prepareCall(statementScope.getSession(), conn, sql);
            DefaultSqlExecutor.setStatementTimeout(statementScope.getStatement(), cs);
            Integer fetchSize = statementScope.getStatement().getFetchSize();
            if (fetchSize != null) {
                try {
                    cs.setFetchSize(fetchSize);
                }
                catch (SQLException e) {
                    statementScope.getStatement().setFetchSize(null);
                }
            }
            ParameterMap parameterMap = statementScope.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            Object[] args = parameterMap.setParameters(statementScope, cs, parameters);
            errorContext.setArgs(args);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            rs = this.handleMultipleResults(cs, statementScope, skip, max, callback);
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(statementScope, cs, mappings, parameters, callback);
        }
        catch (Throwable throwable) {
            try {
                DefaultSqlExecutor.closeResultSet(rs);
            }
            finally {
                DefaultSqlExecutor.closeStatement(statementScope.getSession(), cs);
                this.cleanupResultObjectFactory();
            }
            throw throwable;
        }
        try {
            DefaultSqlExecutor.closeResultSet(rs);
        }
        finally {
            DefaultSqlExecutor.closeStatement(statementScope.getSession(), cs);
            this.cleanupResultObjectFactory();
        }
    }

    @Override
    public void init(SqlMapConfiguration config, Properties globalProps) {
        this.delegate = config.getDelegate();
    }

    private ResultSet handleMultipleResults(PreparedStatement ps, StatementScope statementScope, int skip, int max, RowHandlerCallback callback) throws SQLException {
        ResultSet rs = this.getFirstResultSet(statementScope, ps);
        if (rs != null) {
            this.handleResults(statementScope, rs, skip, max, callback);
        }
        if (callback.getRowHandler() instanceof DefaultRowHandler) {
            MappedStatement statement = statementScope.getStatement();
            DefaultRowHandler defaultRowHandler = (DefaultRowHandler)callback.getRowHandler();
            if (statement != null && statement.hasMultipleResultMaps()) {
                ArrayList multipleResults = new ArrayList();
                multipleResults.add(defaultRowHandler.getList());
                ResultMap[] resultMaps = statement.getAdditionalResultMaps();
                for (int i = 0; this.moveToNextResultsSafely(statementScope, ps) && i < resultMaps.length; ++i) {
                    ResultMap rm = resultMaps[i];
                    statementScope.setResultMap(rm);
                    rs = ps.getResultSet();
                    DefaultRowHandler rh = new DefaultRowHandler();
                    this.handleResults(statementScope, rs, skip, max, new RowHandlerCallback(rm, null, rh));
                    multipleResults.add(rh.getList());
                }
                defaultRowHandler.setList(multipleResults);
                statementScope.setResultMap(statement.getResultMap());
            } else {
                while (this.moveToNextResultsSafely(statementScope, ps)) {
                }
            }
        }
        return rs;
    }

    private ResultSet getFirstResultSet(StatementScope scope, Statement stmt) throws SQLException {
        ResultSet rs = null;
        boolean hasMoreResults = true;
        while (hasMoreResults && (rs = stmt.getResultSet()) == null) {
            hasMoreResults = this.moveToNextResultsIfPresent(scope, stmt);
        }
        return rs;
    }

    private boolean moveToNextResultsIfPresent(StatementScope scope, Statement stmt) throws SQLException {
        boolean moreResults;
        boolean movedToNextResultsSafely = this.moveToNextResultsSafely(scope, stmt);
        int updateCount = stmt.getUpdateCount();
        boolean bl = moreResults = movedToNextResultsSafely || updateCount != -1;
        if (moreResults) {
            moreResults = movedToNextResultsSafely || this.isMultipleResultSetSupportPresent(scope, stmt);
        }
        return moreResults;
    }

    private boolean moveToNextResultsSafely(StatementScope scope, Statement stmt) throws SQLException {
        if (this.isMultipleResultSetSupportPresent(scope, stmt)) {
            return stmt.getMoreResults();
        }
        return false;
    }

    private boolean isMultipleResultSetSupportPresent(StatementScope scope, Statement stmt) throws SQLException {
        return this.forceMultipleResultSetSupport(scope) || stmt.getConnection().getMetaData().supportsMultipleResultSets();
    }

    private boolean forceMultipleResultSetSupport(StatementScope scope) {
        return ((SqlMapClientImpl)scope.getSession().getSqlMapClient()).getDelegate().isForceMultipleResultSetSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResults(StatementScope statementScope, ResultSet rs, int skip, int max, RowHandlerCallback callback) throws SQLException {
        if (skip < 0) {
            skip = 0;
        }
        try {
            statementScope.setResultSet(rs);
            RowSetHandler rsh = null;
            if (callback.getRowHandler() instanceof RowSetHandler) {
                rsh = (RowSetHandler)callback.getRowHandler();
            }
            if (rsh != null) {
                rsh.handleResultSet(rs);
                return;
            }
            TotalRowHandler trh = null;
            if (callback.getRowHandler() instanceof TotalRowHandler) {
                trh = (TotalRowHandler)callback.getRowHandler();
            }
            MappedRowHandler mrh = null;
            if (callback.getRowHandler() instanceof MappedRowHandler) {
                mrh = (MappedRowHandler)callback.getRowHandler();
            }
            ResultMap resultMap = statementScope.getResultMap();
            int total = 0;
            if (resultMap != null || mrh != null) {
                int resultsFetched;
                if (rs.getType() != 1003) {
                    if (skip > 0) {
                        rs.absolute(skip);
                        if (trh != null) {
                            total = trh.handleTotal(skip);
                        }
                    }
                } else {
                    for (int i = 0; i < skip; ++i) {
                        if (rs.next()) continue;
                        if (trh != null) {
                            total = trh.handleTotal(i);
                        }
                        statementScope.getErrorContext().setTotal(total);
                        return;
                    }
                    if (trh != null) {
                        total = trh.handleTotal(skip);
                    }
                }
                if (mrh != null) {
                    ResultSetMetaData md = rs.getMetaData();
                    mrh.handleMeta(md);
                }
                for (resultsFetched = 0; (max <= -1 || resultsFetched < max) && rs.next(); ++resultsFetched) {
                    if (mrh != null) {
                        mrh.handleRow(rs);
                        continue;
                    }
                    Object[] columnValues = resultMap.resolveSubMap(statementScope, rs).getResults(statementScope, rs);
                    callback.handleResultObject(statementScope, columnValues, rs);
                }
                if (trh != null) {
                    while (rs.next()) {
                        ++resultsFetched;
                    }
                    total = trh.handleTotal(resultsFetched);
                }
            }
            statementScope.getErrorContext().setTotal(total);
        }
        finally {
            statementScope.setResultSet(null);
        }
    }

    private void retrieveOutputParameters(StatementScope statementScope, CallableStatement cs, ParameterMapping[] mappings, Object[] parameters, RowHandlerCallback callback) throws SQLException {
        for (int i = 0; i < mappings.length; ++i) {
            ParameterMapping mapping = mappings[i];
            if (!mapping.isOutputAllowed()) continue;
            if ("java.sql.ResultSet".equalsIgnoreCase(mapping.getJavaTypeName())) {
                ResultMap resultMap;
                ResultSet rs = (ResultSet)cs.getObject(i + 1);
                if (mapping.getResultMapName() == null) {
                    resultMap = statementScope.getResultMap();
                    this.handleOutputParameterResults(statementScope, resultMap, rs, callback);
                } else {
                    SqlMapClientImpl client = (SqlMapClientImpl)statementScope.getSession().getSqlMapClient();
                    resultMap = client.getDelegate().getResultMap(mapping.getResultMapName());
                    DefaultRowHandler rowHandler = new DefaultRowHandler();
                    RowHandlerCallback handlerCallback = new RowHandlerCallback(resultMap, null, rowHandler);
                    this.handleOutputParameterResults(statementScope, resultMap, rs, handlerCallback);
                    parameters[i] = rowHandler.getList();
                }
                rs.close();
                continue;
            }
            parameters[i] = mapping.getTypeHandler().getResult(cs, i + 1);
        }
    }

    private void registerOutputParameters(CallableStatement cs, ParameterMapping[] mappings) throws SQLException {
        for (int i = 0; i < mappings.length; ++i) {
            ParameterMapping mapping = mappings[i];
            if (!mapping.isOutputAllowed()) continue;
            if (null != mapping.getTypeName() && !mapping.getTypeName().isEmpty()) {
                cs.registerOutParameter(i + 1, mapping.getJdbcType(), mapping.getTypeName());
                continue;
            }
            if (mapping.getNumericScale() != null && (mapping.getJdbcType() == 2 || mapping.getJdbcType() == 3)) {
                cs.registerOutParameter(i + 1, mapping.getJdbcType(), (int)mapping.getNumericScale());
                continue;
            }
            cs.registerOutParameter(i + 1, mapping.getJdbcType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutputParameterResults(StatementScope statementScope, ResultMap resultMap, ResultSet rs, RowHandlerCallback callback) throws SQLException {
        ResultMap orig = statementScope.getResultMap();
        try {
            statementScope.setResultSet(rs);
            if (resultMap != null) {
                statementScope.setResultMap(resultMap);
                while (rs.next()) {
                    Object[] columnValues = resultMap.resolveSubMap(statementScope, rs).getResults(statementScope, rs);
                    callback.handleResultObject(statementScope, columnValues, rs);
                }
            }
        }
        finally {
            statementScope.setResultSet(null);
            statementScope.setResultMap(orig);
        }
    }

    @Override
    public void cleanup(SessionScope sessionScope) {
        Batch batch = sessionScope.getBatch();
        if (batch != null) {
            if (!batch.isCleanup()) {
                batch.cleanupBatch(sessionScope);
            }
            sessionScope.setBatch(null);
        }
    }

    private static PreparedStatement prepareStatement(SessionScope sessionScope, Connection conn, String sql, Integer rsType) throws SQLException {
        Object key = Objects.getKey(sql, rsType, 1007);
        SqlMapExecutorDelegate delegate = ((SqlMapClientImpl)sessionScope.getSqlMapExecutor()).getDelegate();
        if (sessionScope.hasPreparedStatementFor(key)) {
            return sessionScope.getPreparedStatement(key);
        }
        PreparedStatement ps = conn.prepareStatement(sql, rsType, 1007);
        sessionScope.putPreparedStatement(delegate, key, ps);
        return ps;
    }

    private static CallableStatement prepareCall(SessionScope sessionScope, Connection conn, String sql, Integer rsType) throws SQLException {
        Object key = Objects.getKey("call", sql, rsType, 1007);
        SqlMapExecutorDelegate delegate = ((SqlMapClientImpl)sessionScope.getSqlMapExecutor()).getDelegate();
        if (sessionScope.hasPreparedStatementFor(key)) {
            return (CallableStatement)sessionScope.getPreparedStatement(key);
        }
        CallableStatement cs = conn.prepareCall(sql, rsType, 1007);
        sessionScope.putPreparedStatement(delegate, key, cs);
        return cs;
    }

    static PreparedStatement prepareStatement(SessionScope sessionScope, Connection conn, String sql, boolean genKey) throws SQLException {
        Object key = Objects.getKey(sql, genKey);
        SqlMapExecutorDelegate delegate = ((SqlMapClientImpl)sessionScope.getSqlMapExecutor()).getDelegate();
        if (sessionScope.hasPreparedStatementFor(key)) {
            return sessionScope.getPreparedStatement(key);
        }
        PreparedStatement ps = genKey ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
        sessionScope.putPreparedStatement(delegate, key, ps);
        return ps;
    }

    static CallableStatement prepareCall(SessionScope sessionScope, Connection conn, String sql) throws SQLException {
        Object key = Objects.getKey("call", sql);
        SqlMapExecutorDelegate delegate = ((SqlMapClientImpl)sessionScope.getSqlMapExecutor()).getDelegate();
        if (sessionScope.hasPreparedStatementFor(key)) {
            return (CallableStatement)sessionScope.getPreparedStatement(key);
        }
        CallableStatement cs = conn.prepareCall(sql);
        sessionScope.putPreparedStatement(delegate, key, cs);
        return cs;
    }

    static void closeStatement(SessionScope sessionScope, PreparedStatement ps) {
        if (ps != null && !sessionScope.hasPreparedStatement(ps)) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static void setStatementTimeout(MappedStatement mappedStatement, Statement statement) throws SQLException {
        if (mappedStatement != null && mappedStatement.getTimeout() != null) {
            statement.setQueryTimeout(mappedStatement.getTimeout());
        }
    }

    private void setupResultObjectFactory(StatementScope statementScope) {
        SqlMapClientImpl client = (SqlMapClientImpl)statementScope.getSession().getSqlMapClient();
        String sid = null;
        if (statementScope.getStatement() != null) {
            sid = statementScope.getStatement().getId();
        }
        ResultObjectFactoryUtil.setupResultObjectFactory(client.getResultObjectFactory(), sid);
    }

    private void cleanupResultObjectFactory() {
        ResultObjectFactoryUtil.cleanupResultObjectFactory();
    }

    @Override
    public boolean isDebugSql() {
        return false;
    }

    @Override
    public boolean isTraceSql() {
        return false;
    }

    @Override
    public boolean isCheckSql() {
        return false;
    }
}

