/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.client.BatchResult;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.impl.SqlMapSessionImpl;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.ibatis.client.Cache;
import org.ibatis.client.Dialect;
import org.ibatis.client.SqlMapClient;
import org.ibatis.persist.criteria.CriteriaBuilder;
import org.ibatis.persist.criteria.CriteriaDelete;
import org.ibatis.persist.criteria.CriteriaQuery;
import org.ibatis.persist.criteria.CriteriaUpdate;
import org.ibatis.persist.meta.EntityType;

public class SqlMapClientImpl
implements com.ibatis.sqlmap.client.SqlMapClient,
ExtendedSqlMapClient,
SqlMapClient {
    static final ILog log = ILogFactory.getLog(SqlMapClientImpl.class);
    public SqlMapExecutorDelegate delegate;
    protected ThreadLocal<SqlMapSessionImpl> localSqlMapSession = new ThreadLocal();
    DataSource dataSource;

    public SqlMapClientImpl(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> T insert(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().insert(id, param);
    }

    @Override
    public <T> T insert(String id) throws SQLException {
        return this.getLocalSqlMapSession().insert(id);
    }

    @Override
    public int update(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().update(id, param);
    }

    @Override
    public int update(String id) throws SQLException {
        return this.getLocalSqlMapSession().update(id);
    }

    @Override
    public int delete(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSession().delete(id, param);
    }

    @Override
    public int delete(String id) throws SQLException {
        return this.getLocalSqlMapSession().delete(id);
    }

    @Override
    public <T> T queryForObject(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id, paramObject);
    }

    @Override
    public <T> T queryForObject(String id) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id);
    }

    @Override
    public <T> T queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForObject(id, paramObject, resultObject);
    }

    @Override
    public <T> List<T> queryForList(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject);
    }

    @Override
    public <T> List<T> queryForList(String id) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id);
    }

    @Override
    public <T> List<T> queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, paramObject, skip, max);
    }

    @Override
    public <T> List<T> queryForList(String id, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSession().queryForList(id, skip, max);
    }

    @Override
    public <K, V> Map<K, V> queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp);
    }

    @Override
    public <K, V> Map<K, V> queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp, valueProp);
    }

    @Override
    public <K, V> Map<K, V> queryForMap(String id, Object paramObject, String keyProp, Class<K> keyType, String valueProp, Class<V> valueType) throws SQLException {
        return this.getLocalSqlMapSession().queryForMap(id, paramObject, keyProp, keyType, valueProp, valueType);
    }

    @Override
    public void queryWithRowHandler(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        this.getLocalSqlMapSession().queryWithRowHandler(id, paramObject, rowHandler);
    }

    @Override
    public void queryWithRowHandler(String id, RowHandler rowHandler) throws SQLException {
        this.getLocalSqlMapSession().queryWithRowHandler(id, rowHandler);
    }

    @Override
    public void startTransaction() throws SQLException {
        this.getLocalSqlMapSession().startTransaction();
    }

    @Override
    public void startTransaction(int transactionIsolation) throws SQLException {
        this.getLocalSqlMapSession().startTransaction(transactionIsolation);
    }

    @Override
    public void commitTransaction() throws SQLException {
        this.getLocalSqlMapSession().commitTransaction();
    }

    @Override
    public void endTransaction() throws SQLException {
        try {
            this.getLocalSqlMapSession().endTransaction();
        }
        finally {
            this.getLocalSqlMapSession().close();
            this.localSqlMapSession.remove();
        }
    }

    @Override
    public void startBatch() throws SQLException {
        this.getLocalSqlMapSession().startBatch(-1);
    }

    @Override
    public void startBatch(int batchSize) throws SQLException {
        this.getLocalSqlMapSession().startBatch(batchSize);
    }

    @Override
    public int executeBatch() throws SQLException {
        return this.getLocalSqlMapSession().executeBatch();
    }

    @Override
    public List<BatchResult> executeBatchDetailed() throws SQLException, BatchException {
        return this.getLocalSqlMapSession().executeBatchDetailed();
    }

    @Override
    public void setUserConnection(Connection connection) throws SQLException {
        try {
            this.getLocalSqlMapSession().setUserConnection(connection);
        }
        finally {
            if (connection == null) {
                this.getLocalSqlMapSession().close();
            }
        }
    }

    @Override
    public Connection getCurrentConnection() throws SQLException {
        return this.getLocalSqlMapSession().getCurrentConnection();
    }

    @Override
    public DataSource getDataSource() {
        return this.delegate.getDataSource();
    }

    @Override
    public MappedStatement getMappedStatement(String id) {
        return this.delegate.getMappedStatement(id);
    }

    @Override
    public boolean isLazyLoadingEnabled() {
        return this.delegate.isLazyLoadingEnabled();
    }

    @Override
    public boolean isEnhancementEnabled() {
        return this.delegate.isEnhancementEnabled();
    }

    @Override
    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    @Override
    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public SqlMapSession openSession() {
        SqlMapSessionImpl sqlMapSession = new SqlMapSessionImpl(this);
        sqlMapSession.open();
        return sqlMapSession;
    }

    @Override
    public SqlMapSession openSession(Connection conn) {
        try {
            SqlMapSessionImpl sqlMapSession = new SqlMapSessionImpl(this);
            sqlMapSession.open();
            sqlMapSession.setUserConnection(conn);
            return sqlMapSession;
        }
        catch (SQLException e) {
            throw new SqlMapException("Error setting user provided connection.  Cause: " + e, e);
        }
    }

    @Override
    public void flushDataCache() {
        this.delegate.flushDataCache();
    }

    @Override
    public void flushDataCache(String cacheId) {
        this.delegate.flushDataCache(cacheId);
    }

    @Override
    public void flushEntityCache(Class<?> entityClass) {
        this.delegate.getEntityManager().flushEntityCache(entityClass);
    }

    protected SqlMapSessionImpl getLocalSqlMapSession() {
        SqlMapSessionImpl sqlMapSession = this.localSqlMapSession.get();
        if (sqlMapSession == null || sqlMapSession.isClosed()) {
            sqlMapSession = new SqlMapSessionImpl(this);
            this.localSqlMapSession.set(sqlMapSession);
        }
        return sqlMapSession;
    }

    @Override
    public ResultObjectFactory getResultObjectFactory() {
        return this.delegate.getResultObjectFactory();
    }

    @Override
    public <T> int queryForPage(List<T> page, String id, Object paramObject, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSession().queryForPage(page, id, paramObject, skip, max);
    }

    @Override
    public <T> int queryForPage(List<T> page, String id, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSession().queryForPage(page, id, skip, max);
    }

    @Override
    public <E> E insertEntity(Class<E> cls, E entity) throws SQLException {
        return this.getLocalSqlMapSession().insertEntity(cls, entity);
    }

    @Override
    public <E, K> int updateEntity(Class<E> cls, E entity) throws SQLException {
        return this.getLocalSqlMapSession().updateEntity(cls, entity);
    }

    @Override
    public <E, K> int deleteEntity(Class<E> cls, K key) throws SQLException {
        return this.getLocalSqlMapSession().deleteEntity(cls, key);
    }

    @Override
    public <E, K> E findEntity(Class<E> cls, K key) throws SQLException {
        return this.getLocalSqlMapSession().findEntity(cls, key);
    }

    @Override
    public <E> EntityType<E> initEntityClass(Class<E> entityClass) {
        return this.getLocalSqlMapSession().initEntityClass(entityClass);
    }

    @Override
    public <T> T executeQueryObject(CriteriaQuery<T> criteriaQuery) {
        return this.getLocalSqlMapSession().executeQueryObject(criteriaQuery);
    }

    @Override
    public <T> List<T> executeQuery(CriteriaQuery<T> criteriaQuery) {
        return this.getLocalSqlMapSession().executeQuery(criteriaQuery);
    }

    @Override
    public <T> List<T> executeQuery(CriteriaQuery<T> criteriaQuery, int startPosition, int maxResult) {
        return this.getLocalSqlMapSession().executeQuery(criteriaQuery, startPosition, maxResult);
    }

    @Override
    public <T> int executeQueryPage(CriteriaQuery<T> criteriaQuery, List<T> page, int startPosition, int maxResult) {
        return this.getLocalSqlMapSession().executeQueryPage(criteriaQuery, page, startPosition, maxResult);
    }

    @Override
    public <T> int executeUpdate(CriteriaUpdate<T> updateQuery) {
        return this.getLocalSqlMapSession().executeUpdate(updateQuery);
    }

    @Override
    public <T> int executeDelete(CriteriaDelete<T> deleteQuery) {
        return this.getLocalSqlMapSession().executeDelete(deleteQuery);
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.getLocalSqlMapSession().getCriteriaBuilder();
    }

    @Override
    public ResultSet queryForResultSet(String id, Object parameterObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForResultSet(id, parameterObject);
    }

    @Override
    public <T> T insertArgs(String id, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().insertArgs(id, args);
    }

    @Override
    public int updateArgs(String id, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().updateArgs(id, args);
    }

    @Override
    public int deleteArgs(String id, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().deleteArgs(id, args);
    }

    @Override
    public <T> List<T> queryForListArgs(String id, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForListArgs(id, args);
    }

    @Override
    public <T> List<T> queryForListArgs(int skip, int max, String id, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForListArgs(skip, max, id, args);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForMapArgs(id, keyProp, args);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, String valueProp, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForMapArgs(id, keyProp, valueProp, args);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, Class<K> keyType, String valueProp, Class<V> valueType, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForMapArgs(id, keyProp, keyType, valueProp, valueType, args);
    }

    @Override
    public <T> T queryForObjectArgs(String id, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForObjectArgs(id, args);
    }

    @Override
    public <T> int queryForPageArgs(List<T> page, String id, int skip, int max, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForPageArgs(page, id, skip, max, args);
    }

    @Override
    public <T> T queryForFirstArgs(String id, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForFirstArgs(id, args);
    }

    @Override
    public <T> T queryForFirst(String id) throws SQLException {
        return this.getLocalSqlMapSession().queryForFirst(id);
    }

    @Override
    public <T> T queryForFirst(String id, Object parameterObject) throws SQLException {
        return this.getLocalSqlMapSession().queryForFirst(id, parameterObject);
    }

    @Override
    public void queryWithRowHandlerArgs(String id, RowHandler rowHandler, Object ... args) throws SQLException {
        this.getLocalSqlMapSession().queryWithRowHandlerArgs(id, rowHandler, args);
    }

    @Override
    public ResultSet queryForResultSetArgs(String id, Object ... args) throws SQLException {
        return this.getLocalSqlMapSession().queryForResultSetArgs(id, args);
    }

    @Override
    public ResultSet queryForResultSet(String id) throws SQLException {
        return this.getLocalSqlMapSession().queryForResultSet(id);
    }

    @Override
    public String getGlobalProperty(String name) {
        return this.getDelegate().getState().getGlobalProps().getProperty(name);
    }

    @Override
    public Dialect getDialect() {
        return this.getDelegate().getState().getDialect();
    }

    public void setRealDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DataSource getRealDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        return this.getDataSource().unwrap(DataSource.class);
    }

    @Override
    public Cache getCache(String id) {
        return this.getDelegate().findCacheModel(id);
    }
}

