/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.Objects;
import com.ibatis.common.RunStats;
import com.ibatis.common.Touchable;
import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.BatchResult;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.cache.CacheRoot;
import com.ibatis.sqlmap.engine.cache.CacheRoots;
import com.ibatis.sqlmap.engine.cache.FlushListener;
import com.ibatis.sqlmap.engine.cache.NoneCacheController;
import com.ibatis.sqlmap.engine.dialect.LimitOffsetPageDialect;
import com.ibatis.sqlmap.engine.dialect.OffsetFetchPageDialect;
import com.ibatis.sqlmap.engine.dialect.PageDialect;
import com.ibatis.sqlmap.engine.exchange.DataExchangeFactory;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.DefaultSqlExecutor;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.Discriminator;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.MappedRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.SelectKeyStatement;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.transaction.TransactionState;
import com.ibatis.sqlmap.engine.transaction.user.UserProvidedTransaction;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.ibatis.client.Cache;
import org.ibatis.client.Dialect;
import org.ibatis.persist.impl.EntityManager;
import org.ibatis.persist.impl.ExecuteContext;

public class SqlMapExecutorDelegate
implements Touchable {
    static final ILog log = ILogFactory.getLog(SqlMapExecutorDelegate.class);
    private static final Probe PROBE = ProbeFactory.getProbe();
    private boolean lazyLoadingEnabled = false;
    private boolean cacheModelsEnabled = true;
    private boolean enhancementEnabled = true;
    private boolean databasePagingQueryEnabled = true;
    private boolean useColumnLabel = true;
    private boolean forceMultipleResultSetSupport;
    private Integer jdbcTypeForNull;
    private String defaultCacheModelType = "MEMORY";
    private String forceCacheModelType;
    private TransactionManager txManager;
    private HashMap<String, MappedStatement> mappedStatements;
    private final Map<String, CacheModel> cacheModels;
    private final CacheRoots cacheRoots = new CacheRoots();
    private HashMap<String, ResultMap> resultMaps;
    private HashMap<String, ParameterMap> parameterMaps;
    protected SqlExecutor sqlExecutor;
    private TypeHandlerFactory typeHandlerFactory;
    private DataExchangeFactory dataExchangeFactory;
    private ResultObjectFactory resultObjectFactory;
    private boolean statementCacheEnabled = true;
    private final EntityManager entityManager;
    final XmlParserState state;
    private String productName;
    private int majorVersion;
    private int minorVersion;
    final FlushListener err = new FlushListener(){

        @Override
        public void onFlush(String id, long timestamp) {
            log.error("cache '" + id + "' flushed.", new Exception("just for stack"));
        }
    };
    final FlushListener info = new FlushListener(){

        @Override
        public void onFlush(String id, long timestamp) {
            log.info("cache '" + id + "' flushed.");
        }
    };

    public SqlMapExecutorDelegate(XmlParserState state) {
        this.mappedStatements = new HashMap();
        this.cacheModels = new HashMap<String, CacheModel>();
        this.resultMaps = new HashMap();
        this.parameterMaps = new HashMap();
        this.sqlExecutor = new DefaultSqlExecutor(this);
        this.typeHandlerFactory = new TypeHandlerFactory();
        this.dataExchangeFactory = new DataExchangeFactory(this.typeHandlerFactory);
        this.entityManager = new EntityManager(this, state);
        this.state = state;
        RunStats.getInstance().addTouchable(this);
    }

    public XmlParserState getState() {
        return this.state;
    }

    public CacheRoots getCacheRoots() {
        return this.cacheRoots;
    }

    public void setCustomExecutor(String sqlExecutorClass) {
        try {
            Class<?> factoryClass = Class.forName(sqlExecutorClass);
            this.sqlExecutor = (SqlExecutor)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new SqlMapException("Error instantiating " + sqlExecutorClass + ". Please check the class given in properties file. Cause: " + e, e);
        }
    }

    public DataExchangeFactory getDataExchangeFactory() {
        return this.dataExchangeFactory;
    }

    public TypeHandlerFactory getTypeHandlerFactory() {
        return this.typeHandlerFactory;
    }

    public boolean isLazyLoadingEnabled() {
        return this.lazyLoadingEnabled;
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.lazyLoadingEnabled = lazyLoadingEnabled;
    }

    public boolean isCacheModelsEnabled() {
        return this.cacheModelsEnabled;
    }

    public void setCacheModelsEnabled(boolean cacheModelsEnabled) {
        this.cacheModelsEnabled = cacheModelsEnabled;
    }

    public boolean isEnhancementEnabled() {
        return this.enhancementEnabled;
    }

    public void setEnhancementEnabled(boolean enhancementEnabled) {
        this.enhancementEnabled = enhancementEnabled;
    }

    public boolean isDatabasePagingQueryEnabled() {
        return this.databasePagingQueryEnabled;
    }

    public void setDatabasePagingQueryEnabled(boolean databasePagingQueryEnabled) {
        this.databasePagingQueryEnabled = databasePagingQueryEnabled;
    }

    public boolean isUseColumnLabel() {
        return this.useColumnLabel;
    }

    public void setUseColumnLabel(boolean useColumnLabel) {
        this.useColumnLabel = useColumnLabel;
    }

    public Integer getJdbcTypeForNull() {
        return this.jdbcTypeForNull;
    }

    public void setJdbcTypeForNull(Integer jdbcTypeForNull) {
        this.jdbcTypeForNull = jdbcTypeForNull;
    }

    public String getDefaultCacheModelType() {
        return this.defaultCacheModelType;
    }

    public void setDefaultCacheModelType(String defaultCacheModelType) {
        this.defaultCacheModelType = defaultCacheModelType;
    }

    public String getForceCacheModelType() {
        return this.forceCacheModelType;
    }

    public void setForceCacheModelType(String forceCacheModelType) {
        this.forceCacheModelType = forceCacheModelType;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public void setTxManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    public void addMappedStatement(MappedStatement ms, int base) {
        MappedStatement old = this.mappedStatements.get(ms.getId());
        if (old != null && (old.getBaseCacheKey() != base || old.getClass() != ms.getClass())) {
            throw new SqlMapException("There is already a statement named " + ms.getId() + " in " + old.getResource());
        }
        ms.setBaseCacheKey(base);
        this.mappedStatements.put(ms.getId(), ms);
    }

    public Set<String> getMappedStatementNames() {
        return this.mappedStatements.keySet();
    }

    public MappedStatement getMappedStatement(String id) {
        MappedStatement ms;
        String did;
        if (this.state.getDialect() != null && this.mappedStatements.containsKey(did = id + "." + (Object)((Object)this.state.getDialect()))) {
            id = did;
        }
        if ((ms = this.mappedStatements.get(id)) == null) {
            throw new SqlMapException("There is no statement named " + id + " in this SqlMap.");
        }
        return ms;
    }

    public synchronized void addCacheModel(CacheModel model) {
        this.cacheModels.put(model.getId(), model);
    }

    public Set<String> getCacheModelNames() {
        return this.cacheModels.keySet();
    }

    public CacheModel getCacheModel(String id) {
        CacheModel model = this.cacheModels.get(id);
        if (model == null) {
            throw new SqlMapException("There is no cache model named " + id + " in this SqlMap.");
        }
        return model;
    }

    public synchronized CacheModel findCacheModel(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        CacheModel model = this.cacheModels.get(id);
        if (model != null) {
            return model;
        }
        if (id.indexOf(46) > 0) {
            return null;
        }
        if (!id.startsWith(".")) {
            id = "." + id;
        }
        for (String name : this.getCacheModelNames()) {
            if (!name.endsWith(id)) continue;
            return this.cacheModels.get(name);
        }
        return null;
    }

    public synchronized Cache[] getCacheModels() {
        return this.cacheModels.values().toArray(new Cache[0]);
    }

    public void addResultMap(ResultMap map) {
        this.resultMaps.put(map.getId(), map);
    }

    public Set<String> getResultMapNames() {
        return this.resultMaps.keySet();
    }

    public ResultMap getResultMap(String id) {
        ResultMap map = this.resultMaps.get(id);
        if (map == null) {
            throw new SqlMapException("There is no result map named " + id + " in this SqlMap.");
        }
        return map;
    }

    public void addParameterMap(ParameterMap map) {
        this.parameterMaps.put(map.getId(), map);
    }

    public Set<String> getParameterMapNames() {
        return this.parameterMaps.keySet();
    }

    public ParameterMap getParameterMap(String id) {
        ParameterMap map = this.parameterMaps.get(id);
        if (map == null) {
            throw new SqlMapException("There is no parameter map named " + id + " in this SqlMap.");
        }
        return map;
    }

    public synchronized void flushDataCache() {
        long time = System.currentTimeMillis();
        for (CacheModel cache : this.cacheModels.values()) {
            cache.onFlush(cache.getId(), time);
        }
        log.debug("All data caches flushed.");
    }

    public void flushDataCache(String id) {
        CacheModel model = this.findCacheModel(id);
        if (model != null) {
            model.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T insert(SessionScope sessionScope, String id, Object param) throws SQLException {
        Object generatedKey = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            SelectKeyStatement ks = null;
            if (ms instanceof InsertStatement) {
                ks = ((InsertStatement)ms).getSelectKeyStatement();
            }
            Object oldKeyValue = null;
            String keyProperty = null;
            boolean resetKeyValueOnFailure = false;
            if (ks != null && !ks.isRunAfterSQL()) {
                keyProperty = ks.getKeyProperty();
                oldKeyValue = PROBE.getObject(param, keyProperty);
                generatedKey = this.executeSelectKey(sessionScope, trans, ms, param);
                resetKeyValueOnFailure = true;
            }
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                if (ks != null && ks.isRunAfterSQL() && ks.isGeneratedKeys()) {
                    generatedKey = ((InsertStatement)ms).executeInsert(statementScope, trans, param);
                } else {
                    int rows = ms.executeUpdate(statementScope, trans, param);
                    if (ks == null) {
                        generatedKey = rows;
                    }
                }
            }
            catch (SQLException e) {
                if (resetKeyValueOnFailure) {
                    PROBE.setObject(param, keyProperty, oldKeyValue);
                }
                throw e;
            }
            finally {
                this.endStatementScope(statementScope);
            }
            if (ks != null && ks.isRunAfterSQL() && !ks.isGeneratedKeys()) {
                generatedKey = this.executeSelectKey(sessionScope, trans, ms, param);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return Objects.uncheckedCast(generatedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeSelectKey(SessionScope sessionScope, Transaction trans, MappedStatement ms, Object param) throws SQLException {
        Object generatedKey = null;
        InsertStatement insert = (InsertStatement)ms;
        SelectKeyStatement selectKeyStatement = insert.getSelectKeyStatement();
        if (selectKeyStatement != null) {
            StatementScope statementScope = this.beginStatementScope(sessionScope, selectKeyStatement);
            try {
                generatedKey = selectKeyStatement.executeQueryForObject(statementScope, trans, param, null);
                String keyProp = selectKeyStatement.getKeyProperty();
                if (keyProp != null) {
                    PROBE.setObject(param, keyProp, generatedKey);
                }
            }
            finally {
                this.endStatementScope(statementScope);
            }
        }
        return generatedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(SessionScope sessionScope, String id, Object param) throws SQLException {
        int rows = 0;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                rows = ms.executeUpdate(statementScope, trans, param);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return rows;
    }

    public int delete(SessionScope sessionScope, String id, Object param) throws SQLException {
        return this.update(sessionScope, id, param);
    }

    public <T> T queryForObject(SessionScope sessionScope, String id, Object paramObject) throws SQLException {
        return this.queryForObject(sessionScope, id, paramObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T queryForObject(SessionScope sessionScope, String id, Object paramObject, Object resultObject) throws SQLException {
        Object object = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                object = ms.executeQueryForObject(statementScope, trans, paramObject, resultObject);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return Objects.uncheckedCast(object);
    }

    public <T> List<T> queryForList(SessionScope sessionScope, String id, Object paramObject) throws SQLException {
        return this.queryForList(sessionScope, id, paramObject, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> queryForList(SessionScope sessionScope, String id, Object paramObject, int skip, int max) throws SQLException {
        List list = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                list = ms.executeQueryForList(statementScope, trans, paramObject, skip, max);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryWithRowHandler(SessionScope sessionScope, String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                ms.executeQueryWithRowHandler(statementScope, trans, paramObject, rowHandler);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
    }

    public <K, V> Map<K, V> queryForMap(SessionScope sessionScope, String id, Object paramObject, String keyProp, Class<K> keyType, String valueProp, Class<V> valueType) throws SQLException {
        MappedStatement ms = this.getMappedStatement(id);
        if (ms.getResultMap() == null && valueProp != null) {
            MappedRowHandler<K, V> mapHandler = new MappedRowHandler<K, V>(this.getTypeHandlerFactory(), this.isUseColumnLabel(), keyProp, keyType, valueProp, valueType);
            this.queryWithMapHandler(sessionScope, id, paramObject, mapHandler);
            return mapHandler.getMap();
        }
        List list = this.queryForList(sessionScope, id, paramObject);
        LinkedHashMap map = new LinkedHashMap();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object = list.get(i);
            Object key = Objects.uncheckedCast(PROBE.getObject(object, keyProp));
            Object value = null;
            value = valueProp == null ? (Object)object : (Object)Objects.uncheckedCast(PROBE.getObject(object, valueProp));
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> void queryWithMapHandler(SessionScope sessionScope, String id, Object paramObject, MappedRowHandler<K, V> mrh) throws SQLException {
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                ms.executeQueryWithMapHandler(statementScope, trans, paramObject, 0, -1, mrh);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
    }

    private void initProduct(Transaction tx) {
        if (this.productName == null && tx != null) {
            try {
                DatabaseMetaData meta = tx.getConnection().getMetaData();
                this.majorVersion = meta.getDatabaseMajorVersion();
                this.minorVersion = meta.getDatabaseMinorVersion();
                this.productName = meta.getDatabaseProductName().toLowerCase();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            if (this.productName == null) {
                this.productName = "";
            }
        }
    }

    public void startTransaction(SessionScope sessionScope) throws SQLException {
        try {
            this.txManager.begin(sessionScope);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not start transaction.  Cause: " + e, e);
        }
    }

    public void startTransaction(SessionScope sessionScope, int transactionIsolation) throws SQLException {
        try {
            this.txManager.begin(sessionScope, transactionIsolation);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not start transaction.  Cause: " + e, e);
        }
    }

    public void commitTransaction(SessionScope sessionScope) throws SQLException {
        try {
            if (sessionScope.isInBatch()) {
                this.executeBatch(sessionScope);
            }
            this.sqlExecutor.cleanup(sessionScope);
            this.txManager.commit(sessionScope);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not commit transaction.  Cause: " + e, e);
        }
    }

    public void endTransaction(SessionScope sessionScope) throws SQLException {
        try {
            try {
                this.sqlExecutor.cleanup(sessionScope);
            }
            finally {
                this.txManager.end(sessionScope);
            }
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error while ending transaction.  Cause: " + e, e);
        }
    }

    public void startBatch(SessionScope sessionScope, int batchSize) throws SQLException {
        if (batchSize <= 0 && batchSize != -1) {
            throw new SQLException("Illegal batchSize: " + batchSize);
        }
        if (sessionScope.isInBatch()) {
            this.sqlExecutor.cleanup(sessionScope);
            sessionScope.setInBatch(0);
            throw new SQLException("Incorrect batch mode.\n  +-- Already in batch");
        }
        sessionScope.setInBatch(batchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeBatch(SessionScope sessionScope) throws SQLException {
        Transaction trans = this.getTransaction(sessionScope);
        if (trans == null) {
            sessionScope.setInBatch(0);
            sessionScope.autoBatch = false;
            return 0;
        }
        boolean autoBatch = sessionScope.autoBatch;
        int anwser = 0;
        try {
            sessionScope.setInBatch(0);
            sessionScope.autoBatch = false;
            anwser = this.sqlExecutor.executeBatch(sessionScope);
            if (autoBatch) {
                this.commitTransaction(sessionScope);
            }
        }
        finally {
            if (autoBatch) {
                this.endTransaction(sessionScope);
            }
        }
        return anwser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BatchResult> executeBatchDetailed(SessionScope sessionScope) throws SQLException, BatchException {
        Transaction trans = this.getTransaction(sessionScope);
        if (trans == null) {
            sessionScope.setInBatch(0);
            sessionScope.autoBatch = false;
            return Collections.emptyList();
        }
        boolean autoBatch = sessionScope.autoBatch;
        List<BatchResult> anwser = null;
        try {
            sessionScope.setInBatch(0);
            sessionScope.autoBatch = false;
            anwser = this.sqlExecutor.executeBatchDetailed(sessionScope);
            if (autoBatch) {
                this.commitTransaction(sessionScope);
            }
        }
        finally {
            if (autoBatch) {
                this.endTransaction(sessionScope);
            }
        }
        return anwser;
    }

    public void setUserProvidedTransaction(SessionScope sessionScope, Connection userConnection) {
        if (sessionScope.getTransactionState() == TransactionState.STATE_USER_PROVIDED) {
            sessionScope.recallTransactionState();
        }
        if (userConnection != null) {
            Connection conn = userConnection;
            sessionScope.saveTransactionState();
            sessionScope.setTransaction(new UserProvidedTransaction(conn));
            sessionScope.setTransactionState(TransactionState.STATE_USER_PROVIDED);
        } else {
            sessionScope.setTransaction(null);
            sessionScope.cleanup();
        }
    }

    public DataSource getDataSource() {
        DataSource ds = null;
        if (this.txManager != null) {
            ds = this.txManager.getConfig().getDataSource();
        }
        return ds;
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public Transaction getTransaction(SessionScope sessionScope) {
        Transaction tx = sessionScope.getTransaction();
        this.initProduct(tx);
        return tx;
    }

    protected void autoEndTransaction(SessionScope sessionScope, boolean autoStart) throws SQLException {
        if (autoStart && !sessionScope.autoBatch) {
            sessionScope.getSqlMapTxMgr().endTransaction();
        }
    }

    protected void autoCommitTransaction(SessionScope sessionScope, boolean autoStart) throws SQLException {
        if (autoStart && !sessionScope.autoBatch) {
            sessionScope.getSqlMapTxMgr().commitTransaction();
        }
    }

    protected Transaction autoStartTransaction(SessionScope sessionScope, boolean autoStart, Transaction trans) throws SQLException {
        Transaction transaction = trans;
        if (autoStart) {
            sessionScope.getSqlMapTxMgr().startTransaction();
            transaction = this.getTransaction(sessionScope);
            sessionScope.autoBatch = sessionScope.isInBatch();
        }
        return transaction;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    protected StatementScope beginStatementScope(SessionScope sessionScope, MappedStatement mappedStatement) {
        StatementScope statementScope = new StatementScope(sessionScope);
        if (mappedStatement != null) {
            mappedStatement.initRequest(statementScope);
        }
        return statementScope;
    }

    protected void endStatementScope(StatementScope statementScope) {
    }

    protected SessionScope beginSessionScope() {
        return new SessionScope();
    }

    protected void endSessionScope(SessionScope sessionScope) {
        sessionScope.cleanup();
    }

    public ResultObjectFactory getResultObjectFactory() {
        return this.resultObjectFactory;
    }

    public void setResultObjectFactory(ResultObjectFactory resultObjectFactory) {
        this.resultObjectFactory = resultObjectFactory;
    }

    public boolean isStatementCacheEnabled() {
        return this.statementCacheEnabled;
    }

    public void setStatementCacheEnabled(boolean statementCacheEnabled) {
        this.statementCacheEnabled = statementCacheEnabled;
    }

    public boolean isForceMultipleResultSetSupport() {
        return this.forceMultipleResultSetSupport;
    }

    public void setForceMultipleResultSetSupport(boolean forceMultipleResultSetSupport) {
        this.forceMultipleResultSetSupport = forceMultipleResultSetSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int queryForPage(SessionScope sessionScope, List<T> page, String id, Object paramObject, int skip, int max) throws SQLException {
        int total = -1;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                total = ms.executeQueryForPage(statementScope, page, trans, paramObject, skip, max);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeCallback(SessionScope sessionScope, ExecuteContext<T> callback) throws SQLException {
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        T t = null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, null);
            try {
                t = callback.execute(statementScope, trans);
            }
            catch (SQLException e) {
                throw new NestedSQLException(statementScope.getErrorContext().toString(), e);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return t;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public String getGlobalProperty(String name) {
        return this.state.getGlobalProps().getProperty(name);
    }

    public synchronized void finalizeSqlMapConfig() {
        this.wireUpCacheModels();
        this.bindResultMapDiscriminators();
    }

    void wireUpCacheModels() {
        Set<String> cacheNames = this.getCacheModelNames();
        for (String cacheName : cacheNames) {
            Object statementName2;
            CacheModel cacheModel = this.getCacheModel(cacheName);
            Set<String> triggerCacheRoots = cacheModel.getFlushTriggerCacheRoots();
            for (String string : triggerCacheRoots) {
                CacheRoot cacheRoot = this.getCacheRoots().makeRoot(string);
                cacheRoot.addFlushListener(cacheModel);
            }
            Set<String> statementNames = cacheModel.getFlushTriggerStatementNames();
            for (Object statementName2 : statementNames) {
                MappedStatement statement = null;
                try {
                    statement = this.getMappedStatement((String)statementName2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (statement != null) {
                    statement.addExecuteListener(cacheModel);
                    continue;
                }
                log.warn("Could not find statement named '" + (String)statementName2 + "' for use as a flush trigger for the cache model named '" + cacheName + "'.");
            }
            Set<String> set = cacheModel.getFlushTriggerCacheNames();
            statementName2 = set.iterator();
            while (statementName2.hasNext()) {
                String triggerCacheName = (String)statementName2.next();
                CacheModel triggerCacheModel = this.findCacheModel(triggerCacheName);
                if (triggerCacheModel != null) {
                    triggerCacheModel.addFlushListener(cacheModel);
                    continue;
                }
                log.warn("Could not find cache named '" + triggerCacheName + "' for use as a flush trigger for the cache model named '" + cacheName + "'.");
            }
            Set<Class<?>> triggerEntityClasses = cacheModel.getFlushTriggerEntityClasses();
            for (Class<?> triggerEntityClass : triggerEntityClasses) {
                Cache triggerCache = this.getEntityManager().findEntityCache(triggerEntityClass);
                if (!(triggerCache instanceof CacheModel)) continue;
                ((CacheModel)triggerCache).addFlushListener(cacheModel);
            }
        }
    }

    void bindResultMapDiscriminators() {
        Set<String> names = this.getResultMapNames();
        for (String name : names) {
            ResultMap rm = this.getResultMap(name);
            Discriminator disc = rm.getDiscriminator();
            if (disc == null) continue;
            disc.bindSubMaps();
        }
    }

    @Override
    public void onTouch(File file) {
        Properties p = new Properties();
        try (FileInputStream is = new FileInputStream(file);){
            p.load(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!"true".equals(p.getProperty("cache_flush_monitor"))) {
            return;
        }
        for (Cache c : this.getCacheModels()) {
            if (!(c instanceof CacheModel)) continue;
            CacheModel cm = (CacheModel)c;
            String type = p.getProperty(cm.getId() + ".onFlush");
            cm.removeFlushListener(this.err);
            cm.removeFlushListener(this.info);
            if ("error".equalsIgnoreCase(type)) {
                cm.addFlushListener(this.err);
                continue;
            }
            if (!"info".equalsIgnoreCase(type)) continue;
            cm.addFlushListener(this.info);
        }
    }

    public String toCacheModelType(String type) {
        String forceType = this.getForceCacheModelType();
        if (forceType != null) {
            return forceType;
        }
        if (type == null || type.isEmpty()) {
            return this.getDefaultCacheModelType();
        }
        return type;
    }

    public CacheController newCacheController(String type) throws Exception {
        if ("None".equals(type = this.toCacheModelType(type))) {
            return NoneCacheController.INSTANCE;
        }
        type = this.getTypeHandlerFactory().resolveAlias(type);
        Class<?> clazz = Resources.classForName(type);
        return (CacheController)Resources.instantiate(clazz);
    }

    public PageDialect getPageDialect(String id, String sql, boolean needTotal, int skip, int max) {
        Dialect d = this.state.getDialect();
        if (this.databasePagingQueryEnabled && max > -1 && d != null) {
            switch (d) {
                case mysql: {
                    if (id != null && id.endsWith(".mysql")) break;
                    LimitOffsetPageDialect dialect = new LimitOffsetPageDialect(d, sql, needTotal, skip, max);
                    return dialect.canHandle(this.productName, this.majorVersion, this.minorVersion);
                }
                case postgresql: {
                    if (id != null && id.endsWith(".postgresql")) break;
                    LimitOffsetPageDialect dialect = new LimitOffsetPageDialect(d, sql, needTotal, skip, max);
                    return dialect.canHandle(this.productName, this.majorVersion, this.minorVersion);
                }
                case db2: {
                    if (id != null && id.endsWith(".db2")) break;
                    LimitOffsetPageDialect dialect = new LimitOffsetPageDialect(d, sql, needTotal, skip, max);
                    return dialect.canHandle(this.productName, this.majorVersion, this.minorVersion);
                }
                case sqlserver: {
                    if (id != null && id.endsWith(".sqlserver")) break;
                    OffsetFetchPageDialect dialect = new OffsetFetchPageDialect(d, sql, needTotal, skip, max);
                    return dialect.canHandle(this.productName, this.majorVersion, this.minorVersion);
                }
                case oracle: {
                    if (id != null && id.endsWith(".oracle")) break;
                    OffsetFetchPageDialect dialect = new OffsetFetchPageDialect(d, sql, needTotal, skip, max);
                    return dialect.canHandle(this.productName, this.majorVersion, this.minorVersion);
                }
            }
        }
        return null;
    }
}

