/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.ArrayMap;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.BatchResult;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.client.event.RowSetHandler;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.ibatis.persist.criteria.CriteriaBuilder;
import org.ibatis.persist.criteria.CriteriaDelete;
import org.ibatis.persist.criteria.CriteriaQuery;
import org.ibatis.persist.criteria.CriteriaUpdate;
import org.ibatis.persist.meta.EntityType;

public class SqlMapSessionImpl
implements SqlMapSession {
    protected SqlMapExecutorDelegate delegate;
    protected SessionScope sessionScope;
    protected boolean closed;

    public SqlMapSessionImpl(SqlMapClientImpl client) {
        this.delegate = client.getDelegate();
        this.sessionScope = this.delegate.beginSessionScope();
        this.sessionScope.setSqlMapClient(client);
        this.sessionScope.setSqlMapExecutor(client);
        this.sessionScope.setSqlMapTxMgr(client);
        this.closed = false;
    }

    public SessionScope getSessionScope() {
        return this.sessionScope;
    }

    public void open() {
        this.sessionScope.setSqlMapTxMgr(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.delegate != null && this.sessionScope != null) {
            this.delegate.endSessionScope(this.sessionScope);
        }
        if (this.sessionScope != null) {
            this.sessionScope = null;
        }
        if (this.delegate != null) {
            this.delegate = null;
        }
        if (!this.closed) {
            this.closed = true;
        }
    }

    @Override
    public <T> T insert(String id, Object param) throws SQLException {
        return this.delegate.insert(this.sessionScope, id, param);
    }

    @Override
    public <T> T insert(String id) throws SQLException {
        return this.insert(id, null);
    }

    @Override
    public int update(String id, Object param) throws SQLException {
        return this.delegate.update(this.sessionScope, id, param);
    }

    @Override
    public int update(String id) throws SQLException {
        return this.update(id, null);
    }

    @Override
    public int delete(String id, Object param) throws SQLException {
        return this.delegate.delete(this.sessionScope, id, param);
    }

    @Override
    public int delete(String id) throws SQLException {
        return this.delete(id, null);
    }

    @Override
    public <T> T queryForObject(String id, Object paramObject) throws SQLException {
        return this.delegate.queryForObject(this.sessionScope, id, paramObject);
    }

    @Override
    public <T> T queryForObject(String id) throws SQLException {
        return this.queryForObject(id, null);
    }

    @Override
    public <T> T queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.delegate.queryForObject(this.sessionScope, id, paramObject, resultObject);
    }

    @Override
    public <T> List<T> queryForList(String id, Object paramObject) throws SQLException {
        return this.delegate.queryForList(this.sessionScope, id, paramObject);
    }

    @Override
    public <T> List<T> queryForList(String id) throws SQLException {
        return this.queryForList(id, null);
    }

    @Override
    public <T> List<T> queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.delegate.queryForList(this.sessionScope, id, paramObject, skip, max);
    }

    @Override
    public <T> List<T> queryForList(String id, int skip, int max) throws SQLException {
        return this.queryForList(id, null, skip, max);
    }

    @Override
    public <K, V> Map<K, V> queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.delegate.queryForMap(this.sessionScope, id, paramObject, keyProp, null, null, null);
    }

    @Override
    public <K, V> Map<K, V> queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.delegate.queryForMap(this.sessionScope, id, paramObject, keyProp, null, valueProp, null);
    }

    @Override
    public <K, V> Map<K, V> queryForMap(String id, Object paramObject, String keyProp, Class<K> keyType, String valueProp, Class<V> valueType) throws SQLException {
        return this.delegate.queryForMap(this.sessionScope, id, paramObject, keyProp, keyType, valueProp, valueType);
    }

    @Override
    public void queryWithRowHandler(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        this.delegate.queryWithRowHandler(this.sessionScope, id, paramObject, rowHandler);
    }

    @Override
    public void queryWithRowHandler(String id, RowHandler rowHandler) throws SQLException {
        this.queryWithRowHandler(id, null, rowHandler);
    }

    @Override
    public void startTransaction() throws SQLException {
        this.delegate.startTransaction(this.sessionScope);
    }

    @Override
    public void startTransaction(int transactionIsolation) throws SQLException {
        this.delegate.startTransaction(this.sessionScope, transactionIsolation);
    }

    @Override
    public void commitTransaction() throws SQLException {
        this.delegate.commitTransaction(this.sessionScope);
    }

    @Override
    public void endTransaction() throws SQLException {
        this.delegate.endTransaction(this.sessionScope);
    }

    @Override
    public void startBatch() throws SQLException {
        this.delegate.startBatch(this.sessionScope, -1);
    }

    @Override
    public void startBatch(int batchSize) throws SQLException {
        this.delegate.startBatch(this.sessionScope, batchSize);
    }

    @Override
    public int executeBatch() throws SQLException {
        return this.delegate.executeBatch(this.sessionScope);
    }

    @Override
    public List<BatchResult> executeBatchDetailed() throws SQLException, BatchException {
        return this.delegate.executeBatchDetailed(this.sessionScope);
    }

    @Override
    public void setUserConnection(Connection connection) throws SQLException {
        this.delegate.setUserProvidedTransaction(this.sessionScope, connection);
    }

    @Override
    public Connection getCurrentConnection() throws SQLException {
        try {
            Connection conn = null;
            Transaction trans = this.delegate.getTransaction(this.sessionScope);
            if (trans != null) {
                conn = trans.getConnection();
            }
            return conn;
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.delegate.getDataSource();
    }

    public MappedStatement getMappedStatement(String id) {
        return this.delegate.getMappedStatement(id);
    }

    public boolean isLazyLoadingEnabled() {
        return this.delegate.isLazyLoadingEnabled();
    }

    public boolean isEnhancementEnabled() {
        return this.delegate.isEnhancementEnabled();
    }

    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public <T> int queryForPage(List<T> page, String id, Object paramObject, int skip, int max) throws SQLException {
        return this.delegate.queryForPage(this.sessionScope, page, id, paramObject, skip, max);
    }

    @Override
    public <T> int queryForPage(List<T> page, String id, int skip, int max) throws SQLException {
        return this.delegate.queryForPage(this.sessionScope, page, id, null, skip, max);
    }

    private Map<String, Object> toParameter(Object[] args) {
        if (args == null || args.length == 0) {
            return Collections.emptyMap();
        }
        return new ArrayMap(args);
    }

    @Override
    public <T> int queryForPageArgs(List<T> page, String id, int skip, int max, Object ... args) throws SQLException {
        return this.delegate.queryForPage(this.sessionScope, page, id, this.toParameter(args), skip, max);
    }

    @Override
    public <E> E insertEntity(Class<E> cls, E entity) throws SQLException {
        return this.delegate.getEntityManager().insertEntity(this.sessionScope, cls, entity);
    }

    @Override
    public <E, K> int updateEntity(Class<E> cls, E entity) throws SQLException {
        return this.delegate.getEntityManager().updateEntity(this.sessionScope, cls, entity);
    }

    @Override
    public <E, K> int deleteEntity(Class<E> cls, K key) throws SQLException {
        return this.delegate.getEntityManager().deleteEntity(this.sessionScope, cls, key);
    }

    @Override
    public <E, K> E findEntity(Class<E> cls, K key) throws SQLException {
        return this.delegate.getEntityManager().findEntity(this.sessionScope, cls, key);
    }

    @Override
    public <E> EntityType<E> initEntityClass(Class<E> entityClass) {
        return this.delegate.getEntityManager().initEntityClass(entityClass);
    }

    @Override
    public <T> T executeQueryObject(CriteriaQuery<T> criteriaQuery) {
        return this.delegate.getEntityManager().executeQueryObject(this.sessionScope, criteriaQuery);
    }

    @Override
    public <T> List<T> executeQuery(CriteriaQuery<T> criteriaQuery) {
        return this.delegate.getEntityManager().executeQuery(this.sessionScope, criteriaQuery);
    }

    @Override
    public <T> List<T> executeQuery(CriteriaQuery<T> criteriaQuery, int startPosition, int maxResult) {
        return this.delegate.getEntityManager().executeQuery(this.sessionScope, criteriaQuery, startPosition, maxResult);
    }

    @Override
    public <T> int executeQueryPage(CriteriaQuery<T> criteriaQuery, List<T> page, int startPosition, int maxResult) {
        return this.delegate.getEntityManager().executeQueryPage(this.sessionScope, criteriaQuery, page, startPosition, maxResult);
    }

    @Override
    public <T> int executeUpdate(CriteriaUpdate<T> updateQuery) {
        return this.delegate.getEntityManager().executeUpdate(this.sessionScope, updateQuery);
    }

    @Override
    public <T> int executeDelete(CriteriaDelete<T> deleteQuery) {
        return this.delegate.getEntityManager().executeDelete(this.sessionScope, deleteQuery);
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getEntityManager().getCriteriaBuilder();
    }

    @Override
    public ResultSet queryForResultSet(String id, Object paramObject) throws SQLException {
        RowSetHandler rsh = new RowSetHandler();
        this.delegate.queryWithRowHandler(this.sessionScope, id, paramObject, rsh);
        return rsh.getRowSet();
    }

    @Override
    public <T> T insertArgs(String id, Object ... args) throws SQLException {
        return this.delegate.insert(this.sessionScope, id, this.toParameter(args));
    }

    @Override
    public int updateArgs(String id, Object ... args) throws SQLException {
        return this.delegate.update(this.sessionScope, id, this.toParameter(args));
    }

    @Override
    public int deleteArgs(String id, Object ... args) throws SQLException {
        return this.delegate.delete(this.sessionScope, id, this.toParameter(args));
    }

    @Override
    public <T> List<T> queryForListArgs(String id, Object ... args) throws SQLException {
        return this.delegate.queryForList(this.sessionScope, id, this.toParameter(args));
    }

    @Override
    public <T> List<T> queryForListArgs(int skip, int max, String id, Object ... args) throws SQLException {
        return this.delegate.queryForList(this.sessionScope, id, this.toParameter(args), skip, max);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, Object ... args) throws SQLException {
        return this.delegate.queryForMap(this.sessionScope, id, this.toParameter(args), keyProp, null, null, null);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, String valueProp, Object ... args) throws SQLException {
        return this.delegate.queryForMap(this.sessionScope, id, this.toParameter(args), keyProp, null, valueProp, null);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, Class<K> keyType, String valueProp, Class<V> valueType, Object ... args) throws SQLException {
        return this.delegate.queryForMap(this.sessionScope, id, this.toParameter(args), keyProp, keyType, valueProp, valueType);
    }

    @Override
    public <T> T queryForObjectArgs(String id, Object ... args) throws SQLException {
        return this.delegate.queryForObject(this.sessionScope, id, this.toParameter(args));
    }

    @Override
    public <T> T queryForFirstArgs(String id, Object ... args) throws SQLException {
        return this.queryForFirst(id, this.toParameter(args));
    }

    @Override
    public <T> T queryForFirst(String id) throws SQLException {
        return this.queryForFirst(id, null);
    }

    @Override
    public <T> T queryForFirst(String id, Object parameterObject) throws SQLException {
        List list = this.delegate.queryForList(this.sessionScope, id, parameterObject, 0, 1);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void queryWithRowHandlerArgs(String id, RowHandler rowHandler, Object ... args) throws SQLException {
        this.delegate.queryWithRowHandler(this.sessionScope, id, this.toParameter(args), rowHandler);
    }

    @Override
    public ResultSet queryForResultSetArgs(String id, Object ... args) throws SQLException {
        return this.queryForResultSet(id, this.toParameter(args));
    }

    @Override
    public ResultSet queryForResultSet(String id) throws SQLException {
        return this.queryForResultSet(id, null);
    }
}

