/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.parameter;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.NoParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.ValueHandler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class ParameterMap {
    private static final ILog log = ILogFactory.getLog(ParameterMap.class);
    private String id;
    private Class<?> parameterClass;
    private ParameterMapping[] parameterMappings;
    private DataExchange dataExchange;
    private String resource;
    private SqlMapExecutorDelegate delegate;

    public ParameterMap(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class<?> getParameterClass() {
        return this.parameterClass;
    }

    public void setParameterClass(Class<?> parameterClass) {
        this.parameterClass = parameterClass;
    }

    public DataExchange getDataExchange() {
        return this.dataExchange;
    }

    public void setDataExchange(DataExchange dataExchange) {
        this.dataExchange = dataExchange;
    }

    public ParameterMapping[] getParameterMappings() {
        return this.parameterMappings;
    }

    public void setParameterMappingList(List<ParameterMapping> parameterMappingList) {
        this.parameterMappings = parameterMappingList.toArray(new ParameterMapping[parameterMappingList.size()]);
        this.dataExchange = this.delegate.getDataExchangeFactory().getDataExchangeForClass(this.parameterClass);
        this.dataExchange.initialize(this);
    }

    public int getParameterCount() {
        return this.parameterMappings.length;
    }

    public Object[] setParameters(StatementScope statementScope, PreparedStatement ps, Object[] parameters) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setResource(this.getResource());
        if (this.parameterMappings != null) {
            String activity = errorContext.getActivity();
            String objectId = errorContext.getObjectId();
            errorContext.setActivity("applying a parameter map");
            errorContext.setObjectId(this.getId());
            errorContext.setConnection(ParameterMap.getConnection(ps));
            errorContext.setMoreInfo("Check the parameter map.");
            for (int i = 0; i < this.parameterMappings.length; ++i) {
                ParameterMapping mapping = this.parameterMappings[i];
                errorContext.setMoreInfo(mapping.getErrorString());
                if (!mapping.isInputAllowed()) continue;
                this.setParameter(ps, mapping, parameters, i);
            }
            errorContext.setActivity(activity);
            errorContext.setObjectId(objectId);
        }
        return parameters;
    }

    static Connection getConnection(PreparedStatement ps) {
        try {
            return ps.getConnection();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object[] getParameterObjectValues(StatementScope statementScope, Object parameterObject) {
        if (this.getParameterCount() == 0) {
            return NoParameterMap.NO_DATA;
        }
        return this.dataExchange.getData(statementScope, this, parameterObject);
    }

    public CacheKey getCacheKey(StatementScope statementScope, Object parameterObject) {
        return this.dataExchange.getCacheKey(statementScope, this, parameterObject);
    }

    public void refreshParameterObjectValues(StatementScope statementScope, Object parameterObject, Object[] values) {
        this.dataExchange.setData(statementScope, this, parameterObject, values);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    protected void setParameter(PreparedStatement ps, ParameterMapping mapping, Object[] parameters, int i) throws SQLException {
        TypeHandler handler;
        Object value = parameters[i];
        String nullValueString = mapping.getNullValue();
        if (nullValueString != null && (handler = mapping.getTypeHandler()).equals(value, nullValueString)) {
            value = null;
        }
        TypeHandler typeHandler = mapping.getTypeHandler();
        if (value != null) {
            if (typeHandler instanceof ValueHandler) {
                parameters[i] = ((ValueHandler)((Object)typeHandler)).setParameterValue(ps, i + 1, value, mapping.getJdbcTypeName());
            } else {
                typeHandler.setParameter(ps, i + 1, value, mapping.getJdbcTypeName());
            }
        } else if (typeHandler instanceof CustomTypeHandler) {
            if (typeHandler instanceof ValueHandler) {
                parameters[i] = ((ValueHandler)((Object)typeHandler)).setParameterValue(ps, i + 1, value, mapping.getJdbcTypeName());
            } else {
                typeHandler.setParameter(ps, i + 1, value, mapping.getJdbcTypeName());
            }
        } else {
            int jdbcType = mapping.getJdbcType();
            if (jdbcType != -99999999) {
                ps.setNull(i + 1, jdbcType);
            } else {
                Integer nullJdbcType = this.delegate.getJdbcTypeForNull();
                if (nullJdbcType != null) {
                    ps.setNull(i + 1, nullJdbcType);
                } else {
                    try {
                        ps.setObject(i + 1, null);
                    }
                    catch (SQLException ex) {
                        log.error("Set jdbc null parameter error: " + ex.getMessage() + ". use <settings jdbcTypeForNull='NULL|VARCHAR|OTHER' /> to fix this problem.");
                        this.trySetNullParameter(ps, i);
                    }
                }
            }
        }
    }

    private void trySetNullParameter(PreparedStatement ps, int i) throws SQLException {
        int sqlTypeToUseForNullValue = 0;
        DatabaseMetaData dbmd = ps.getConnection().getMetaData();
        String databaseProductName = String.valueOf(dbmd.getDatabaseProductName());
        String jdbcDriverName = String.valueOf(dbmd.getDriverName());
        if (databaseProductName.contains("DB2") || jdbcDriverName.contains("jConnect") || jdbcDriverName.contains("SQLServer") || jdbcDriverName.contains("Apache Derby")) {
            sqlTypeToUseForNullValue = 12;
        }
        ps.setNull(i + 1, sqlTypeToUseForNullValue);
        this.delegate.setJdbcTypeForNull(sqlTypeToUseForNullValue);
    }
}

