/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.parameter;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.type.JdbcTypeRegistry;
import com.ibatis.sqlmap.engine.type.StringLike_TypeHandler;
import com.ibatis.sqlmap.engine.type.String_LikeTypeHandler;
import com.ibatis.sqlmap.engine.type.String_Like_TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;

public class ParameterMapping {
    private static final String MODE_INOUT = "INOUT";
    private static final String MODE_OUT = "OUT";
    private static final String MODE_IN = "IN";
    private String propertyName;
    private TypeHandler typeHandler;
    private String typeName;
    private int jdbcType = -99999999;
    private String jdbcTypeName;
    private String nullValue;
    private String mode = "IN";
    private boolean inputAllowed = true;
    private boolean outputAllowed = false;
    private Class<?> javaType;
    private String resultMapName;
    private Integer numericScale;
    private String errorString;
    Object quickValue;
    String quickName;

    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        if (propertyName.startsWith("%") && propertyName.length() > 1) {
            if (propertyName.endsWith("%")) {
                propertyName = propertyName.substring(1, propertyName.length() - 1);
                this.setTypeHandler(String_Like_TypeHandler.INSTANCE);
            } else {
                propertyName = propertyName.substring(1);
                this.setTypeHandler(String_LikeTypeHandler.INSTANCE);
            }
        } else if (propertyName.endsWith("%") && propertyName.length() > 1) {
            propertyName = propertyName.substring(0, propertyName.length() - 1);
            this.setTypeHandler(StringLike_TypeHandler.INSTANCE);
        }
        this.errorString = "Check the parameter mapping for the '" + propertyName + "' property.";
        this.propertyName = propertyName;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public TypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(TypeHandler typeHandler) {
        this.typeHandler = typeHandler;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public String getJavaTypeName() {
        if (this.javaType == null) {
            return null;
        }
        return this.javaType.getName();
    }

    public void setJavaTypeName(String javaTypeName) {
        try {
            this.javaType = javaTypeName == null ? null : Resources.classForName(javaTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new SqlMapException("Error setting javaType property of ParameterMap.  Cause: " + e, e);
        }
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getJdbcTypeName() {
        return this.jdbcTypeName;
    }

    public void setJdbcTypeName(String jdbcTypeName) {
        this.jdbcTypeName = jdbcTypeName;
        this.jdbcType = JdbcTypeRegistry.getType(jdbcTypeName);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
        this.inputAllowed = MODE_IN.equals(mode) || MODE_INOUT.equals(mode);
        this.outputAllowed = MODE_OUT.equals(mode) || MODE_INOUT.equals(mode);
    }

    public boolean isInputAllowed() {
        return this.inputAllowed;
    }

    public boolean isOutputAllowed() {
        return this.outputAllowed;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getResultMapName() {
        return this.resultMapName;
    }

    public void setResultMapName(String resultMapName) {
        this.resultMapName = resultMapName;
    }

    public Integer getNumericScale() {
        return this.numericScale;
    }

    public void setNumericScale(Integer numericScale) {
        if (numericScale != null && numericScale < 0) {
            throw new RuntimeException("Error setting numericScale on parameter mapping.  Cause: scale must be greater than or equal to zero");
        }
        this.numericScale = numericScale;
    }

    public Object getQuickValue() {
        return this.quickValue;
    }

    public void setQucikValue(Object quickValue) {
        this.quickValue = quickValue;
    }

    public String getQuickName() {
        return this.quickName;
    }

    public void setQuickName(String quickName) {
        this.quickName = quickName;
    }
}

