/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.ArraySet;
import com.ibatis.common.Objects;
import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.result.Discriminator;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactoryUtil;
import com.ibatis.sqlmap.engine.mapping.result.loader.ResultLoader;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultMap {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final String KEY_SEPARATOR = "\u0002";
    private String id;
    private Class<?> resultClass;
    private ResultMapping[] resultMappings;
    private ThreadLocal<ResultMapping[]> remappableResultMappings = new ThreadLocal();
    private DataExchange dataExchange;
    private List<ResultMapping> nestedResultMappings;
    private Discriminator discriminator;
    private Set<String> groupByProps;
    private String resource;
    protected SqlMapExecutorDelegate delegate;
    protected boolean allowRemapping = false;
    public static final Object NO_VALUE = new Object();

    public ResultMap(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public Object getUniqueKey(String keyPrefix, Object[] values) {
        if (this.groupByProps != null) {
            StringBuilder key = keyPrefix != null ? new StringBuilder(keyPrefix) : new StringBuilder();
            ResultMapping[] map = this.getResultMappings();
            for (int i = 0; i < map.length; ++i) {
                String propertyName = map[i].getPropertyName();
                if (!this.groupByProps.contains(propertyName)) continue;
                key.append(values[i]);
                key.append('-');
            }
            if (key.length() == 0) {
                return null;
            }
            key.append(KEY_SEPARATOR);
            return key.toString();
        }
        return null;
    }

    public Object getUniqueKey(Object[] values) {
        return this.getUniqueKey(null, values);
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public DataExchange getDataExchange() {
        return this.dataExchange;
    }

    public void setDataExchange(DataExchange dataExchange) {
        this.dataExchange = dataExchange;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void addGroupByProperty(String name) {
        if (this.groupByProps == null) {
            this.groupByProps = new ArraySet<String>();
        }
        this.groupByProps.add(name);
    }

    public Set<String> groupByProps() {
        return this.groupByProps;
    }

    public void addNestedResultMappings(ResultMapping mapping) {
        if (this.nestedResultMappings == null) {
            this.nestedResultMappings = new ArrayList<ResultMapping>();
        }
        this.nestedResultMappings.add(mapping);
    }

    public List<ResultMapping> getNestedResultMappings() {
        return this.nestedResultMappings;
    }

    public boolean isAllowRemapping() {
        return this.allowRemapping;
    }

    public ResultMapping[] getResultMappings() {
        if (this.allowRemapping) {
            return this.remappableResultMappings.get();
        }
        return this.resultMappings;
    }

    public void setDiscriminator(Discriminator discriminator) {
        if (this.discriminator != null) {
            throw new SqlMapException("A discriminator may only be set once per result map.");
        }
        this.discriminator = discriminator;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public ResultMap resolveSubMap(StatementScope statementScope, ResultSet rs) throws SQLException {
        ResultMap subMap = this;
        if (this.discriminator != null) {
            ResultMapping mapping = this.discriminator.getResultMapping();
            Object value = this.getPrimitiveResultMappingValue(rs, mapping);
            if (value == null) {
                value = this.doNullMapping(value, mapping);
            }
            if ((subMap = this.discriminator.getSubMap(String.valueOf(value))) == null) {
                subMap = this;
            } else if (subMap != this) {
                subMap = subMap.resolveSubMap(statementScope, rs);
            }
        }
        return subMap;
    }

    public void setResultMappingList(List<ResultMapping> resultMappingList) {
        if (this.allowRemapping) {
            this.remappableResultMappings.set(resultMappingList.toArray(new ResultMapping[resultMappingList.size()]));
        } else {
            this.resultMappings = resultMappingList.toArray(new ResultMapping[resultMappingList.size()]);
        }
        this.dataExchange = this.getDelegate().getDataExchangeFactory().getDataExchangeForClass(this.resultClass);
        this.dataExchange.initialize(this);
    }

    public int getResultCount() {
        return this.getResultMappings().length;
    }

    public Object[] getResults(StatementScope statementScope, ResultSet rs) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("applying result map: " + this.getId());
        errorContext.setConnection(ResultMap.getConnection(rs));
        errorContext.setResource(this.getResource());
        errorContext.setMoreInfo("Check the result map.");
        boolean foundData = false;
        Object[] columnValues = new Object[this.getResultMappings().length];
        for (int i = 0; i < this.getResultMappings().length; ++i) {
            ResultMapping mapping = this.getResultMappings()[i];
            errorContext.setMoreInfo(mapping.getErrorString());
            if (mapping.getStatementName() != null) {
                if (this.resultClass == null) {
                    throw new SqlMapException("The result class was null when trying to get results for ResultMap named " + this.getId());
                }
                if (Map.class.isAssignableFrom(this.resultClass)) {
                    Class<Object> javaType = mapping.getJavaType();
                    if (javaType == null) {
                        javaType = Object.class;
                    }
                    columnValues[i] = this.getNestedSelectMappingValue(statementScope, rs, mapping, javaType);
                } else {
                    Probe p = ProbeFactory.getProbe(this.resultClass);
                    Class<?> type = p.getPropertyTypeForSetter(this.resultClass, mapping.getPropertyName());
                    columnValues[i] = this.getNestedSelectMappingValue(statementScope, rs, mapping, type);
                }
                foundData = foundData || columnValues[i] != null;
                continue;
            }
            if (mapping.getNestedResultMapName() != null) continue;
            columnValues[i] = this.getPrimitiveResultMappingValue(rs, mapping);
            if (columnValues[i] == null) {
                columnValues[i] = this.doNullMapping(columnValues[i], mapping);
                continue;
            }
            foundData = true;
        }
        statementScope.setRowDataFound(foundData);
        return columnValues;
    }

    static Connection getConnection(ResultSet rs) {
        try {
            return rs.getStatement().getConnection();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object setResultObjectValues(StatementScope statementScope, Object resultObject, Object[] values) {
        String previousNestedKey = statementScope.getCurrentNestedKey();
        String ukey = (String)this.getUniqueKey(statementScope.getCurrentNestedKey(), values);
        Map<String, Object> uniqueKeys = statementScope.getUniqueKeys(this);
        statementScope.setCurrentNestedKey(ukey);
        if (uniqueKeys != null && uniqueKeys.containsKey(ukey)) {
            resultObject = uniqueKeys.get(ukey);
            this.applyNestedResultMap(statementScope, resultObject, values);
            resultObject = NO_VALUE;
        } else if (ukey == null || uniqueKeys == null || !uniqueKeys.containsKey(ukey)) {
            resultObject = this.dataExchange.setData(statementScope, this, resultObject, values);
            if (ukey != null) {
                if (uniqueKeys == null) {
                    uniqueKeys = new HashMap<String, Object>();
                    statementScope.setUniqueKeys(this, uniqueKeys);
                }
                uniqueKeys.put(ukey, resultObject);
            }
            this.applyNestedResultMap(statementScope, resultObject, values);
        } else {
            resultObject = NO_VALUE;
        }
        statementScope.setCurrentNestedKey(previousNestedKey);
        return resultObject;
    }

    private void applyNestedResultMap(StatementScope statementScope, Object resultObject, Object[] values) {
        if (resultObject != null && resultObject != NO_VALUE && this.nestedResultMappings != null) {
            int n = this.nestedResultMappings.size();
            for (int i = 0; i < n; ++i) {
                ResultMapping resultMapping = this.nestedResultMappings.get(i);
                this.setNestedResultMappingValue(resultMapping, statementScope, resultObject, values);
            }
        }
    }

    protected void setNestedResultMappingValue(ResultMapping mapping, StatementScope statementScope, Object resultObject, Object[] values) {
        try {
            String resultMapName = mapping.getNestedResultMapName();
            ResultMap resultMap = this.getDelegate().getResultMap(resultMapName);
            resultMap = resultMap.resolveSubMap(statementScope, statementScope.getResultSet());
            Class<?> type = mapping.getJavaType();
            String propertyName = mapping.getPropertyName();
            Object obj = PROBE.getObject(resultObject, propertyName);
            if (obj == null) {
                if (type == null) {
                    type = PROBE.getPropertyTypeForSetter(resultObject, propertyName);
                }
                try {
                    if (Collection.class.isAssignableFrom(type)) {
                        obj = ResultObjectFactoryUtil.createObjectThroughFactory(type);
                        PROBE.setObject(resultObject, propertyName, obj);
                    }
                }
                catch (Exception e) {
                    throw new SqlMapException("Error instantiating collection property for mapping '" + mapping.getPropertyName() + "'.  Cause: " + e, e);
                }
            }
            boolean subResultObjectAbsent = false;
            if (mapping.getNotNullColumn() != null && statementScope.getResultSet().getObject(mapping.getNotNullColumn()) == null) {
                subResultObjectAbsent = true;
            }
            if (!subResultObjectAbsent) {
                Object o;
                values = resultMap.getResults(statementScope, statementScope.getResultSet());
                if (statementScope.isRowDataFound() && (o = resultMap.setResultObjectValues(statementScope, null, values)) != NO_VALUE) {
                    if (obj != null && obj instanceof Collection) {
                        ((Collection)Objects.uncheckedCast(obj)).add(o);
                    } else {
                        PROBE.setObject(resultObject, propertyName, o);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SqlMapException("Error getting nested result map values for '" + mapping.getPropertyName() + "'.  Cause: " + e, e);
        }
    }

    protected Object getNestedSelectMappingValue(StatementScope statementScope, ResultSet rs, ResultMapping mapping, Class<?> targetType) throws SQLException {
        try {
            TypeHandlerFactory typeHandlerFactory = this.getDelegate().getTypeHandlerFactory();
            String statementName = mapping.getStatementName();
            SqlMapClientImpl client = (SqlMapClientImpl)statementScope.getSession().getSqlMapClient();
            MappedStatement mappedStatement = client.getMappedStatement(statementName);
            Class<?> parameterType = mappedStatement.getParameterClass();
            Object parameterObject = null;
            parameterObject = parameterType == null ? this.prepareBeanParameterObject(statementScope, rs, mapping, parameterType) : (typeHandlerFactory.hasTypeHandler(parameterType) ? this.preparePrimitiveParameterObject(rs, mapping, parameterType) : this.prepareBeanParameterObject(statementScope, rs, mapping, parameterType));
            Object result = null;
            if (parameterObject != null) {
                TypeHandler<?> typeHandler;
                Sql sql = mappedStatement.getSql();
                ResultMap resultMap = sql.getResultMap(statementScope, parameterObject);
                resultMap.getResultClass();
                result = ResultLoader.loadResult(client, statementName, parameterObject, targetType);
                String nullValue = mapping.getNullValue();
                if (result == null && nullValue != null && (typeHandler = typeHandlerFactory.getTypeHandler(targetType)) != null) {
                    result = typeHandler.valueOf(nullValue);
                }
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new NestedSQLException("Error setting nested bean property.  Cause: " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new NestedSQLException("Error setting nested bean property.  Cause: " + e, e);
        }
    }

    private Object preparePrimitiveParameterObject(ResultSet rs, ResultMapping mapping, Class<?> parameterType) throws SQLException {
        TypeHandlerFactory typeHandlerFactory = this.getDelegate().getTypeHandlerFactory();
        TypeHandler<?> th = typeHandlerFactory.getTypeHandler(parameterType);
        Object parameterObject = th.getResult(rs, mapping.getColumnName());
        return parameterObject;
    }

    private Object prepareBeanParameterObject(StatementScope statementScope, ResultSet rs, ResultMapping mapping, Class<?> parameterType) throws InstantiationException, IllegalAccessException, SQLException {
        TypeHandlerFactory typeHandlerFactory = this.getDelegate().getTypeHandlerFactory();
        HashMap parameterObject = parameterType == null ? new HashMap() : ResultObjectFactoryUtil.createObjectThroughFactory(parameterType);
        String[] columnMap = mapping.getColumnMap();
        if (columnMap != null) {
            for (int i = 0; i < columnMap.length; i += 2) {
                String propName = columnMap[i];
                String colName = columnMap[i + 1];
                Class<?> propType = PROBE.getPropertyTypeForSetter(parameterObject, propName);
                TypeHandler<?> propTypeHandler = typeHandlerFactory.getTypeHandler(propType);
                Object propValue = propTypeHandler.getResult(rs, colName);
                PROBE.setObject(parameterObject, propName, propValue);
            }
        } else {
            TypeHandler<?> propTypeHandler = typeHandlerFactory.getTypeHandler(parameterType);
            if (propTypeHandler == null) {
                propTypeHandler = typeHandlerFactory.getUnkownTypeHandler();
            }
            parameterObject = propTypeHandler.getResult(rs, mapping.getColumnName());
        }
        return parameterObject;
    }

    protected Object getPrimitiveResultMappingValue(ResultSet rs, ResultMapping mapping) throws SQLException {
        Object value = null;
        TypeHandler typeHandler = mapping.getTypeHandler();
        if (typeHandler != null) {
            String columnName = mapping.getColumnName();
            int columnIndex = mapping.getColumnIndex();
            value = columnName == null ? typeHandler.getResult(rs, columnIndex) : typeHandler.getResult(rs, columnName);
        } else {
            throw new SqlMapException("No type handler could be found to map the property '" + mapping.getPropertyName() + "' to the column '" + mapping.getColumnName() + "'.  One or both of the types, or the combination of types is not supported.");
        }
        return value;
    }

    protected Object doNullMapping(Object value, ResultMapping mapping) throws SqlMapException {
        if (value == null) {
            TypeHandler typeHandler = mapping.getTypeHandler();
            if (typeHandler != null) {
                String nullValue = mapping.getNullValue();
                if (nullValue != null) {
                    value = typeHandler.valueOf(nullValue);
                }
                return value;
            }
            throw new SqlMapException("No type handler could be found to map the property '" + mapping.getPropertyName() + "' to the column '" + mapping.getColumnName() + "'.  One or both of the types, or the combination of types is not supported.");
        }
        return value;
    }
}

