/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class ResultObjectFactoryUtil {
    private static ThreadLocal<Stack<FactorySettings>> factorySettings = new ThreadLocal();

    private ResultObjectFactoryUtil() {
    }

    public static Object createObjectThroughFactory(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        Object obj;
        FactorySettings fs = ResultObjectFactoryUtil.getCurrentFactorySettings();
        if (fs.getResultObjectFactory() == null) {
            obj = ResultObjectFactoryUtil.createObjectInternally(clazz);
        } else {
            obj = fs.getResultObjectFactory().createInstance(fs.getStatementId(), clazz);
            if (obj == null) {
                obj = ResultObjectFactoryUtil.createObjectInternally(clazz);
            }
        }
        return obj;
    }

    private static Object createObjectInternally(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        Class classToCreate = clazz == List.class || clazz == Collection.class ? ArrayList.class : (clazz == Set.class ? LinkedHashSet.class : clazz);
        Object obj = Resources.instantiate(classToCreate);
        return obj;
    }

    public static void setupResultObjectFactory(ResultObjectFactory resultObjectFactory, String statementId) {
        Stack<FactorySettings> fss = factorySettings.get();
        if (fss == null) {
            fss = new Stack();
            factorySettings.set(fss);
        }
        FactorySettings fs = new FactorySettings();
        fs.setResultObjectFactory(resultObjectFactory);
        fs.setStatementId(statementId);
        fss.push(fs);
    }

    public static void cleanupResultObjectFactory() {
        Stack<FactorySettings> fss = factorySettings.get();
        if (!fss.empty()) {
            fss.pop();
        }
        if (fss.empty()) {
            factorySettings.remove();
        }
    }

    private static FactorySettings getCurrentFactorySettings() {
        Stack<FactorySettings> fss = factorySettings.get();
        FactorySettings fs = fss == null || fss.empty() ? new FactorySettings() : fss.peek();
        return fs;
    }

    private static class FactorySettings {
        private ResultObjectFactory resultObjectFactory;
        private String statementId;

        private FactorySettings() {
        }

        public ResultObjectFactory getResultObjectFactory() {
            return this.resultObjectFactory;
        }

        public void setResultObjectFactory(ResultObjectFactory resultObjectFactory) {
            this.resultObjectFactory = resultObjectFactory;
        }

        public String getStatementId() {
            return this.statementId;
        }

        public void setStatementId(String statementId) {
            this.statementId = statementId;
        }
    }
}

