/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result.loader;

import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.mapping.result.loader.ResultLoader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.ibatis.cglib.ClassInfo;

public class LazyResultLoader
implements InvocationHandler {
    private static final Class<?>[] SET_INTERFACES = new Class[]{Set.class};
    private static final Class<?>[] LIST_INTERFACES = new Class[]{List.class};
    protected SqlMapClientImpl client;
    protected String statementName;
    protected Object parameterObject;
    protected Class<?> targetType;
    protected boolean loaded;
    protected Object resultObject;

    public LazyResultLoader(SqlMapClientImpl client, String statementName, Object parameterObject, Class<?> targetType) {
        this.client = client;
        this.statementName = statementName;
        this.parameterObject = parameterObject;
        this.targetType = targetType;
    }

    public Object loadResult() throws SQLException {
        if (Collection.class.isAssignableFrom(this.targetType)) {
            LazyResultLoader handler = new LazyResultLoader(this.client, this.statementName, this.parameterObject, this.targetType);
            ClassLoader cl = this.targetType.getClassLoader();
            if (Set.class.isAssignableFrom(this.targetType)) {
                return Proxy.newProxyInstance(cl, SET_INTERFACES, (InvocationHandler)handler);
            }
            return Proxy.newProxyInstance(cl, LIST_INTERFACES, (InvocationHandler)handler);
        }
        return ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if ("finalize".hashCode() == method.getName().hashCode() && "finalize".equals(method.getName())) {
            return null;
        }
        this.loadObject();
        if (this.resultObject != null) {
            try {
                return method.invoke(this.resultObject, objects);
            }
            catch (Throwable t) {
                throw ClassInfo.unwrapThrowable(t);
            }
        }
        return null;
    }

    private synchronized void loadObject() {
        if (!this.loaded) {
            try {
                this.loaded = true;
                this.resultObject = ResultLoader.getResult(this.client, this.statementName, this.parameterObject, this.targetType);
            }
            catch (SQLException e) {
                throw new RuntimeException("Error lazy loading result. Cause: " + e, e);
            }
        }
    }
}

