/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql;

import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.sql.SqlChild;

public class SqlText
implements SqlChild {
    private String text;
    private boolean isWhiteSpace;
    private boolean postParseRequired;
    private ParameterMapping[] parameterMappings;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.isWhiteSpace = !SqlText.isNotEmpty(text);
    }

    public boolean isWhiteSpace() {
        return this.isWhiteSpace;
    }

    public ParameterMapping[] getParameterMappings() {
        return this.parameterMappings;
    }

    public void setParameterMappings(ParameterMapping[] parameterMappings) {
        this.parameterMappings = parameterMappings;
    }

    public boolean isPostParseRequired() {
        return this.postParseRequired;
    }

    public void setPostParseRequired(boolean postParseRequired) {
        this.postParseRequired = postParseRequired;
    }

    public static boolean isNotEmpty(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (SqlText.isSpace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String cleanSql(String sql, boolean leading) {
        StringBuilder buf = new StringBuilder(sql.length());
        if (!leading) {
            buf.append(' ');
        }
        Stat state = Stat.Space;
        block5: for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            switch (state) {
                case Normal: {
                    if (c == '\'') {
                        state = Stat.Quote;
                        buf.append(c);
                        continue block5;
                    }
                    if (SqlText.isSpace(c)) {
                        state = Stat.Space;
                        buf.append(' ');
                        continue block5;
                    }
                    buf.append(c);
                    continue block5;
                }
                case Space: {
                    if (c == '\'') {
                        state = Stat.Quote;
                        buf.append(c);
                        continue block5;
                    }
                    if (SqlText.isSpace(c)) continue block5;
                    state = Stat.Normal;
                    buf.append(c);
                    continue block5;
                }
                case Quote: {
                    if (c == '\'') {
                        state = Stat.Normal;
                        buf.append(c);
                        continue block5;
                    }
                    buf.append(c);
                }
            }
        }
        if (state == Stat.Quote) {
            throw new IllegalStateException(sql);
        }
        if (state == Stat.Normal) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static boolean isSpace(char ch) {
        return ch <= '\r' && ch >= '\t' || ch == ' ';
    }

    public static boolean isNotEmpty(StringBuilder str) {
        for (int i = 0; i < str.length(); ++i) {
            if (SqlText.isSpace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.text;
    }

    @Override
    public int hashCodex() {
        return this.getClass().getName().hashCode() + (this.text == null ? 0 : this.text.hashCode());
    }

    static enum Stat {
        Normal,
        Space,
        Quote;

    }
}

