/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic;

import com.ibatis.common.Objects;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.InlineParameterMapParser;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.sql.SqlChild;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicParent;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateIndex;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.simple.SimpleDynamicSql;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DynamicSql
implements Sql,
DynamicParent {
    private static final InlineParameterMapParser PARAM_PARSER = new InlineParameterMapParser();
    private final List<SqlChild> children = new ArrayList<SqlChild>(3);
    private SqlMapExecutorDelegate delegate;

    public DynamicSql(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getSql(StatementScope statementScope, Object parameterObject) {
        String sql = statementScope.getDynamicSql();
        if (sql == null) {
            this.process(statementScope, parameterObject);
            sql = statementScope.getDynamicSql();
        }
        return sql;
    }

    @Override
    public ParameterMap getParameterMap(StatementScope statementScope, Object parameterObject) {
        ParameterMap map = statementScope.getDynamicParameterMap();
        if (map == null) {
            this.process(statementScope, parameterObject);
            map = statementScope.getDynamicParameterMap();
        }
        return map;
    }

    @Override
    public ResultMap getResultMap(StatementScope statementScope, Object parameterObject) {
        return statementScope.getResultMap();
    }

    @Override
    public void cleanup(StatementScope statementScope) {
        statementScope.setDynamicSql(null);
        statementScope.setDynamicParameterMap(null);
    }

    private void process(StatementScope statementScope, Object parameterObject) {
        SqlTagContext ctx = new SqlTagContext();
        List<SqlChild> localChildren = this.children;
        this.processBodyChildren(statementScope, ctx, parameterObject, localChildren.iterator());
        ParameterMap map = new ParameterMap(this.delegate);
        map.setId(statementScope.getStatement().getId() + "-InlineParameterMap");
        map.setParameterClass(statementScope.getStatement().getParameterClass());
        map.setParameterMappingList(ctx.getParameterMappings());
        String dynSql = ctx.getBodyText();
        if (SimpleDynamicSql.isSimpleDynamicSql(dynSql)) {
            dynSql = new SimpleDynamicSql(this.delegate, dynSql).getSql(statementScope, parameterObject);
        }
        statementScope.setDynamicSql(dynSql);
        statementScope.setDynamicParameterMap(map);
    }

    private void processBodyChildren(StatementScope statementScope, SqlTagContext ctx, Object parameterObject, Iterator<SqlChild> localChildren) {
        this.processBodyChildren(statementScope, ctx, parameterObject, localChildren, ctx.getStringBuilder());
    }

    private void processBodyChildren(StatementScope statementScope, SqlTagContext ctx, Object parameterObject, Iterator<SqlChild> localChildren, StringBuilder buf) {
        while (localChildren.hasNext()) {
            IterateContext ic;
            SqlChild child = localChildren.next();
            if (child instanceof SqlText) {
                SqlText sqlText = (SqlText)child;
                String sqlStatement = sqlText.getText();
                if (sqlText.isWhiteSpace()) {
                    buf.append(sqlStatement);
                    continue;
                }
                if (!sqlText.isPostParseRequired()) {
                    buf.append(sqlStatement);
                    ParameterMapping[] mappings = sqlText.getParameterMappings();
                    if (mappings == null) continue;
                    int n = mappings.length;
                    for (int i = 0; i < n; ++i) {
                        ctx.addParameterMapping(mappings[i]);
                    }
                    continue;
                }
                IterateContext itCtx = ctx.peekIterateContext();
                if (null != itCtx && itCtx.isAllowNext()) {
                    itCtx.next();
                    itCtx.setAllowNext(false);
                    if (!itCtx.hasNext()) {
                        itCtx.setFinal(true);
                    }
                }
                HashMap<String, IterateIndex> itMap = new HashMap<String, IterateIndex>();
                if (itCtx != null) {
                    StringBuilder sb = new StringBuilder(sqlStatement);
                    this.iteratePropertyReplace(sb, '#', itCtx, itMap);
                    this.iteratePropertyReplace(sb, '$', itCtx, itMap);
                    sqlStatement = sb.toString();
                }
                sqlText = PARAM_PARSER.parseInlineParameterMap(this.delegate.getTypeHandlerFactory(), sqlStatement);
                ParameterMapping[] mappings = sqlText.getParameterMappings();
                buf.append(sqlText.getText());
                if (mappings == null) continue;
                for (ParameterMapping pm : mappings) {
                    String propName = pm.getPropertyName();
                    IterateIndex itIdx = (IterateIndex)itMap.get(propName);
                    if (itIdx != null && propName.startsWith(itIdx.getProcessKey())) {
                        pm.setQucikValue(itIdx.getProcessValue());
                        pm.setQuickName(propName.substring(itIdx.getProcessKey().length()));
                    }
                    ctx.addParameterMapping(pm);
                }
                continue;
            }
            if (!(child instanceof SqlTag)) continue;
            SqlTag tag = (SqlTag)child;
            SqlTagHandler handler = tag.getHandler();
            int response = 1;
            int rfpDepth = ctx.removeFirtPrependStackSize();
            do {
                StringBuilder body = new StringBuilder();
                response = handler.doStartFragment(ctx, tag, parameterObject);
                if (response == 0) continue;
                this.processBodyChildren(statementScope, ctx, parameterObject, tag.getChildren(), body);
                response = handler.doEndFragment(ctx, tag, parameterObject, body);
                handler.doPrepend(ctx, tag, parameterObject, body);
                if (response == 0 || body.length() <= 0) continue;
                buf.append(body.toString());
            } while (response == 2);
            if (ctx.removeFirtPrependStackSize() > rfpDepth) {
                ctx.popRemoveFirstPrependMarker();
            }
            if ((ic = ctx.peekIterateContext()) == null || ic.getTag() != tag) continue;
            ctx.setAttribute(tag, null);
            ctx.popIterateContext();
        }
    }

    void iteratePropertyReplace(StringBuilder buf, char delim, IterateContext iterate, Map<String, IterateIndex> itMap) {
        int startIndex = 0;
        int endIndex = -1;
        while (startIndex >= 0 && startIndex < buf.length()) {
            IterateIndex ii;
            String rstr;
            String sstr;
            startIndex = Objects.indexOf(buf, delim, endIndex + 1);
            endIndex = Objects.indexOf(buf, delim, startIndex + 1);
            if (startIndex < 0 || endIndex < 0 || (sstr = buf.substring(startIndex + 1, endIndex)).equals(rstr = (ii = iterate.addIndexToTagProperty(sstr)).getProcessString())) continue;
            if (ii.hasProcessValue()) {
                itMap.put(rstr, ii);
            }
            buf.replace(startIndex + 1, endIndex, rstr);
            endIndex += rstr.length() - sstr.length();
        }
    }

    public List<SqlChild> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(SqlChild child) {
        this.children.add(child);
    }

    @Override
    public int hashCodex() {
        int ret = this.getClass().getName().hashCode();
        for (SqlChild sc : this.children) {
            ret += sc.hashCodex();
        }
        return ret;
    }

    @Override
    public String headText() {
        for (SqlChild sc : this.children) {
            if (!(sc instanceof SqlText)) continue;
            return ((SqlText)sc).getText();
        }
        return "";
    }
}

