/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateIndex;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IterateContext
implements Iterator<Object> {
    private Iterator<?> iterator;
    private int index = -1;
    private String property;
    private boolean allowNext = true;
    private boolean isFinal = false;
    private SqlTag tag;
    private IterateContext parent;
    private boolean someSubElementsHaveContent;
    private boolean isPrependEnabled;
    Object curr;

    public IterateContext(Object collection, SqlTag tag, IterateContext parent) {
        this.parent = parent;
        this.tag = tag;
        if (collection instanceof Collection) {
            this.iterator = ((Collection)collection).iterator();
        } else if (collection instanceof Iterator) {
            this.iterator = (Iterator)collection;
        } else if (collection.getClass().isArray()) {
            List<Object> list = this.arrayToList(collection);
            this.iterator = list.iterator();
        } else {
            throw new SqlMapException("ParameterObject or property was not a Collection, Array or Iterator.");
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    public Object peek() {
        return this.curr;
    }

    @Override
    public Object next() {
        ++this.index;
        this.curr = this.iterator.next();
        return this.curr;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isLast() {
        return this.iterator != null && !this.iterator.hasNext();
    }

    private List<Object> arrayToList(Object array) {
        List<Object> list = null;
        if (array instanceof Object[]) {
            list = Arrays.asList((Object[])array);
        } else {
            int n = Array.getLength(array);
            list = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                list.add(Array.get(array, i));
            }
        }
        return list;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean isAllowNext() {
        return this.allowNext;
    }

    public void setAllowNext(boolean performIterate) {
        this.allowNext = performIterate;
    }

    public SqlTag getTag() {
        return this.tag;
    }

    public void setTag(SqlTag tag) {
        this.tag = tag;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public String getEndProperty() {
        if (this.parent != null) {
            int parentPropertyIndex = this.property.indexOf(this.parent.getProperty());
            if (parentPropertyIndex >= 0) {
                int endPropertyIndex1 = this.property.indexOf(93, parentPropertyIndex);
                int endPropertyIndex2 = this.property.indexOf(46, parentPropertyIndex);
                return this.property.substring(parentPropertyIndex + Math.max(endPropertyIndex1, endPropertyIndex2) + 1, this.property.length());
            }
            return this.property;
        }
        return this.property;
    }

    protected IterateIndex processTagProperty(String tagProperty) {
        if (this.parent != null) {
            IterateIndex parentResult = this.parent.processTagProperty(tagProperty);
            return this.addIndex(parentResult.getProcessString(), parentResult.getProcessIndex());
        }
        return this.addIndex(tagProperty, 0);
    }

    public IterateIndex addIndexToTagProperty(String tagProperty) {
        IterateIndex map = this.processTagProperty(tagProperty);
        return map;
    }

    protected IterateIndex addIndex(String input, int startIndex) {
        String endProperty = this.getEndProperty() + "[";
        int propertyIndex = input.indexOf(endProperty, startIndex);
        int modificationIndex = 0;
        IterateIndex ret = new IterateIndex();
        if (propertyIndex >= 0 && input.charAt(propertyIndex + endProperty.length()) == ']') {
            ret.setProcessKey(input.substring(0, propertyIndex + endProperty.length()) + this.getIndex() + "]");
            ret.setProcessValue(this.peek());
            input = input.substring(0, propertyIndex + endProperty.length()) + this.getIndex() + input.substring(propertyIndex + endProperty.length());
            modificationIndex = propertyIndex + endProperty.length();
        }
        ret.setProcessIndex(modificationIndex);
        ret.setProcessString(input);
        return ret;
    }

    public IterateContext getParent() {
        return this.parent;
    }

    public void setParent(IterateContext parent) {
        this.parent = parent;
    }

    public boolean someSubElementsHaveContent() {
        return this.someSubElementsHaveContent;
    }

    public void setSomeSubElementsHaveContent(boolean someSubElementsHaveContent) {
        this.someSubElementsHaveContent = someSubElementsHaveContent;
    }

    public boolean isPrependEnabled() {
        return this.isPrependEnabled;
    }

    public void setPrependEnabled(boolean isPrependEnabled) {
        this.isPrependEnabled = isPrependEnabled;
    }
}

