/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.BaseTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagContext;

public class IterateTagHandler
extends BaseTagHandler {
    private static final Probe PROBE = ProbeFactory.getProbe();

    @Override
    public int doStartFragment(SqlTagContext ctx, SqlTag tag, Object parameterObject) {
        IterateContext iterate = ctx.getAttribute(tag);
        if (iterate == null) {
            Object collection;
            IterateContext parentIterate = ctx.peekIterateContext();
            ctx.pushRemoveFirstPrependMarker(tag);
            String prop = tag.getPropertyAttr();
            if (prop != null && !prop.isEmpty()) {
                if (null != parentIterate && parentIterate.isAllowNext()) {
                    parentIterate.next();
                    parentIterate.setAllowNext(false);
                    if (!parentIterate.hasNext()) {
                        parentIterate.setFinal(true);
                    }
                }
                if (parentIterate != null) {
                    prop = parentIterate.addIndexToTagProperty(prop).getProcessString();
                }
                collection = PROBE.getObject(parameterObject, prop);
            } else {
                collection = parameterObject;
            }
            iterate = new IterateContext(collection, tag, parentIterate);
            iterate.setProperty(null == prop ? "" : prop);
            ctx.setAttribute(tag, iterate);
            ctx.pushIterateContext(iterate);
        } else if (tag.getRemoveFirstPrepend() == 2) {
            ctx.reEnableRemoveFirstPrependMarker();
        }
        if (iterate != null && iterate.hasNext()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int doEndFragment(SqlTagContext ctx, SqlTag tag, Object parameterObject, StringBuilder bodyContent) {
        IterateContext iterate = ctx.getAttribute(tag);
        if (iterate.hasNext() || iterate.isFinal()) {
            if (iterate.isAllowNext()) {
                iterate.next();
            }
            if (SqlText.isNotEmpty(bodyContent)) {
                if (iterate.someSubElementsHaveContent()) {
                    if (tag.isConjunctionAvailable()) {
                        bodyContent.insert(0, tag.getConjunctionAttr());
                    }
                } else {
                    iterate.setPrependEnabled(true);
                    if (tag.isOpenAvailable()) {
                        bodyContent.insert(0, tag.getOpenAttr());
                    }
                }
                iterate.setSomeSubElementsHaveContent(true);
            }
            if (iterate.isLast() && iterate.someSubElementsHaveContent() && tag.isCloseAvailable()) {
                bodyContent.append(tag.getCloseAttr());
            }
            iterate.setAllowNext(true);
            if (iterate.isFinal()) {
                return super.doEndFragment(ctx, tag, parameterObject, bodyContent);
            }
            return 2;
        }
        return super.doEndFragment(ctx, tag, parameterObject, bodyContent);
    }

    @Override
    public void doPrepend(SqlTagContext ctx, SqlTag tag, Object parameterObject, StringBuilder bodyContent) {
        IterateContext iterate = ctx.getAttribute(tag);
        if (iterate.isPrependEnabled()) {
            super.doPrepend(ctx, tag, parameterObject, bodyContent);
            iterate.setPrependEnabled(false);
        }
    }

    public boolean isPostParseRequired() {
        return true;
    }
}

