/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateContext;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SqlTagContext {
    private StringBuilder buf;
    private HashMap<SqlTag, IterateContext> attributes;
    private StringBuilder rfpStack;
    private LinkedList<IterateContext> iterateContextStack;
    private ArrayList<ParameterMapping> parameterMappings = new ArrayList();

    public SqlTagContext() {
        this.buf = new StringBuilder();
        this.attributes = new HashMap();
        this.rfpStack = new StringBuilder();
        this.iterateContextStack = new LinkedList();
    }

    public StringBuilder getStringBuilder() {
        return this.buf;
    }

    public String getBodyText() {
        return this.buf.toString();
    }

    public void setAttribute(SqlTag key, IterateContext value) {
        this.attributes.put(key, value);
    }

    public IterateContext getAttribute(SqlTag key) {
        return this.attributes.get(key);
    }

    public void addParameterMapping(ParameterMapping mapping) {
        this.parameterMappings.add(mapping);
    }

    public List<ParameterMapping> getParameterMappings() {
        return this.parameterMappings;
    }

    public int removeFirtPrependStackSize() {
        return this.rfpStack.length();
    }

    public boolean peekRemoveFirstPrependMarker() {
        return this.rfpStack.charAt(this.rfpStack.length() - 2) == '1';
    }

    public void popRemoveFirstPrependMarker() {
        this.rfpStack.setLength(this.rfpStack.length() - 1);
    }

    public void pushRemoveFirstPrependMarker(SqlTag tag) {
        if (tag.getHandler() instanceof DynamicTagHandler) {
            if (tag.isPrependAvailable()) {
                this.rfpStack.append('1');
            } else {
                this.rfpStack.append('0');
            }
        } else if (tag.getRemoveFirstPrepend() > 0) {
            this.rfpStack.append('1');
        } else if (!tag.isPrependAvailable() && tag.getRemoveFirstPrepend() == 0 && tag.getParent() != null) {
            if (tag.getParent().getRemoveFirstPrepend() > 0) {
                this.rfpStack.append('1');
            }
        } else {
            this.rfpStack.append('0');
        }
    }

    public void disableRemoveFirstPrependMarker() {
        this.rfpStack.setCharAt(this.rfpStack.length() - 2, '0');
    }

    public void reEnableRemoveFirstPrependMarker() {
        this.rfpStack.setCharAt(this.rfpStack.length() - 1, '1');
    }

    public void pushIterateContext(IterateContext iterateContext) {
        this.iterateContextStack.addFirst(iterateContext);
    }

    public IterateContext popIterateContext() {
        IterateContext retVal = null;
        if (!this.iterateContextStack.isEmpty()) {
            retVal = this.iterateContextStack.removeFirst();
        }
        return retVal;
    }

    public IterateContext peekIterateContext() {
        IterateContext retVal = null;
        if (!this.iterateContextStack.isEmpty()) {
            retVal = this.iterateContextStack.getFirst();
        }
        return retVal;
    }
}

