/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements;

import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsEmptyTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsEqualTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsGreaterEqualTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsGreaterThanTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsLessEqualTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsLessThanTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsNotEmptyTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsNotEqualTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsNotNullTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsNotParameterPresentTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsNotPropertyAvailableTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsNullTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsParameterPresentTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IsPropertyAvailableTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.IterateTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandler;
import java.util.HashMap;
import java.util.Map;

public class SqlTagHandlerFactory {
    private static final Map<String, SqlTagHandler> HANDLER_MAP = new HashMap<String, SqlTagHandler>();

    private SqlTagHandlerFactory() {
    }

    public static SqlTagHandler getSqlTagHandler(String name) {
        return HANDLER_MAP.get(name);
    }

    static {
        HANDLER_MAP.put("isEmpty", new IsEmptyTagHandler());
        HANDLER_MAP.put("isEqual", new IsEqualTagHandler());
        HANDLER_MAP.put("isGreaterEqual", new IsGreaterEqualTagHandler());
        HANDLER_MAP.put("isGreaterThan", new IsGreaterThanTagHandler());
        HANDLER_MAP.put("isLessEqual", new IsLessEqualTagHandler());
        HANDLER_MAP.put("isLessThan", new IsLessThanTagHandler());
        HANDLER_MAP.put("isNotEmpty", new IsNotEmptyTagHandler());
        HANDLER_MAP.put("isNotEqual", new IsNotEqualTagHandler());
        HANDLER_MAP.put("isNotNull", new IsNotNullTagHandler());
        HANDLER_MAP.put("isNotParameterPresent", new IsNotParameterPresentTagHandler());
        HANDLER_MAP.put("isNotPropertyAvailable", new IsNotPropertyAvailableTagHandler());
        HANDLER_MAP.put("isNull", new IsNullTagHandler());
        HANDLER_MAP.put("isParameterPresent", new IsParameterPresentTagHandler());
        HANDLER_MAP.put("isPropertyAvailable", new IsPropertyAvailableTagHandler());
        HANDLER_MAP.put("iterate", new IterateTagHandler());
        HANDLER_MAP.put("dynamic", new DynamicTagHandler());
        HANDLER_MAP.put("em", new IsEmptyTagHandler());
        HANDLER_MAP.put("eq", new IsEqualTagHandler());
        HANDLER_MAP.put("ge", new IsGreaterEqualTagHandler());
        HANDLER_MAP.put("gt", new IsGreaterThanTagHandler());
        HANDLER_MAP.put("le", new IsLessEqualTagHandler());
        HANDLER_MAP.put("lt", new IsLessThanTagHandler());
        HANDLER_MAP.put("nem", new IsNotEmptyTagHandler());
        HANDLER_MAP.put("ne", new IsNotEqualTagHandler());
        HANDLER_MAP.put("nn", new IsNotNullTagHandler());
        HANDLER_MAP.put("npp", new IsNotParameterPresentTagHandler());
        HANDLER_MAP.put("npa", new IsNotPropertyAvailableTagHandler());
        HANDLER_MAP.put("nul", new IsNullTagHandler());
        HANDLER_MAP.put("pp", new IsParameterPresentTagHandler());
        HANDLER_MAP.put("pa", new IsPropertyAvailableTagHandler());
        HANDLER_MAP.put("it", new IterateTagHandler());
        HANDLER_MAP.put("dyn", new DynamicTagHandler());
    }
}

