/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.simple;

import com.ibatis.common.Objects;
import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.scope.StatementScope;

public class SimpleDynamicSql
implements Sql {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final char ELEMENT_TOKEN_CHAR = '$';
    private String sqlStatement;
    private SqlMapExecutorDelegate delegate;

    public SimpleDynamicSql(SqlMapExecutorDelegate delegate, String sqlStatement) {
        this.delegate = delegate;
        this.sqlStatement = sqlStatement;
    }

    @Override
    public String getSql(StatementScope statementScope, Object parameterObject) {
        String sql = statementScope.getSimpleDynamicSql();
        if (sql == null) {
            sql = this.processDynamicElements(statementScope, this.sqlStatement, parameterObject);
            statementScope.setSimpleDynamicSql(sql);
        }
        return sql;
    }

    @Override
    public ParameterMap getParameterMap(StatementScope statementScope, Object parameterObject) {
        return statementScope.getParameterMap();
    }

    @Override
    public ResultMap getResultMap(StatementScope statementScope, Object parameterObject) {
        return statementScope.getResultMap();
    }

    @Override
    public void cleanup(StatementScope statementScope) {
    }

    public static boolean isSimpleDynamicSql(String sql) {
        if (sql != null && sql.indexOf(36) >= 0) {
            if (sql.indexOf(39) < 0) {
                return true;
            }
            boolean inQuote = false;
            for (char c : sql.toCharArray()) {
                if (inQuote) {
                    if (c != '\'') continue;
                    inQuote = false;
                    continue;
                }
                if (c == '$') {
                    return true;
                }
                if (c != '\'') continue;
                inQuote = true;
            }
        }
        return false;
    }

    private String processDynamicElements(StatementScope statementScope, String sql, Object parameterObject) {
        StringBuilder buf = new StringBuilder(sql);
        StringBuilder sqlPeer = new StringBuilder();
        int startIndex = 0;
        int endIndex = -1;
        while (startIndex >= 0 && startIndex < buf.length()) {
            startIndex = Objects.indexOf(buf, '$', endIndex + 1);
            if (startIndex > endIndex + 1) {
                sqlPeer.append(buf.substring(endIndex + 1, startIndex));
            }
            if (startIndex >= 0) {
                endIndex = Objects.indexOf(buf, '$', startIndex + 1);
                if (endIndex < 0) {
                    throw new SqlMapException("Unterminated dynamic element in near '" + buf.substring(startIndex) + "'");
                }
                String token = buf.substring(startIndex + 1, endIndex);
                Object value = null;
                if (token.isEmpty()) {
                    buf.deleteCharAt(endIndex);
                    sqlPeer.append('$');
                    --endIndex;
                    continue;
                }
                if (token.startsWith("@")) {
                    value = this.delegate.getGlobalProperty(token.substring(1));
                } else if (parameterObject != null) {
                    value = this.delegate.getTypeHandlerFactory().hasTypeHandler(parameterObject.getClass()) ? parameterObject : PROBE.getObject(parameterObject, token);
                }
                String str = value != null ? String.valueOf(value) : "";
                buf.replace(startIndex, endIndex + 1, str);
                endIndex = startIndex + str.length() - 1;
                if (token.startsWith("@")) {
                    sqlPeer.append(token);
                    continue;
                }
                sqlPeer.append(str);
                continue;
            }
            sqlPeer.append(buf.substring(endIndex + 1));
        }
        if (statementScope != null && statementScope.getErrorContext() != null) {
            statementScope.getErrorContext().setSql(sqlPeer.toString());
        }
        return buf.toString();
    }

    @Override
    public int hashCodex() {
        return this.getClass().getName().hashCode() + (this.sqlStatement == null ? 0 : this.sqlStatement.hashCode());
    }

    @Override
    public String headText() {
        return this.sqlStatement;
    }
}

