/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.Objects;
import com.ibatis.common.Page;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.cache.FlushListener;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.MappedRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CachingStatement
extends MappedStatement {
    private MappedStatement statement;
    private CacheModel cacheModel;

    public CachingStatement(MappedStatement statement, CacheModel cacheModel) {
        this.statement = statement;
        this.cacheModel = cacheModel;
    }

    @Override
    public String getId() {
        return this.statement.getId();
    }

    @Override
    public StatementType getStatementType() {
        return this.statement.getStatementType();
    }

    @Override
    public Integer getResultSetType() {
        return this.statement.getResultSetType();
    }

    @Override
    public Integer getFetchSize() {
        return this.statement.getFetchSize();
    }

    @Override
    public ParameterMap getParameterMap() {
        return this.statement.getParameterMap();
    }

    @Override
    public ResultMap getResultMap() {
        return this.statement.getResultMap();
    }

    @Override
    public int executeUpdate(StatementScope statementScope, Transaction trans, Object parameterObject) throws SQLException {
        int n = this.statement.executeUpdate(statementScope, trans, parameterObject);
        return n;
    }

    @Override
    public <T> T executeQueryForObject(StatementScope statementScope, Transaction trans, Object parameterObject, Object resultObject) throws SQLException {
        CacheKey cacheKey = this.getCacheKey(statementScope, parameterObject);
        cacheKey.update("executeQueryForObject");
        Object old = this.cacheModel.getObject(cacheKey);
        if (old == CacheModel.NULL_OBJECT) {
            return null;
        }
        if (old == null) {
            Object t = this.statement.executeQueryForObject(statementScope, trans, parameterObject, resultObject);
            this.cacheModel.putObject((Object)cacheKey, t);
            return t;
        }
        return Objects.uncheckedCast(old);
    }

    @Override
    public <T> int executeQueryForPage(StatementScope statementScope, List<T> page, Transaction trans, Object paramObject, int skipResults, int maxResults) throws SQLException {
        CacheKey cacheKey = this.getCacheKey(statementScope, paramObject);
        cacheKey.update("executeQueryForPage");
        cacheKey.update(page != null);
        cacheKey.update(skipResults);
        cacheKey.update(maxResults);
        Object old = this.cacheModel.getObject(cacheKey);
        Page pageObject = null;
        if (old instanceof Page) {
            pageObject = (Page)Objects.uncheckedCast(old);
            if (page != null) {
                page.addAll(pageObject.list);
            }
            return pageObject.total;
        }
        ArrayList p = new ArrayList();
        int t = this.statement.executeQueryForPage(statementScope, p, trans, paramObject, skipResults, maxResults);
        if (page != null) {
            page.addAll(p);
        }
        this.cacheModel.putObject((Object)cacheKey, new Page(t, p));
        return t;
    }

    @Override
    public <T> List<T> executeQueryForList(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        CacheKey cacheKey = this.getCacheKey(statementScope, parameterObject);
        cacheKey.update("executeQueryForList");
        cacheKey.update(skipResults);
        cacheKey.update(maxResults);
        Object old = this.cacheModel.getObject(cacheKey);
        if (old == CacheModel.NULL_OBJECT) {
            return null;
        }
        if (old == null) {
            List list = this.statement.executeQueryForList(statementScope, trans, parameterObject, skipResults, maxResults);
            this.cacheModel.putObject((Object)cacheKey, list);
            return list;
        }
        return (List)Objects.uncheckedCast(old);
    }

    @Override
    public void executeQueryWithRowHandler(StatementScope statementScope, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        this.statement.executeQueryWithRowHandler(statementScope, trans, parameterObject, rowHandler);
    }

    @Override
    public <K, V> void executeQueryWithMapHandler(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults, MappedRowHandler<K, V> mapHandler) throws SQLException {
        CacheKey cacheKey = this.getCacheKey(statementScope, parameterObject);
        cacheKey.update("executeQueryWithMapHandler");
        cacheKey.update(skipResults);
        cacheKey.update(maxResults);
        Object old = this.cacheModel.getObject(cacheKey);
        if (old == CacheModel.NULL_OBJECT) {
            mapHandler.setMap(null);
        } else if (old == null) {
            this.statement.executeQueryWithMapHandler(statementScope, trans, parameterObject, skipResults, maxResults, mapHandler);
            this.cacheModel.putObject((Object)cacheKey, mapHandler.getMap());
        } else {
            mapHandler.setMap((Map)Objects.uncheckedCast(old));
        }
    }

    @Override
    public CacheKey getCacheKey(StatementScope statementScope, Object parameterObject) {
        CacheKey key = this.statement.getCacheKey(statementScope, parameterObject);
        return key;
    }

    @Override
    public int getBaseCacheKey() {
        return this.statement.getBaseCacheKey();
    }

    @Override
    public void setBaseCacheKey(int base) {
        this.statement.setBaseCacheKey(base);
    }

    @Override
    public void addExecuteListener(FlushListener listener) {
        this.statement.addExecuteListener(listener);
    }

    @Override
    public void notifyListeners(Object arg) {
        this.statement.notifyListeners(arg);
    }

    @Override
    public void initRequest(StatementScope statementScope) {
        this.statement.initRequest(statementScope);
    }

    @Override
    public Sql getSql() {
        return this.statement.getSql();
    }

    @Override
    public Class<?> getParameterClass() {
        return this.statement.getParameterClass();
    }

    @Override
    public Integer getTimeout() {
        return this.statement.getTimeout();
    }

    @Override
    public boolean hasMultipleResultMaps() {
        return this.statement.hasMultipleResultMaps();
    }

    @Override
    public ResultMap[] getAdditionalResultMaps() {
        return this.statement.getAdditionalResultMaps();
    }
}

