/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.SelectKeyStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import java.sql.SQLException;
import java.util.List;

public class InsertStatement
extends MappedStatement {
    static final ILog log = ILogFactory.getLog(InsertStatement.class);
    private SelectKeyStatement selectKeyStatement;

    @Override
    public StatementType getStatementType() {
        return StatementType.INSERT;
    }

    @Override
    public <T> T executeQueryForObject(StatementScope statementScope, Transaction trans, Object parameterObject, Object resultObject) throws SQLException {
        throw new SQLException("Insert statements cannot be executed as a query.");
    }

    @Override
    public <T> int executeQueryForPage(StatementScope statementScope, List<T> page, Transaction trans, Object paramObject, int skipResults, int maxResults) throws SQLException {
        throw new SQLException("Insert statements cannot be executed as a query.");
    }

    @Override
    public <T> List<T> executeQueryForList(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        throw new SQLException("Insert statements cannot be executed as a query.");
    }

    @Override
    public void executeQueryWithRowHandler(StatementScope statementScope, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        throw new SQLException("Update statements cannot be executed as a query.");
    }

    public SelectKeyStatement getSelectKeyStatement() {
        return this.selectKeyStatement;
    }

    public void setSelectKeyStatement(SelectKeyStatement selectKeyStatement) {
        this.selectKeyStatement = selectKeyStatement;
    }

    public Object executeInsert(StatementScope statementScope, Transaction trans, Object parameterObject) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        statementScope.getSession().setCommitRequired(true);
        try {
            parameterObject = this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(statementScope, parameterObject);
            statementScope.setResultMap(resultMap);
            statementScope.setParameterMap(parameterMap);
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(statementScope, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the statement or the result map.");
            errorContext.setConnection(trans.getConnection());
            Object generatedKey = this.getSqlExecutor().executeInsert(this.getId(), statementScope, trans.getConnection(), sqlString, parameters, this.selectKeyStatement.getResultMap());
            errorContext.setMoreInfo("Set back the generatedKey.");
            String keyProp = this.selectKeyStatement.getKeyProperty();
            if (keyProp != null) {
                ProbeFactory.getProbe().setObject(parameterObject, keyProp, generatedKey);
            }
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(statementScope, parameterObject, parameters);
            }
            sql.cleanup(statementScope);
            this.notifyListeners(null);
            return generatedKey;
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e);
        }
    }

    @Override
    public boolean isCanBatch() {
        return this.canBatch && (this.getSelectKeyStatement() == null || !this.getSelectKeyStatement().isRunAfterSQL());
    }

    @Override
    public void checkSql(ErrorContext ec) {
        Sql sql = this.getSql();
        String txt = sql.headText();
        if (txt != null && !txt.contains("into") && !txt.contains("INTO")) {
            ec.setObjectId(this.getId());
            ec.setDebugInfo("Maybe not insert/replace clause.");
            log.warn(ec.toStr());
        }
    }
}

