/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.Objects;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class MappedRowHandler<K, V>
implements RowHandler {
    Map<K, V> map = new LinkedHashMap();
    String keyProp;
    Class<K> keyType;
    String valueProp;
    Class<V> valueType;
    int keyIdx;
    int valueIdx;
    TypeHandler keyHander;
    TypeHandler valueHandler;
    boolean isUseColumnLabel;
    private TypeHandlerFactory typeHandlerFactory;

    public MappedRowHandler(TypeHandlerFactory typeHandlerFactory, boolean isUseColumnLabel, String keyProp, Class<K> keyType, String valueProp, Class<V> valueType) {
        this.typeHandlerFactory = typeHandlerFactory;
        this.isUseColumnLabel = isUseColumnLabel;
        this.keyProp = keyProp;
        this.keyType = keyType;
        this.valueProp = valueProp;
        this.valueType = valueType;
    }

    @Override
    public void handleRow(Object rsObject) throws SQLException {
        if (rsObject instanceof ResultSet) {
            ResultSet rs = (ResultSet)rsObject;
            if (this.keyIdx != 0 && this.valueIdx != 0) {
                Object key = null;
                key = this.keyHander != null ? (Object)Objects.uncheckedCast(this.keyHander.getResult(rs, this.keyIdx)) : (Object)Objects.uncheckedCast(this.typeHandlerFactory.getUnkownTypeHandler().getResult(rs, this.keyIdx));
                Object value = null;
                value = this.valueHandler != null ? (Object)Objects.uncheckedCast(this.valueHandler.getResult(rs, this.valueIdx)) : (Object)Objects.uncheckedCast(this.typeHandlerFactory.getUnkownTypeHandler().getResult(rs, this.valueIdx));
                this.map.put(key, value);
            }
        }
    }

    public void handleMeta(ResultSetMetaData md) throws SQLException {
        if (this.keyType != null) {
            this.keyHander = this.typeHandlerFactory.getTypeHandler(this.keyType);
        }
        if (this.valueType != null) {
            this.valueHandler = this.typeHandlerFactory.getTypeHandler(this.valueType);
        }
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            String colName;
            String string = colName = this.isUseColumnLabel ? md.getColumnLabel(i) : md.getColumnName(i);
            if (this.keyProp.equalsIgnoreCase(colName)) {
                this.keyIdx = i;
            }
            if (!this.valueProp.equalsIgnoreCase(colName)) continue;
            this.valueIdx = i;
        }
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    @Override
    public Integer getRows() {
        return this.map == null ? null : Integer.valueOf(this.map.size());
    }

    public void setMap(Map<K, V> map) {
        this.map = map;
    }
}

