/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.event.PageHandler;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.FlushListener;
import com.ibatis.sqlmap.engine.execution.Batch;
import com.ibatis.sqlmap.engine.execution.ExecuteNotifier;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.DefaultRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.MappedRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ibatis.client.TooManyResultException;

public class MappedStatement
implements ExecuteNotifier {
    private String id;
    private Integer resultSetType;
    private Integer fetchSize;
    private ResultMap resultMap;
    private ParameterMap parameterMap;
    private Class<?> parameterClass;
    private Sql sql;
    private int baseCacheKey;
    private SqlMapExecutorDelegate delegate;
    private Integer timeout;
    private ResultMap[] additionalResultMaps = new ResultMap[0];
    private List<FlushListener> executeListeners = new ArrayList<FlushListener>();
    private Map<Class<?>, FlushListener> flushEntitys = new HashMap();
    private Map<String, FlushListener> flushCacheModels = new HashMap<String, FlushListener>();
    private List<String> flushCacheRoots = new ArrayList<String>();
    private String resource;
    boolean canBatch;

    public StatementType getStatementType() {
        return StatementType.UNKNOWN;
    }

    public int executeUpdate(StatementScope statementScope, Transaction trans, Object parameterObject) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        statementScope.getSession().setCommitRequired(true);
        try {
            parameterObject = this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(statementScope, parameterObject);
            statementScope.setResultMap(resultMap);
            statementScope.setParameterMap(parameterMap);
            int rows = 0;
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(statementScope, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the statement or the result map.");
            errorContext.setConnection(trans.getConnection());
            rows = this.sqlExecuteUpdate(statementScope, trans.getConnection(), sqlString, parameters);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(statementScope, parameterObject, parameters);
            }
            sql.cleanup(statementScope);
            this.notifyListeners(statementScope.getSession());
            return rows;
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e);
        }
    }

    public <T> T executeQueryForObject(StatementScope statementScope, Transaction trans, Object parameterObject, Object resultObject) throws SQLException {
        try {
            T object = null;
            DefaultRowHandler rowHandler = new DefaultRowHandler();
            this.executeQueryWithCallback(statementScope, trans.getConnection(), parameterObject, resultObject, rowHandler, 0, 2);
            List list = rowHandler.getList();
            if (list.size() > 1) {
                ErrorContext errorContext = statementScope.getErrorContext();
                errorContext.setActivity(null);
                errorContext.setMoreInfo("executeQueryForObject returned too many results.");
                throw new NestedSQLException(errorContext.toString(), new TooManyResultException(list.size()));
            }
            if (list.size() > 0) {
                object = list.get(0);
            }
            return object;
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    public <T> List<T> executeQueryForList(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        try {
            DefaultRowHandler rowHandler = new DefaultRowHandler();
            this.executeQueryWithCallback(statementScope, trans.getConnection(), parameterObject, null, rowHandler, skipResults, maxResults);
            return rowHandler.getList();
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    public void executeQueryWithRowHandler(StatementScope statementScope, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        try {
            this.executeQueryWithCallback(statementScope, trans.getConnection(), parameterObject, null, rowHandler, 0, -1);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    protected void executeQueryWithCallback(StatementScope statementScope, Connection conn, Object parameterObject, Object resultObject, RowHandler rowHandler, int skipResults, int maxResults) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setConnection(conn);
        errorContext.setResource(this.getResource());
        try {
            parameterObject = this.validateParameter(parameterObject);
            Sql sql = this.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(statementScope, parameterObject);
            statementScope.setResultMap(resultMap);
            statementScope.setParameterMap(parameterMap);
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(statementScope, parameterObject);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the SQL statement or the result map.");
            RowHandlerCallback callback = new RowHandlerCallback(resultMap, resultObject, rowHandler);
            this.sqlExecuteQuery(statementScope, conn, sqlString, parameters, skipResults, maxResults, callback);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(statementScope, parameterObject, parameters);
            }
            sql.cleanup(statementScope);
            this.notifyListeners(null);
        }
        catch (SQLException e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), e);
        }
        catch (Exception e) {
            errorContext.setCause(e);
            throw new NestedSQLException(errorContext.toString(), e);
        }
    }

    protected void postProcessParameterObject(StatementScope statementScope, Object parameterObject, Object[] parameters) {
    }

    protected int sqlExecuteUpdate(StatementScope statementScope, Connection conn, String sqlString, Object[] parameters) throws SQLException {
        if (this.isCanBatch() && statementScope.getSession().isInBatch()) {
            return this.getSqlExecutor().addBatch(statementScope, conn, sqlString, parameters);
        }
        return this.getSqlExecutor().executeUpdate(this.getId(), statementScope, conn, sqlString, parameters);
    }

    protected void sqlExecuteQuery(StatementScope statementScope, Connection conn, String sqlString, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        if (callback.getRowHandler() instanceof PageHandler) {
            this.getSqlExecutor().executeQueryPage(this.getId(), statementScope, conn, sqlString, parameters, skipResults, maxResults, callback, (PageHandler)callback.getRowHandler());
        } else {
            this.getSqlExecutor().executeQuery(this.getId(), statementScope, conn, sqlString, parameters, skipResults, maxResults, callback);
        }
    }

    protected Object validateParameter(Object param) throws SQLException {
        Object newParam = param;
        Class<?> parameterClass = this.getParameterClass();
        if (newParam != null && parameterClass != null && !parameterClass.isAssignableFrom(newParam.getClass())) {
            throw new SQLException("Invalid parameter object type.  Expected '" + parameterClass.getName() + "' but found '" + newParam.getClass().getName() + "'.");
        }
        return newParam;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(Integer resultSetType) {
        this.resultSetType = resultSetType;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Sql getSql() {
        return this.sql;
    }

    public void setSql(Sql sql) {
        this.sql = sql;
    }

    public ResultMap getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(ResultMap resultMap) {
        this.resultMap = resultMap;
    }

    public ParameterMap getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Class<?> getParameterClass() {
        return this.parameterClass;
    }

    public void setParameterClass(Class<?> parameterClass) {
        this.parameterClass = parameterClass;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isCanBatch() {
        return this.canBatch;
    }

    public void setCanBatch(boolean canBatch) {
        this.canBatch = canBatch;
    }

    public CacheKey getCacheKey(StatementScope statementScope, Object parameterObject) {
        Sql sql = statementScope.getSql();
        ParameterMap pmap = sql.getParameterMap(statementScope, parameterObject);
        CacheKey cacheKey = pmap.getCacheKey(statementScope, parameterObject);
        cacheKey.update(this.id);
        cacheKey.update(this.baseCacheKey);
        cacheKey.update(sql.getSql(statementScope, parameterObject));
        return cacheKey;
    }

    public int getBaseCacheKey() {
        return this.baseCacheKey;
    }

    public void setBaseCacheKey(int base) {
        this.baseCacheKey = base;
    }

    public synchronized void addExecuteListener(FlushListener listener) {
        if (!this.executeListeners.contains(listener)) {
            this.executeListeners.add(listener);
        }
    }

    @Override
    public synchronized void notifyListeners(Object arg) {
        FlushListener cache;
        Batch batch;
        if (arg instanceof SessionScope && (batch = ((SessionScope)arg).getBatch()) != null && !batch.isCleanup() && batch.hasNotifier(this)) {
            return;
        }
        long timestamp = arg instanceof Long ? (Long)arg : System.currentTimeMillis();
        for (String string : this.flushCacheRoots) {
            this.getDelegate().getCacheRoots().flushRoots(timestamp, string);
        }
        for (FlushListener flushListener : this.executeListeners) {
            flushListener.onFlush(this.getId(), timestamp);
        }
        for (Map.Entry entry : this.flushEntitys.entrySet()) {
            cache = (FlushListener)entry.getValue();
            if (cache != null) {
                cache.onFlush(this.getId(), timestamp);
                continue;
            }
            cache = this.getDelegate().getEntityManager().findEntityCache((Class)entry.getKey());
            if (cache == null) continue;
            entry.setValue(cache);
            cache.onFlush(this.getId(), timestamp);
        }
        for (Map.Entry entry : this.flushCacheModels.entrySet()) {
            cache = (FlushListener)entry.getValue();
            if (cache != null) {
                cache.onFlush(this.getId(), timestamp);
                continue;
            }
            cache = this.getDelegate().findCacheModel((String)entry.getKey());
            if (cache == null) continue;
            entry.setValue(cache);
            cache.onFlush(this.getId(), timestamp);
        }
    }

    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public void initRequest(StatementScope statementScope) {
        statementScope.setStatement(this);
        statementScope.setParameterMap(this.parameterMap);
        statementScope.setResultMap(this.resultMap);
        statementScope.setSql(this.sql);
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void addResultMap(ResultMap resultMap) {
        ResultMap[] resultMaps = Arrays.copyOf(this.additionalResultMaps, this.additionalResultMaps.length + 1);
        resultMaps[this.additionalResultMaps.length] = resultMap;
        this.additionalResultMaps = resultMaps;
    }

    public boolean hasMultipleResultMaps() {
        return this.additionalResultMaps.length > 0;
    }

    public ResultMap[] getAdditionalResultMaps() {
        return this.additionalResultMaps;
    }

    public <T> int executeQueryForPage(StatementScope statementScope, List<T> page, Transaction trans, Object paramObject, int skipResults, int maxResults) throws SQLException {
        try {
            PageHandler rowHandler = new PageHandler(page);
            this.executeQueryWithCallback(statementScope, trans.getConnection(), paramObject, null, rowHandler, skipResults, maxResults);
            return rowHandler.getTotal();
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    public <K, V> void executeQueryWithMapHandler(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults, MappedRowHandler<K, V> mapHandler) throws SQLException {
        try {
            this.executeQueryWithCallback(statementScope, trans.getConnection(), parameterObject, null, mapHandler, skipResults, maxResults);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    public synchronized void addFlushEntityCache(Class<?> entityClass) {
        this.flushEntitys.put(entityClass, null);
    }

    public synchronized void addFlushCacheModel(String cacheModel) {
        this.flushCacheModels.put(cacheModel, null);
    }

    public synchronized void addFlushCacheRoot(String name) {
        if (!this.flushCacheRoots.contains(name)) {
            this.flushCacheRoots.add(name);
        }
    }

    public void checkSql(ErrorContext ec) {
    }
}

