/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.engine.mapping.result.AutoResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.sql.SqlChild;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.DynamicSql;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import java.sql.SQLException;
import java.util.List;

public class SelectStatement
extends MappedStatement {
    static final ILog log = ILogFactory.getLog(SelectStatement.class);

    @Override
    public StatementType getStatementType() {
        return StatementType.SELECT;
    }

    @Override
    public int executeUpdate(StatementScope statementScope, Transaction trans, Object parameterObject) throws SQLException {
        throw new SQLException("Select statements cannot be executed as an update.");
    }

    @Override
    public void checkSql(ErrorContext ec) {
        Sql sql = this.getSql();
        String txt = sql.headText();
        if (txt != null && !txt.contains("select") && !txt.contains("SELECT")) {
            ec.setObjectId(this.getId());
            ec.setDebugInfo("Maybe not select clause.");
            log.warn(ec.toStr());
        }
        if (sql instanceof DynamicSql && this.getResultMap() instanceof AutoResultMap && !this.getResultMap().isAllowRemapping()) {
            DynamicSql dsql = (DynamicSql)sql;
            List<SqlChild> list = dsql.getChildren();
            boolean tag = false;
            for (SqlChild sc : list) {
                String s;
                if (sc instanceof SqlTag) {
                    tag = true;
                }
                if (!(sc instanceof SqlText) || !(s = ((SqlText)sc).getText()).contains(" FROM ") && !s.contains(" from ")) continue;
                if (!tag) break;
                ec.setObjectId(this.getId());
                ec.setDebugInfo("Maybe should set remapResults = true");
                log.warn(ec.toStr());
                break;
            }
        }
    }
}

