/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import java.sql.SQLException;
import java.util.List;

public class UpdateStatement
extends MappedStatement {
    static final ILog log = ILogFactory.getLog(UpdateStatement.class);

    @Override
    public StatementType getStatementType() {
        return StatementType.UPDATE;
    }

    @Override
    public <T> T executeQueryForObject(StatementScope statementScope, Transaction trans, Object parameterObject, Object resultObject) throws SQLException {
        throw new SQLException("Update statements cannot be executed as a query.");
    }

    @Override
    public <T> int executeQueryForPage(StatementScope statementScope, List<T> page, Transaction trans, Object paramObject, int skipResults, int maxResults) throws SQLException {
        throw new SQLException("Update statements cannot be executed as a query.");
    }

    @Override
    public <T> List<T> executeQueryForList(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        throw new SQLException("Update statements cannot be executed as a query.");
    }

    @Override
    public void executeQueryWithRowHandler(StatementScope statementScope, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        throw new SQLException("Update statements cannot be executed as a query.");
    }

    @Override
    public void checkSql(ErrorContext ec) {
        Sql sql = this.getSql();
        String txt = sql.headText();
        if (txt != null && !txt.contains("update") && !txt.contains("UPDATE")) {
            ec.setObjectId(this.getId());
            ec.setDebugInfo("Maybe not update clause.");
            log.warn(ec.toStr());
        }
    }
}

