/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.scope;

import com.ibatis.common.Objects;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;

public class ErrorContext {
    private String conn;
    private String resource;
    private String activity;
    private String objectId;
    private String sql;
    private String extraSql;
    private Object[] args;
    private String batchInfo;
    private String moreInfo;
    private String debugInfo;
    private Object cause;
    private int total;
    static final String Prefix = "\n  +-- ";
    static final String Prefix2 = "\n  +--- ";
    static final NumberFormat nf = NumberFormat.getNumberInstance();

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getExtraSql() {
        return this.extraSql;
    }

    public void setExtraSql(String sql) {
        this.extraSql = sql;
    }

    public void setBatchInfo(String batchInfo) {
        this.batchInfo = batchInfo;
    }

    public void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
    }

    public Object getCause() {
        return this.cause;
    }

    public void setCause(Object cause) {
        this.cause = cause;
    }

    public String toStr(List<ErrorContext> list) {
        StringBuilder message = new StringBuilder();
        this.toStr(Prefix, message);
        if (list != null) {
            for (ErrorContext ec : list) {
                ec.toStr(Prefix2, message);
            }
        }
        return message.toString();
    }

    public String toStr() {
        StringBuilder message = new StringBuilder();
        this.toStr(Prefix, message);
        return message.toString();
    }

    void toStr(String Prefix, StringBuilder message) {
        if (this.objectId != null) {
            message.append(Prefix);
            message.append("Current_obj - ");
            message.append(this.objectId);
            if (this.conn != null) {
                message.append(" of ");
                message.append(this.conn);
            }
            if (this.resource != null) {
                message.append(" in ");
                message.append(this.resource);
            }
        } else if (this.activity != null) {
            message.append(Prefix);
            message.append("Current_act - ");
            message.append(this.activity);
            if (this.conn != null) {
                message.append(" of ");
                message.append(this.conn);
            }
            if (this.resource != null) {
                message.append(" in ");
                message.append(this.resource);
            }
        }
        if (this.sql != null) {
            message.append(Prefix);
            message.append("Current_sql - ");
            message.append(this.sql);
        }
        if (this.extraSql != null) {
            message.append(Prefix);
            message.append("Extra_sql - ");
            message.append(this.extraSql);
        }
        if (this.args != null && this.args.length > 0) {
            message.append(Prefix);
            if (this.batchInfo != null) {
                message.append("Lasted_args - ");
            } else {
                message.append("Current_args - ");
            }
            ErrorContext.asList(message, this.args);
        }
        if (this.batchInfo != null) {
            message.append(Prefix);
            message.append(this.batchInfo);
        }
        if (this.debugInfo != null) {
            message.append(Prefix);
            message.append(this.debugInfo);
        }
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        if (this.resource != null) {
            message.append(Prefix);
            message.append("The error occurred in ");
            message.append(this.resource);
            message.append('.');
        }
        if (this.activity != null) {
            message.append(Prefix);
            message.append("The error occurred while ");
            message.append(this.activity);
            message.append('.');
        }
        if (this.conn != null) {
            message.append(Prefix);
            message.append("Current connection - ");
            message.append(this.conn);
        }
        if (this.objectId != null) {
            message.append(Prefix);
            message.append("Current object - ");
            message.append(this.objectId);
        }
        if (this.sql != null) {
            message.append(Prefix);
            message.append("Current sql - ");
            message.append(this.sql);
        }
        if (this.extraSql != null) {
            message.append(Prefix);
            message.append("Extra sql - ");
            message.append(this.extraSql);
        }
        if (this.args != null && this.args.length > 0) {
            message.append(Prefix);
            if (this.batchInfo != null) {
                message.append("Lasted args - ");
            } else {
                message.append("Current args - ");
            }
            ErrorContext.asList(message, this.args);
        }
        if (this.batchInfo != null) {
            message.append(Prefix);
            message.append(this.batchInfo);
        }
        if (this.moreInfo != null) {
            message.append(Prefix);
            message.append(this.moreInfo);
        }
        if (this.cause != null) {
            if (this.cause instanceof SQLException) {
                message.append(Prefix);
                message.append("ErrorCode: ");
                message.append(((SQLException)this.cause).getErrorCode());
                message.append(", SqlState: ");
                message.append(((SQLException)this.cause).getSQLState());
                message.append(", Cause: ");
            } else {
                message.append(Prefix);
                message.append("Cause: ");
            }
            message.append(String.valueOf(this.cause).replace('\n', ' '));
        }
        return message.toString();
    }

    static void asList(StringBuilder buf, Object[] array) {
        buf.append("{ ");
        for (int i = 0; i < array.length; ++i) {
            Object obj;
            if (i > 0) {
                buf.append(", ");
            }
            if ((obj = array[i]) == null) {
                buf.append("null");
                continue;
            }
            if (obj instanceof Number) {
                double d = ((Number)obj).doubleValue();
                if (d <= 65535.0 && d >= -65536.0) {
                    buf.append(nf.format(d));
                    continue;
                }
                buf.append(obj);
                continue;
            }
            if (obj instanceof Date) {
                Objects.outputDate(buf, (Date)obj);
                continue;
            }
            if (obj instanceof String) {
                String s = (String)obj;
                if (s.indexOf(10) >= 0 || s.length() > 256) {
                    buf.append("(...skip ").append(s.length()).append(" chars...)");
                    continue;
                }
                buf.append("'").append(s).append("'");
                continue;
            }
            if (obj instanceof Boolean) {
                buf.append(obj);
                continue;
            }
            if (obj instanceof byte[]) {
                buf.append("byte[").append(((byte[])obj).length).append(']');
                continue;
            }
            if (obj instanceof char[]) {
                buf.append("char[").append(((char[])obj).length).append(']');
                continue;
            }
            if (obj instanceof Character) {
                buf.append("'").append(obj).append("'");
                continue;
            }
            if (obj instanceof Enum) {
                buf.append("'").append(((Enum)obj).name()).append("'");
                continue;
            }
            buf.append(obj.getClass().getSimpleName()).append("@").append(Integer.toHexString(System.identityHashCode(obj)));
        }
        buf.append(" }");
    }

    public void reset() {
        this.resource = null;
        this.activity = null;
        this.objectId = null;
        this.sql = null;
        this.args = null;
        this.moreInfo = null;
        this.cause = null;
    }

    public void setArgs(Object[] args) {
        if (args != null && args.length > 0) {
            this.args = args;
        }
    }

    public void setConnection(Connection conn) {
        this.conn = String.valueOf(conn.hashCode());
    }

    public void setConnectionCode(String conn) {
        this.conn = conn;
    }

    public void setTotal(int totalResults) {
        this.total = totalResults;
    }

    public int getTotal() {
        return this.total;
    }

    static {
        nf.setMaximumFractionDigits(5);
        nf.setMaximumIntegerDigits(10);
        nf.setGroupingUsed(false);
    }
}

