/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.scope;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapTransactionManager;
import com.ibatis.sqlmap.engine.execution.Batch;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionState;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SessionScope {
    private SqlMapClient sqlMapClient;
    private SqlMapExecutor sqlMapExecutor;
    private SqlMapTransactionManager sqlMapTxMgr;
    private Transaction transaction;
    private TransactionState transactionState;
    private TransactionState savedTransactionState;
    private int batchSize = 0;
    public boolean autoBatch;
    private Batch batch;
    private boolean commitRequired;
    private Map<Object, PreparedStatement> preparedStatements = new HashMap<Object, PreparedStatement>();

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapExecutor getSqlMapExecutor() {
        return this.sqlMapExecutor;
    }

    public void setSqlMapExecutor(SqlMapExecutor sqlMapExecutor) {
        this.sqlMapExecutor = sqlMapExecutor;
    }

    public SqlMapTransactionManager getSqlMapTxMgr() {
        return this.sqlMapTxMgr;
    }

    public void setSqlMapTxMgr(SqlMapTransactionManager sqlMapTxMgr) {
        this.sqlMapTxMgr = sqlMapTxMgr;
    }

    public boolean isInBatch() {
        return this.batchSize != 0;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setInBatch(int inBatch) {
        this.batchSize = inBatch;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    public boolean isCommitRequired() {
        return this.commitRequired;
    }

    public void setCommitRequired(boolean commitRequired) {
        this.commitRequired = commitRequired;
    }

    public boolean hasPreparedStatementFor(Object key) {
        return this.preparedStatements.containsKey(key);
    }

    public boolean hasPreparedStatement(PreparedStatement ps) {
        return this.preparedStatements.containsValue(ps);
    }

    public PreparedStatement getPreparedStatement(Object key) throws SQLException {
        if (!this.hasPreparedStatementFor(key)) {
            throw new SqlMapException("Could not get prepared statement.  This is likely a bug.");
        }
        PreparedStatement ps = this.preparedStatements.get(key);
        return ps;
    }

    public void putPreparedStatement(SqlMapExecutorDelegate delegate, Object key, PreparedStatement ps) {
        if (delegate.isStatementCacheEnabled() && !this.isInBatch()) {
            if (this.hasPreparedStatementFor(key)) {
                throw new SqlMapException("Duplicate prepared statement found.  This is likely a bug.");
            }
            this.preparedStatements.put(key, ps);
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
    }

    public void cleanup() {
        for (PreparedStatement ps : this.preparedStatements.values()) {
            try {
                ps.close();
            }
            catch (Exception exception) {}
        }
        this.preparedStatements.clear();
    }

    public void saveTransactionState() {
        this.savedTransactionState = this.transactionState;
    }

    public void recallTransactionState() {
        this.transactionState = this.savedTransactionState;
    }
}

