/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction;

import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.TransactionState;
import java.sql.SQLException;

public class TransactionManager {
    private TransactionConfig config;

    public TransactionManager(TransactionConfig transactionConfig) {
        this.config = transactionConfig;
    }

    public void begin(SessionScope sessionScope) throws SQLException, TransactionException {
        this.begin(sessionScope, -9999);
    }

    public void begin(SessionScope sessionScope, int transactionIsolation) throws SQLException, TransactionException {
        Transaction trans = sessionScope.getTransaction();
        TransactionState state = sessionScope.getTransactionState();
        if (state == TransactionState.STATE_STARTED) {
            throw new TransactionException("TransactionManager could not start a new transaction.  A transaction is already started.");
        }
        if (state == TransactionState.STATE_USER_PROVIDED) {
            throw new TransactionException("TransactionManager could not start a new transaction.  A user provided connection is currently being used by this session.  The calling .setUserConnection (null) will clear the user provided transaction.");
        }
        trans = this.config.newTransaction(transactionIsolation);
        sessionScope.setCommitRequired(false);
        sessionScope.setTransaction(trans);
        sessionScope.setTransactionState(TransactionState.STATE_STARTED);
    }

    public void commit(SessionScope sessionScope) throws SQLException, TransactionException {
        Transaction trans = sessionScope.getTransaction();
        TransactionState state = sessionScope.getTransactionState();
        if (state == TransactionState.STATE_USER_PROVIDED) {
            throw new TransactionException("TransactionManager could not commit.  A user provided connection is currently being used by this session.  You must call the commit() method of the Connection directly.  The calling .setUserConnection (null) will clear the user provided transaction.");
        }
        if (state != TransactionState.STATE_STARTED && state != TransactionState.STATE_COMMITTED) {
            throw new TransactionException("TransactionManager could not commit.  No transaction is started.");
        }
        if (sessionScope.isCommitRequired() || this.config.isForceCommit()) {
            trans.commit();
            sessionScope.setCommitRequired(false);
        }
        sessionScope.setTransactionState(TransactionState.STATE_COMMITTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(SessionScope sessionScope) throws SQLException, TransactionException {
        block8: {
            Transaction trans = sessionScope.getTransaction();
            TransactionState state = sessionScope.getTransactionState();
            if (state == TransactionState.STATE_USER_PROVIDED) {
                throw new TransactionException("TransactionManager could not end this transaction.  A user provided connection is currently being used by this session.  You must call the rollback() method of the Connection directly.  The calling .setUserConnection (null) will clear the user provided transaction.");
            }
            try {
                if (trans == null) break block8;
                try {
                    if (state != TransactionState.STATE_COMMITTED && (sessionScope.isCommitRequired() || this.config.isForceCommit())) {
                        trans.rollback();
                        sessionScope.setCommitRequired(false);
                    }
                }
                finally {
                    sessionScope.cleanup();
                    trans.close();
                }
            }
            finally {
                sessionScope.setTransaction(null);
                sessionScope.setTransactionState(TransactionState.STATE_ENDED);
            }
        }
    }

    public TransactionConfig getConfig() {
        return this.config;
    }
}

