/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigDecimalTypeHandler
extends BaseTypeHandler<BigDecimal> {
    @Override
    public void setParameter(PreparedStatement ps, int i, BigDecimal parameter, String jdbcType) throws SQLException {
        ps.setBigDecimal(i, parameter);
    }

    @Override
    public BigDecimal getResult(ResultSet rs, String columnName) throws SQLException {
        BigDecimal bigdec = rs.getBigDecimal(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return bigdec;
    }

    @Override
    public BigDecimal getResult(ResultSet rs, int columnIndex) throws SQLException {
        BigDecimal bigdec = rs.getBigDecimal(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return bigdec;
    }

    @Override
    public BigDecimal getResult(CallableStatement cs, int columnIndex) throws SQLException {
        BigDecimal bigdec = cs.getBigDecimal(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return bigdec;
    }

    @Override
    public BigDecimal valueOf(Object s) {
        if (s == null) {
            return null;
        }
        if (s instanceof Boolean) {
            return Boolean.TRUE.equals(s) ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return new BigDecimal(s.toString());
    }
}

