/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import com.ibatis.sqlmap.engine.type.SimpleDateFormatter;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class DateTypeHandler
extends BaseTypeHandler<Date> {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    @Override
    public void setParameter(PreparedStatement ps, int i, Date parameter, String jdbcType) throws SQLException {
        ps.setTimestamp(i, new Timestamp(parameter.getTime()));
    }

    @Override
    public Date getResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp sqlTimestamp = rs.getTimestamp(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return new Date(sqlTimestamp.getTime());
    }

    @Override
    public Date getResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp sqlTimestamp = rs.getTimestamp(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return new Date(sqlTimestamp.getTime());
    }

    @Override
    public Date getResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp sqlTimestamp = cs.getTimestamp(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return new Date(sqlTimestamp.getTime());
    }

    @Override
    public Date valueOf(Object s) {
        if (s == null) {
            return null;
        }
        if (s instanceof Date) {
            return (Date)s;
        }
        return SimpleDateFormatter.format(DATE_FORMAT, s.toString());
    }
}

