/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class EnumTypeHandler<T extends Enum<T>>
extends BaseTypeHandler<T> {
    private Class<T> type;

    public EnumTypeHandler(Class<T> type) {
        this.type = type;
    }

    @Override
    public void setParameter(PreparedStatement ps, int i, T parameter, String jdbcType) throws SQLException {
        ps.setString(i, ((Enum)parameter).toString());
    }

    @Override
    public T getResult(ResultSet rs, String columnName) throws SQLException {
        String s = rs.getString(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return Enum.valueOf(this.type, s);
    }

    @Override
    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        String s = rs.getString(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return Enum.valueOf(this.type, s);
    }

    @Override
    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String s = cs.getString(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return Enum.valueOf(this.type, s);
    }

    @Override
    public T valueOf(Object s) {
        return Enum.valueOf(this.type, s.toString());
    }
}

