/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import com.ibatis.sqlmap.engine.type.SimpleDateFormatter;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Date;

public class TimeOnlyTypeHandler
extends BaseTypeHandler<Date> {
    private static final String DATE_FORMAT = "HH:mm:ss";

    @Override
    public void setParameter(PreparedStatement ps, int i, Date parameter, String jdbcType) throws SQLException {
        ps.setTime(i, new Time(parameter.getTime()));
    }

    @Override
    public Date getResult(ResultSet rs, String columnName) throws SQLException {
        Time sqlTime = rs.getTime(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return new Date(sqlTime.getTime());
    }

    @Override
    public Date getResult(ResultSet rs, int columnIndex) throws SQLException {
        Time sqlTime = rs.getTime(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return new Date(sqlTime.getTime());
    }

    @Override
    public Date getResult(CallableStatement cs, int columnIndex) throws SQLException {
        Time sqlTime = cs.getTime(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return new Date(sqlTime.getTime());
    }

    @Override
    public Date valueOf(Object s) {
        if (s == null) {
            return null;
        }
        return SimpleDateFormatter.format(DATE_FORMAT, s.toString());
    }
}

