/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ibatis.asm.Case;
import org.ibatis.asm.Label;
import org.ibatis.asm.MethodVisitor;
import org.ibatis.asm.Opcodes;
import org.ibatis.asm.Type;

public class MethodEmitter
extends MethodVisitor
implements Opcodes {
    List<Label> labels;
    final boolean trace;

    public MethodEmitter(boolean trace, MethodVisitor mv) {
        super(262144, mv);
        this.trace = trace;
        if (trace) {
            this.labels = new ArrayList<Label>();
        }
    }

    public void start_method() {
        this.mv.visitCode();
    }

    public void end_method() {
        if (this.trace) {
            for (Label l : this.labels) {
                if (l.marked) continue;
                throw l.trace;
            }
        }
        this.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    public void catch_exception(Label start, Label end, Type exception) {
        this.mv.visitTryCatchBlock(start, end, this.mark(), exception.getInternalName());
    }

    public void catch_finally(Label start, Label end) {
        this.mv.visitTryCatchBlock(start, end, this.mark(), null);
    }

    public void jump(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    public void ifnull(Label label) {
        this.mv.visitJumpInsn(198, label);
    }

    public void ifnonnull(Label label) {
        this.mv.visitJumpInsn(199, label);
    }

    public void if_jump(int mode, Label label) {
        this.mv.visitJumpInsn(mode, label);
    }

    public void if_icmp(int mode, Label label) {
        this.if_cmp(T_int, mode, label);
    }

    public void if_cmp(Type type, int mode, Label label) {
        int intOp = -1;
        int jumpmode = mode;
        switch (mode) {
            case 156: {
                jumpmode = 155;
                break;
            }
            case 158: {
                jumpmode = 157;
            }
        }
        switch (type.getSort()) {
            case 7: {
                this.mv.visitInsn(148);
                break;
            }
            case 8: {
                this.mv.visitInsn(152);
                break;
            }
            case 6: {
                this.mv.visitInsn(150);
                break;
            }
            case 9: 
            case 10: {
                switch (mode) {
                    case 153: {
                        this.mv.visitJumpInsn(165, label);
                        return;
                    }
                    case 154: {
                        this.mv.visitJumpInsn(166, label);
                        return;
                    }
                }
                throw new IllegalArgumentException("Bad comparison for type " + type);
            }
            default: {
                switch (mode) {
                    case 153: {
                        intOp = 159;
                        break;
                    }
                    case 154: {
                        intOp = 160;
                        break;
                    }
                    case 156: {
                        this.swap();
                    }
                    case 155: {
                        intOp = 161;
                        break;
                    }
                    case 158: {
                        this.swap();
                    }
                    case 157: {
                        intOp = 163;
                    }
                }
                this.mv.visitJumpInsn(intOp, label);
                return;
            }
        }
        this.if_jump(jumpmode, label);
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void pop2() {
        this.mv.visitInsn(88);
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void dup2() {
        this.mv.visitInsn(92);
    }

    public void dup_x1() {
        this.mv.visitInsn(90);
    }

    public void dup_x2() {
        this.mv.visitInsn(91);
    }

    public void dup2_x1() {
        this.mv.visitInsn(93);
    }

    public void dup2_x2() {
        this.mv.visitInsn(94);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void aconst_null() {
        this.mv.visitInsn(1);
    }

    public void swap(Type prev, Type type) {
        if (type.getSize() == 1) {
            if (prev.getSize() == 1) {
                this.swap();
            } else {
                this.dup_x2();
                this.pop();
            }
        } else if (prev.getSize() == 1) {
            this.dup2_x1();
            this.pop2();
        } else {
            this.dup2_x2();
            this.pop2();
        }
    }

    public void monitorenter() {
        this.mv.visitInsn(194);
    }

    public void monitorexit() {
        this.mv.visitInsn(195);
    }

    public void math(int op, Type type) {
        this.mv.visitInsn(type.getOpcode(op));
    }

    public void array_load(Type type) {
        this.mv.visitInsn(type.getOpcode(46));
    }

    public void array_store(Type type) {
        this.mv.visitInsn(type.getOpcode(79));
    }

    public void cast_numeric(Type from, Type to) {
        if (from != to) {
            if (from == T_double) {
                if (to == T_float) {
                    this.mv.visitInsn(144);
                } else if (to == T_long) {
                    this.mv.visitInsn(143);
                } else {
                    this.mv.visitInsn(142);
                    this.cast_numeric(T_int, to);
                }
            } else if (from == T_float) {
                if (to == T_double) {
                    this.mv.visitInsn(141);
                } else if (to == T_long) {
                    this.mv.visitInsn(140);
                } else {
                    this.mv.visitInsn(139);
                    this.cast_numeric(T_int, to);
                }
            } else if (from == T_long) {
                if (to == T_double) {
                    this.mv.visitInsn(138);
                } else if (to == T_float) {
                    this.mv.visitInsn(137);
                } else {
                    this.mv.visitInsn(136);
                    this.cast_numeric(T_int, to);
                }
            } else if (to == T_byte) {
                this.mv.visitInsn(145);
            } else if (to == T_char) {
                this.mv.visitInsn(146);
            } else if (to == T_double) {
                this.mv.visitInsn(135);
            } else if (to == T_float) {
                this.mv.visitInsn(134);
            } else if (to == T_long) {
                this.mv.visitInsn(133);
            } else if (to == T_short) {
                this.mv.visitInsn(147);
            }
        }
    }

    public void push(int i) {
        if (i < -1) {
            this.mv.visitLdcInsn(new Integer(i));
        } else if (i <= 5) {
            this.mv.visitInsn(MethodEmitter.ICONST(i));
        } else if (i <= 127) {
            this.mv.visitIntInsn(16, i);
        } else if (i <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, i);
        } else {
            this.mv.visitLdcInsn(new Integer(i));
        }
    }

    public void push(long value) {
        if (value == 0L || value == 1L) {
            this.mv.visitInsn(MethodEmitter.LCONST(value));
        } else {
            this.mv.visitLdcInsn(new Long(value));
        }
    }

    public void push(float value) {
        if (value == 0.0f || value == 1.0f || value == 2.0f) {
            this.mv.visitInsn(MethodEmitter.FCONST(value));
        } else {
            this.mv.visitLdcInsn(new Float(value));
        }
    }

    public void push(double value) {
        if (value == 0.0 || value == 1.0) {
            this.mv.visitInsn(MethodEmitter.DCONST(value));
        } else {
            this.mv.visitLdcInsn(new Double(value));
        }
    }

    public void push(String value) {
        this.mv.visitLdcInsn(value);
    }

    public void push(Class<?> value) {
        this.push(Type.getType(value));
    }

    public void push(Type value) {
        if (value.isPrimitive()) {
            Type t = value.toReferenceType();
            this.mv.visitFieldInsn(178, t.getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void push_default(Type type) {
        switch (type.getSort()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mv.visitInsn(3);
                break;
            }
            case 6: {
                this.mv.visitInsn(11);
                break;
            }
            case 7: {
                this.mv.visitInsn(9);
                break;
            }
            case 8: {
                this.mv.visitInsn(14);
                break;
            }
            default: {
                this.mv.visitInsn(1);
            }
        }
    }

    public void newarray() {
        this.newarray(T_Object);
    }

    public void newarray(Type type) {
        if (type.isPrimitive()) {
            this.mv.visitIntInsn(188, MethodEmitter.NEWARRAY(type));
        } else {
            this.emit_type(189, type);
        }
    }

    public void arraylength() {
        this.mv.visitInsn(190);
    }

    public void load_this() {
        this.mv.visitVarInsn(25, 0);
    }

    public void load_local(Type t, int pos) {
        this.mv.visitVarInsn(t.getOpcode(21), pos);
    }

    public void store_local(Type t, int pos) {
        this.mv.visitVarInsn(t.getOpcode(54), pos);
    }

    public void iinc(int index, int amount) {
        this.mv.visitIincInsn(index, amount);
    }

    public void return_value(Type type) {
        this.mv.visitInsn(type.getOpcode(172));
    }

    public void return_void() {
        this.mv.visitInsn(177);
    }

    public void super_getfield(Type superType, String name, Type type) {
        this.emit_field(180, superType, name, type);
    }

    public void super_putfield(Type superType, String name, Type type) {
        this.emit_field(181, superType, name, type);
    }

    public void super_getstatic(Type superType, String name, Type type) {
        this.emit_field(178, superType, name, type);
    }

    public void super_putstatic(Type superType, String name, Type type) {
        this.emit_field(179, superType, name, type);
    }

    public void getfield(Type owner, String name, Type type) {
        this.emit_field(180, owner, name, type);
    }

    public void putfield(Type owner, String name, Type type) {
        this.emit_field(181, owner, name, type);
    }

    public void getstatic(Type owner, String name, Type type) {
        this.emit_field(178, owner, name, type);
    }

    public void putstatic(Type owner, String name, Type type) {
        this.emit_field(179, owner, name, type);
    }

    void emit_field(int opcode, Type ctype, String name, Type ftype) {
        this.mv.visitFieldInsn(opcode, ctype.getInternalName(), name, ftype.getDescriptor());
    }

    public void super_invoke(Type superType, String name, String desc) {
        this.mv.visitMethodInsn(183, superType.getInternalName(), name, desc, false);
    }

    public void invoke_constructor(Type type) {
        this.invoke_constructor(type, "()V");
    }

    public void super_invoke_constructor(Type superType) {
        this.invoke_constructor(superType);
    }

    public void invoke_constructor_this(Type thisType) {
        this.invoke_constructor(thisType);
    }

    public void invoke_method(Method m) {
        Type type = Type.getType(m.getDeclaringClass());
        if (m.getName().equals("<init>")) {
            this.invoke_constructor(type, Type.getMethodDescriptor(m));
        } else if ((0x200 & m.getDeclaringClass().getModifiers()) != 0) {
            this.invoke_interface(type, m.getName(), Type.getMethodDescriptor(m));
        } else if ((8 & m.getModifiers()) != 0) {
            this.invoke_static(type, m.getName(), Type.getMethodDescriptor(m));
        } else {
            this.invoke_virtual(type, m.getName(), Type.getMethodDescriptor(m));
        }
    }

    public void invoke_interface(Type owner, String name, String desc) {
        this.mv.visitMethodInsn(185, owner.getInternalName(), name, desc, true);
    }

    public void invoke_virtual(Type owner, String name, String desc) {
        this.mv.visitMethodInsn(182, owner.getInternalName(), name, desc, false);
    }

    public void invoke_static(Type owner, String name, String desc) {
        this.mv.visitMethodInsn(184, owner.getInternalName(), name, desc, false);
    }

    public void invoke_virtual_this(Type thisType, String name, String desc) {
        this.invoke_virtual(thisType, name, desc);
    }

    public void invoke_constructor(Type type, String desc) {
        this.mv.visitMethodInsn(183, type.getInternalName(), "<init>", desc, false);
    }

    public void invoke_constructor_this(Type thisType, String desc) {
        this.invoke_constructor(thisType, desc);
    }

    public void super_invoke_constructor(Type thisType, String desc) {
        this.invoke_constructor(thisType, desc);
    }

    public void new_instance_this(Type thisType) {
        this.new_instance(thisType);
    }

    public void new_instance(Type type) {
        this.emit_type(187, type);
    }

    private void emit_type(int opcode, Type type) {
        String desc = type.isArray() ? type.getDescriptor() : type.getInternalName();
        this.mv.visitTypeInsn(opcode, desc);
    }

    public void aaload(int index) {
        this.push(index);
        this.aaload();
    }

    public void aaload() {
        this.mv.visitInsn(50);
    }

    public void aastore() {
        this.mv.visitInsn(83);
    }

    public void athrow() {
        this.mv.visitInsn(191);
    }

    public Label make_label() {
        Label l = new Label();
        if (this.trace) {
            l.trace = new RuntimeException();
            this.labels.add(l);
        }
        return l;
    }

    public void checkcast_this(Type thisType) {
        this.checkcast(thisType);
    }

    public void checkcast(Type type) {
        if (!type.equals(T_Object)) {
            this.emit_type(192, type);
        }
    }

    public void instance_of(Type type) {
        this.emit_type(193, type);
    }

    public void instance_of_this(Type thisType) {
        this.instance_of(thisType);
    }

    public void process_switch(int[] keys, Case callback) {
        float density = keys.length == 0 ? 0.0f : (float)keys.length / (float)(keys[keys.length - 1] - keys[0] + 1);
        this.process_switch(keys, callback, density >= 0.5f);
    }

    public void process_switch(int[] keys, Case callback, boolean table) {
        if (!MethodEmitter.isSorted(keys)) {
            throw new IllegalArgumentException("keys to switch must be sorted ascending");
        }
        Label def = this.make_label();
        Label end = this.make_label();
        if (keys.length > 0) {
            int len = keys.length;
            int min = keys[0];
            int max = keys[len - 1];
            int range = max - min + 1;
            if (table) {
                int i;
                Object[] labels = new Label[range];
                Arrays.fill(labels, def);
                for (i = 0; i < len; ++i) {
                    labels[keys[i] - min] = this.make_label();
                }
                this.mv.visitTableSwitchInsn(min, max, def, (Label[])labels);
                for (i = 0; i < range; ++i) {
                    Object label = labels[i];
                    if (label == def) continue;
                    this.mark((Label)label);
                    callback.processCase(this, i + min, end);
                }
            } else {
                int i;
                Label[] labels = new Label[len];
                for (i = 0; i < len; ++i) {
                    labels[i] = this.make_label();
                }
                this.mv.visitLookupSwitchInsn(def, keys, labels);
                for (i = 0; i < len; ++i) {
                    this.mark(labels[i]);
                    callback.processCase(this, keys[i], end);
                }
            }
        }
        this.mark(def);
        callback.processDefault(this);
        this.mark(end);
    }

    static boolean isSorted(int[] keys) {
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i] >= keys[i - 1]) continue;
            return false;
        }
        return true;
    }

    public void mark_local(String name, Type type, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, type.getDescriptor(), null, start, end, index);
    }

    public void mark(Label label) {
        if (label.marked) {
            throw new IllegalStateException();
        }
        label.marked = true;
        this.mv.visitLabel(label);
    }

    public Label mark() {
        Label label = this.make_label();
        if (label.marked) {
            throw new IllegalStateException();
        }
        label.marked = true;
        this.mv.visitLabel(label);
        return label;
    }

    public void push(boolean value) {
        this.push(value ? 1 : 0);
    }

    public void not() {
        this.push(1);
        this.math(130, T_int);
    }

    public void throw_exception(Type type, String msg) {
        this.new_instance(type);
        this.dup();
        this.push(msg);
        this.invoke_constructor(type, Type.getMethodDescriptor(T_void, T_String));
        this.athrow();
    }

    public void box(Type type) {
        if (type.isPrimitive()) {
            Type boxed = type.toReferenceType();
            this.invoke_static(boxed, "valueOf", Type.getMethodDescriptor(boxed, type));
        }
    }

    public void unbox(Type type) {
        if (type.getSort() < 1 || type.getSort() > 8) {
            throw new IllegalArgumentException();
        }
        String sig = null;
        Type t = T_Number;
        switch (type.getSort()) {
            case 2: {
                t = T_Character;
                sig = "charValue";
                break;
            }
            case 1: {
                t = T_Boolean;
                sig = "booleanValue";
                break;
            }
            case 8: {
                sig = "doubleValue";
                break;
            }
            case 6: {
                sig = "floatValue";
                break;
            }
            case 7: {
                sig = "longValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                sig = "intValue";
            }
        }
        this.invoke_virtual(t, sig, Type.getMethodDescriptor(type, new Type[0]));
    }

    public void unbox_or_zero(Type type) {
        if (type.isPrimitive()) {
            if (type != T_void) {
                Label nonNull = this.make_label();
                Label end = this.make_label();
                this.dup();
                this.ifnonnull(nonNull);
                this.pop();
                this.zero_or_null(type);
                this.jump(end);
                this.mark(nonNull);
                this.unbox(type);
                this.mark(end);
            }
        } else {
            this.checkcast(type);
        }
    }

    public void zero_or_null(Type type) {
        if (type.isPrimitive()) {
            switch (type.getSort()) {
                case 8: {
                    this.push(0.0);
                    break;
                }
                case 7: {
                    this.push(0L);
                    break;
                }
                case 6: {
                    this.push(0.0f);
                    break;
                }
                case 0: {
                    this.aconst_null();
                }
                default: {
                    this.push(0);
                    break;
                }
            }
        } else {
            this.aconst_null();
        }
    }

    static int ICONST(int value) {
        switch (value) {
            case -1: {
                return 2;
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
        }
        return -1;
    }

    static int LCONST(long value) {
        if (value == 0L) {
            return 9;
        }
        if (value == 1L) {
            return 10;
        }
        return -1;
    }

    static int FCONST(float value) {
        if (value == 0.0f) {
            return 11;
        }
        if (value == 1.0f) {
            return 12;
        }
        if (value == 2.0f) {
            return 13;
        }
        return -1;
    }

    static int DCONST(double value) {
        if (value == 0.0) {
            return 14;
        }
        if (value == 1.0) {
            return 15;
        }
        return -1;
    }

    static int NEWARRAY(Type type) {
        switch (type.getSort()) {
            case 3: {
                return 8;
            }
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 4: {
                return 9;
            }
            case 1: {
                return 4;
            }
        }
        return -1;
    }
}

