/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.cglib;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.ibatis.asm.ClassWriter;
import org.ibatis.asm.Label;
import org.ibatis.asm.MethodEmitter;
import org.ibatis.asm.Opcodes;
import org.ibatis.asm.Type;
import org.ibatis.cglib.NamingPolicy;
import org.ibatis.cglib.Predicate;
import org.ibatis.cglib.ReflectUtil;

public abstract class BulkBeanX
implements Opcodes {
    final int size;

    protected BulkBeanX(int size) {
        this.size = size;
    }

    public abstract void getPropertyValues(Object var1, Object[] var2);

    public abstract void setPropertyValues(Object var1, Object[] var2);

    public Object[] getPropertyValues(Object bean) {
        Object[] values = new Object[this.size];
        this.getPropertyValues(bean, values);
        return values;
    }

    public static BulkBeanX create(final Class<?> target, Object key, String[] propertyNames, Method[] getters, Method[] setters, Field[] fields) throws Exception {
        Type beanType = Type.getType(target);
        String cn = NamingPolicy.SIMPLE.getClassName(target.getName(), "BulkBean", key, new Predicate(){

            @Override
            public boolean evaluate(Object arg) {
                try {
                    target.getClassLoader().loadClass((String)arg);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        Type goal = Type.getObjectType(cn.replace('.', '/'));
        Type BULK_BEAN = Type.getType(BulkBeanX.class);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 4129, goal.getInternalName(), null, BULK_BEAN.getInternalName(), null);
        cw.visitSource("<generated>", null);
        MethodEmitter e = cw.visitMethodX(false, 1, "<init>", "()V", null, null);
        e.start_method();
        Label start = e.mark();
        e.load_local(goal, 0);
        e.push(propertyNames.length);
        e.invoke_constructor(BULK_BEAN, "(I)V");
        e.return_void();
        Label end = e.mark();
        e.mark_local("this", goal, start, end, 0);
        e.end_method();
        e = cw.visitMethodX(false, 1, "getPropertyValues", "(Ljava/lang/Object;[Ljava/lang/Object;)V", null, null);
        e.start_method();
        start = e.mark();
        e.load_local(T_Object, 1);
        e.checkcast(beanType);
        e.store_local(beanType, 3);
        Label bean = e.mark();
        Type oarray = T_Object.getArrayType(1);
        for (int i = 0; i < propertyNames.length; ++i) {
            if (fields[i] != null) {
                Field f = fields[i];
                Type owner = Type.getType(f.getDeclaringClass());
                Type type = Type.getType(f.getType());
                e.load_local(oarray, 2);
                e.push(i);
                if ((f.getModifiers() & 8) == 0) {
                    e.load_local(beanType, 3);
                    e.getfield(owner, f.getName(), type);
                } else {
                    e.getstatic(owner, f.getName(), type);
                }
                e.box(type);
                e.aastore();
                continue;
            }
            Method m = getters[i];
            e.load_local(oarray, 2);
            e.push(i);
            if ((m.getModifiers() & 8) == 0) {
                e.load_local(beanType, 3);
            }
            e.invoke_method(m);
            e.box(Type.getType(m.getReturnType()));
            e.aastore();
        }
        e.return_value(T_void);
        Label end2 = e.mark();
        e.mark_local("this", goal, start, end2, 0);
        e.mark_local("obj", T_Object, start, end2, 1);
        e.mark_local("values", oarray, start, end2, 2);
        e.mark_local("bean", beanType, bean, end2, 3);
        e.end_method();
        e = cw.visitMethodX(false, 1, "setPropertyValues", "(Ljava/lang/Object;[Ljava/lang/Object;)V", null, null);
        e.start_method();
        start = e.mark();
        e.load_local(T_Object, 1);
        e.checkcast(beanType);
        e.store_local(beanType, 3);
        Type oarray2 = T_Object.getArrayType(1);
        for (int i = 0; i < propertyNames.length; ++i) {
            if (fields[i] != null) {
                Field f = fields[i];
                Type owner = Type.getType(f.getDeclaringClass());
                Type type = Type.getType(f.getType());
                if ((f.getModifiers() & 8) == 0) {
                    e.load_local(beanType, 3);
                }
                e.load_local(oarray2, 2);
                e.aaload(i);
                if (type.isPrimitive()) {
                    e.checkcast(type.toReferenceType());
                    e.unbox_or_zero(type);
                } else {
                    e.checkcast(type);
                }
                if ((f.getModifiers() & 8) == 0) {
                    e.putfield(owner, f.getName(), type);
                    continue;
                }
                e.putstatic(owner, f.getName(), type);
                continue;
            }
            Method m = setters[i];
            Type atype = Type.getType(m.getParameterTypes()[0]);
            if ((m.getModifiers() & 8) == 0) {
                e.load_local(beanType, 3);
            }
            e.load_local(oarray2, 2);
            e.aaload(i);
            if (atype.isPrimitive()) {
                e.checkcast(atype.toReferenceType());
                e.unbox_or_zero(atype);
            } else {
                e.checkcast(atype);
            }
            e.invoke_method(m);
        }
        e.return_value(T_void);
        Label end3 = e.mark();
        e.mark_local("this", goal, start, end3, 0);
        e.mark_local("obj", T_Object, start, end3, 1);
        e.mark_local("values", oarray2, start, end3, 2);
        e.mark_local("bean", beanType, start, end3, 2);
        e.end_method();
        cw.visitEnd();
        byte[] bs = cw.toByteArray();
        Class<?> clazz = ReflectUtil.defineClass(cn, bs, target.getClassLoader());
        return (BulkBeanX)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

