/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.cglib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ibatis.cglib.GetFieldInvoker;
import org.ibatis.cglib.Invoker;
import org.ibatis.cglib.MethodInvoker;
import org.ibatis.cglib.SetFieldInvoker;

public class ClassInfo {
    private static boolean cacheEnabled = true;
    private static final Map<Class<?>, ClassInfo> CLASS_INFO_MAP = new HashMap();
    private static final Map<Class<?>, ClassInfo> CLASS_INFO_MAP_STRICT = new HashMap();
    private String className;
    private boolean strict;
    private Map<String, Invoker> setMethods = new LinkedHashMap<String, Invoker>();
    private Map<String, Invoker> getMethods = new LinkedHashMap<String, Invoker>();
    private Map<String, Class<?>> setTypes = new LinkedHashMap();
    private Map<String, Class<?>> getTypes = new LinkedHashMap();
    private Constructor<?> defaultConstructor;
    private List<String> propertyNames = new ArrayList<String>();

    private ClassInfo(Class<?> clazz, boolean strict) {
        if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
            throw new RuntimeException("Not top-level or static class: " + clazz.getName());
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new RuntimeException("Not public class: " + clazz.getName());
        }
        this.strict = strict;
        this.className = clazz.getName();
        this.addDefaultConstructor(clazz);
        this.addGetMethods(clazz);
        this.addSetMethods(clazz);
        this.addFields(clazz);
        if (strict) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.addAll(this.getMethods.keySet());
            set.retainAll(this.setMethods.keySet());
            LinkedHashMap<String, Invoker> _setMethods = new LinkedHashMap<String, Invoker>();
            LinkedHashMap<String, Invoker> _getMethods = new LinkedHashMap<String, Invoker>();
            LinkedHashMap _setTypes = new LinkedHashMap();
            LinkedHashMap _getTypes = new LinkedHashMap();
            for (String key : set) {
                if (this.getTypes.get(key) != this.setTypes.get(key)) continue;
                _getMethods.put(key, this.getMethods.get(key));
                _setMethods.put(key, this.setMethods.get(key));
                _getTypes.put(key, this.getTypes.get(key));
                _setTypes.put(key, this.setTypes.get(key));
            }
            this.getMethods = _getMethods;
            this.setMethods = _setMethods;
            this.getTypes = _getTypes;
            this.setTypes = _setTypes;
            HashSet<String> attrs = new HashSet<String>();
            for (String key : ((HashMap)_getMethods).keySet()) {
                attrs.add(((Invoker)((HashMap)_getMethods).get(key)).getName());
            }
            this.propertyNames.addAll(attrs);
        } else {
            HashSet<String> attrs = new HashSet<String>();
            for (String key : this.getMethods.keySet()) {
                attrs.add(this.getMethods.get(key).getName());
            }
            for (String key : this.setMethods.keySet()) {
                attrs.add(this.setMethods.get(key).getName());
            }
            this.propertyNames.addAll(attrs);
        }
        Collections.sort(this.propertyNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase(Locale.ENGLISH).compareTo(o2.toLowerCase(Locale.ENGLISH));
            }
        });
    }

    public List<String> getPropertyNames() {
        return Collections.unmodifiableList(this.propertyNames);
    }

    private void addDefaultConstructor(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.defaultConstructor = constructor;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addGetMethods(Class<?> cls) {
        Method[] methods = this.getClassMethods(cls);
        block0: for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            for (Class<?> e : method.getExceptionTypes()) {
                if (Exception.class.isAssignableFrom(e) && !RuntimeException.class.isAssignableFrom(e)) continue block0;
            }
            String name = method.getName();
            if (name.startsWith("get") && name.length() > 3) {
                if (method.getParameterTypes().length != 0) continue;
                name = name.substring(3);
                this.addGetMethod(ClassInfo.dropCase(name), method);
                continue;
            }
            if (!name.startsWith("is") || name.length() <= 2 || method.getParameterTypes().length != 0 || method.getReturnType() != Boolean.class && method.getReturnType() != Boolean.TYPE) continue;
            name = name.substring(2);
            this.addGetMethod(ClassInfo.dropCase(name), method);
        }
    }

    void addGetMethod(String name, Method method) {
        MethodInvoker mi = new MethodInvoker(name, method, false);
        Class<?> rt = method.getReturnType();
        this.getMethods.put(name.toLowerCase(Locale.ENGLISH), mi);
        this.getTypes.put(name.toLowerCase(Locale.ENGLISH), rt);
    }

    private void addSetMethods(Class<?> cls) {
        Method[] methods = this.getClassMethods(cls);
        block0: for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            for (Class<?> e : method.getExceptionTypes()) {
                if (Exception.class.isAssignableFrom(e) && !RuntimeException.class.isAssignableFrom(e)) continue block0;
            }
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3 || method.getParameterTypes().length != 1) continue;
            name = name.substring(3);
            this.addSetMethod(ClassInfo.dropCase(name), method);
        }
    }

    void addSetMethod(String name, Method method) {
        MethodInvoker mi = new MethodInvoker(name, method, true);
        Class<?> pt = method.getParameterTypes()[0];
        this.setMethods.put(name.toLowerCase(Locale.ENGLISH), mi);
        this.setTypes.put(name.toLowerCase(Locale.ENGLISH), pt);
    }

    private void addFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (Modifier.isFinal(field.getModifiers()) || this.strict && Modifier.isStatic(field.getModifiers())) continue;
            Invoker setter = this.setMethods.get(field.getName().toLowerCase(Locale.ENGLISH));
            if (setter == null) {
                this.addSetField(field);
            } else {
                setter.fixAccess(field);
            }
            Invoker getter = this.getMethods.get(field.getName().toLowerCase(Locale.ENGLISH));
            if (getter == null) {
                this.addGetField(field);
                continue;
            }
            getter.fixAccess(field);
        }
        if (clazz.getSuperclass() != null) {
            this.addFields(clazz.getSuperclass());
        }
    }

    void addSetField(Field field) {
        if (Modifier.isPublic(field.getModifiers())) {
            this.setMethods.put(field.getName().toLowerCase(Locale.ENGLISH), new SetFieldInvoker(field));
            this.setTypes.put(field.getName().toLowerCase(Locale.ENGLISH), field.getType());
        }
    }

    void addGetField(Field field) {
        if (Modifier.isPublic(field.getModifiers())) {
            this.getMethods.put(field.getName().toLowerCase(Locale.ENGLISH), new GetFieldInvoker(field));
            this.getTypes.put(field.getName().toLowerCase(Locale.ENGLISH), field.getType());
        }
    }

    private Method[] getClassMethods(Class<?> cls) {
        LinkedHashMap<String, Method> methodSet = new LinkedHashMap<String, Method>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            this.addUniqueMethods(methodSet, currentClass.getDeclaredMethods());
            Class<?>[] interfaces = currentClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addUniqueMethods(methodSet, interfaces[i].getMethods());
            }
        }
        Collection methods = methodSet.values();
        return methods.toArray(new Method[methods.size()]);
    }

    private void addUniqueMethods(Map<String, Method> mmap, Method[] methods) {
        for (Method m : methods) {
            String name;
            if (this.strict && Modifier.isStatic(m.getModifiers()) || !(name = m.getName()).startsWith("get") && !name.startsWith("is") && !name.startsWith("set") || m.isBridge() || !Modifier.isPublic(m.getModifiers()) || mmap.containsKey(name.toLowerCase(Locale.ENGLISH))) continue;
            mmap.put(name.toLowerCase(Locale.ENGLISH), m);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Object instantiateClass() {
        if (this.defaultConstructor != null) {
            try {
                return this.defaultConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating class. Cause: " + e, e);
            }
        }
        throw new RuntimeException("Error instantiating class. No default constructor for class " + this.className);
    }

    public Invoker getSetInvoker(String propertyName) {
        Invoker method = this.setMethods.get(propertyName.toLowerCase(Locale.ENGLISH));
        if (method == null) {
            throw new RuntimeException("No WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Invoker getGetInvoker(String propertyName) {
        Invoker method = this.getMethods.get(propertyName.toLowerCase(Locale.ENGLISH));
        if (method == null) {
            throw new RuntimeException("No READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Class<?> getSetterType(String propertyName) {
        Class<?> clazz = this.setTypes.get(propertyName.toLowerCase(Locale.ENGLISH));
        if (clazz == null) {
            throw new RuntimeException("No WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return clazz;
    }

    public Class<?> getGetterType(String propertyName) {
        Class<?> clazz = this.getTypes.get(propertyName.toLowerCase(Locale.ENGLISH));
        if (clazz == null) {
            throw new RuntimeException("No READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return clazz;
    }

    public boolean hasWritableProperty(String propertyName) {
        return this.setMethods.containsKey(propertyName.toLowerCase(Locale.ENGLISH));
    }

    public boolean hasReadableProperty(String propertyName) {
        return this.getMethods.containsKey(propertyName.toLowerCase(Locale.ENGLISH));
    }

    public static ClassInfo getInstance(Class<?> clazz) {
        return ClassInfo.getInstance(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfo getInstance(Class<?> clazz, boolean strict) {
        if (cacheEnabled) {
            ClassInfo cached = null;
            if (strict) {
                Map<Class<?>, ClassInfo> map = CLASS_INFO_MAP_STRICT;
                synchronized (map) {
                    cached = CLASS_INFO_MAP_STRICT.get(clazz);
                    if (cached == null) {
                        cached = new ClassInfo(clazz, strict);
                        CLASS_INFO_MAP_STRICT.put(clazz, cached);
                    }
                }
            }
            Map<Class<?>, ClassInfo> map = CLASS_INFO_MAP;
            synchronized (map) {
                cached = CLASS_INFO_MAP.get(clazz);
                if (cached == null) {
                    cached = new ClassInfo(clazz, strict);
                    CLASS_INFO_MAP.put(clazz, cached);
                }
            }
            return cached;
        }
        return new ClassInfo(clazz, strict);
    }

    public static void setCacheEnabled(boolean cacheEnabled) {
        ClassInfo.cacheEnabled = cacheEnabled;
    }

    public static Throwable unwrapThrowable(Throwable t) {
        Throwable t2 = t;
        while (true) {
            if (t2 instanceof InvocationTargetException) {
                t2 = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (!(t2 instanceof UndeclaredThrowableException)) break;
            t2 = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        return t2;
    }

    public static String dropCase(String name) {
        int firstLower = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            firstLower = i;
            break;
        }
        if (firstLower == -1) {
            return name.toLowerCase(Locale.ENGLISH);
        }
        if (firstLower == 0) {
            return name;
        }
        if (firstLower == 1) {
            return name.substring(0, firstLower).toLowerCase(Locale.ENGLISH) + name.substring(firstLower);
        }
        return name.substring(0, firstLower - 1).toLowerCase(Locale.ENGLISH) + name.substring(firstLower - 1);
    }
}

