/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.cglib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ibatis.asm.ClassWriter;
import org.ibatis.asm.Label;
import org.ibatis.asm.MethodEmitter;
import org.ibatis.asm.Opcodes;
import org.ibatis.asm.Type;
import org.ibatis.cglib.FastMember;
import org.ibatis.cglib.NamingPolicy;
import org.ibatis.cglib.Predicate;
import org.ibatis.cglib.ReflectUtil;

public class FastConstructor
extends FastMember
implements Opcodes {
    private Constructor<?> constructor;
    private static final Map<Object, FastConstructor> factorys = new LinkedHashMap<Object, FastConstructor>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, FastConstructor> eldest) {
            return this.size() > ReflectUtil.getCatchSize();
        }
    };
    private static Type constructorType = Type.getType(Constructor.class);

    @Deprecated
    public FastConstructor(Constructor<?> constructor) {
        super(constructor);
        this.constructor = constructor;
    }

    public Object newInstance(Object ... args) throws InvocationTargetException {
        try {
            return this.constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastConstructor create(Constructor<?> constructor) {
        if ((constructor.getModifiers() & 2) != 0) {
            throw new IllegalArgumentException("Private constructor: " + constructor);
        }
        Constructor<?> key = constructor;
        FastConstructor fc = null;
        try {
            Map<Object, FastConstructor> map = factorys;
            synchronized (map) {
                fc = factorys.get(key);
                if (fc == null) {
                    fc = FastConstructor.doCreate(constructor);
                    factorys.put(key, fc);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return fc;
    }

    private static FastConstructor doCreate(Constructor<?> constructor) throws Exception {
        final Class<?> target = constructor.getDeclaringClass();
        Type targetType = Type.getType(target);
        String cn = NamingPolicy.SIMPLE.getClassName(target.getName(), "new", "FC" + constructor.getParameterCount(), new Predicate(){

            @Override
            public boolean evaluate(Object arg) {
                try {
                    target.getClassLoader().loadClass((String)arg);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        Type goal = Type.getObjectType(cn.replace('.', '/'));
        Type superType = Type.getType(FastConstructor.class);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 4129, goal.getInternalName(), null, superType.getInternalName(), null);
        cw.visitSource("<generated>", null);
        String desc = Type.getMethodDescriptor(T_void, constructorType);
        MethodEmitter e = cw.visitMethodX(false, 1, "<init>", desc, null, null);
        e.start_method();
        Label start = e.mark();
        e.load_local(goal, 0);
        e.load_local(constructorType, 1);
        e.invoke_constructor(superType, desc);
        e.return_void();
        Label end = e.mark();
        e.mark_local("this", goal, start, end, 0);
        e.end_method();
        Type objArrayType = T_Object.getArrayType(1);
        e = cw.visitMethodX(false, 129, "newInstance", Type.getMethodDescriptor(T_Object, objArrayType), null, null);
        e.start_method();
        start = e.mark();
        e.new_instance(targetType);
        e.dup();
        Class<?>[] pcs = constructor.getParameterTypes();
        for (int j = 0; j < pcs.length; ++j) {
            e.load_local(objArrayType, 1);
            e.aaload(j);
            Type pt = Type.getType(pcs[j]);
            if (pt.isPrimitive()) {
                e.checkcast(pt.toReferenceType());
                e.unbox_or_zero(pt);
                continue;
            }
            e.checkcast(pt);
        }
        e.invoke_constructor(targetType, Type.getConstructorDescriptor(constructor));
        e.return_value(T_Object);
        Label end2 = e.mark();
        e.mark_local("this", goal, start, end2, 0);
        e.end_method();
        cw.visitEnd();
        byte[] bs = cw.toByteArray();
        Class<?> clazz = ReflectUtil.defineClass(cn, bs, target.getClassLoader());
        try {
            return (FastConstructor)clazz.getConstructor(Constructor.class).newInstance(constructor);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }
}

