/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.cglib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ibatis.asm.ClassWriter;
import org.ibatis.asm.Label;
import org.ibatis.asm.MethodEmitter;
import org.ibatis.asm.Opcodes;
import org.ibatis.asm.Type;
import org.ibatis.cglib.FastMember;
import org.ibatis.cglib.NamingPolicy;
import org.ibatis.cglib.Predicate;
import org.ibatis.cglib.ReflectUtil;

public class FastMethod
extends FastMember
implements Opcodes {
    private final Method method;
    private static final Map<Object, FastMethod> factorys = new LinkedHashMap<Object, FastMethod>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, FastMethod> eldest) {
            return this.size() > ReflectUtil.getCatchSize();
        }
    };

    @Deprecated
    public FastMethod(Method method) {
        super(method);
        this.method = method;
    }

    public Object invoke(Object target, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.method.invoke(target, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastMethod create(Method method) {
        if ((method.getModifiers() & 2) != 0) {
            throw new IllegalArgumentException("Private method: " + method);
        }
        if ((method.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException("Abstract method: " + method);
        }
        Method key = method;
        FastMethod fm = null;
        try {
            Map<Object, FastMethod> map = factorys;
            synchronized (map) {
                fm = factorys.get(key);
                if (fm == null) {
                    fm = FastMethod.doCreate(method);
                    factorys.put(key, fm);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return fm;
    }

    private static FastMethod doCreate(Method method) throws Exception {
        final Class<?> target = method.getDeclaringClass();
        Type targetType = Type.getType(target);
        String cn = NamingPolicy.SIMPLE.getClassName(target.getName(), method.getName(), "FM" + method.getParameterTypes().length, new Predicate(){

            @Override
            public boolean evaluate(Object arg) {
                try {
                    target.getClassLoader().loadClass((String)arg);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        Type goal = Type.getObjectType(cn.replace('.', '/'));
        Type superType = Type.getType(FastMethod.class);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 4129, goal.getInternalName(), null, superType.getInternalName(), null);
        cw.visitSource("<generated>", null);
        String desc = Type.getMethodDescriptor(T_void, T_Method);
        MethodEmitter e = cw.visitMethodX(false, 1, "<init>", desc, null, null);
        e.start_method();
        Label start = e.mark();
        e.load_local(goal, 0);
        e.load_local(T_Method, 1);
        e.invoke_constructor(superType, desc);
        e.return_void();
        Label end = e.mark();
        e.mark_local("this", goal, start, end, 0);
        e.end_method();
        Type objArrayType = T_Object.getArrayType(1);
        e = cw.visitMethodX(false, 129, "invoke", Type.getMethodDescriptor(T_Object, T_Object, objArrayType), null, null);
        e.start_method();
        start = e.mark();
        if ((method.getModifiers() & 8) == 0) {
            e.load_local(goal, 1);
            e.checkcast(targetType);
        }
        Class<?>[] pcs = method.getParameterTypes();
        for (int j = 0; j < pcs.length; ++j) {
            e.load_local(objArrayType, 2);
            e.aaload(j);
            Type pt = Type.getType(pcs[j]);
            if (pt.isPrimitive()) {
                e.checkcast(pt.toReferenceType());
                e.unbox_or_zero(pt);
                continue;
            }
            e.checkcast(pt);
        }
        e.invoke_method(method);
        Type rt = Type.getType(method.getReturnType());
        if (rt.isVoid()) {
            e.aconst_null();
        } else if (rt.isPrimitive()) {
            e.box(rt);
        }
        e.return_value(T_Object);
        Label end2 = e.mark();
        e.mark_local("this", goal, start, end2, 0);
        e.end_method();
        cw.visitEnd();
        byte[] bs = cw.toByteArray();
        Class<?> clazz = ReflectUtil.defineClass(cn, bs, target.getClassLoader());
        try {
            return (FastMethod)clazz.getConstructor(Method.class).newInstance(method);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }
}

