/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.cglib;

import com.ibatis.common.Objects;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public abstract class Invoker {
    final List<Annotation> annos = new ArrayList<Annotation>();
    private String name;

    public Invoker(String name) {
        this.name = name;
    }

    public abstract String getAccessName();

    public abstract Class<?> getType();

    public final String getName() {
        return this.name;
    }

    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation anno : this.annos) {
            if (!annotationClass.isAssignableFrom(anno.getClass())) continue;
            return (T)((Annotation)Objects.uncheckedCast(anno));
        }
        return null;
    }

    public abstract Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException;

    final void fixAccess(AccessibleObject ao) {
        Annotation[] annotations = ao.getAnnotations();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                this.annos.add(anno);
            }
        }
        if (ao instanceof Field) {
            this.name = ((Field)ao).getName();
        }
        try {
            ao.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ao.toString());
        }
    }
}

