/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.cglib;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ibatis.cglib.FastMethod;
import org.ibatis.cglib.Invoker;

public class MethodInvoker
extends Invoker {
    private static final ILog log = ILogFactory.getLog(Invoker.class);
    private Method method;
    private FastMethod fastMethod;
    boolean beSetter;

    public MethodInvoker(String name, Method method, boolean beSetter) {
        super(name);
        this.method = method;
        this.beSetter = beSetter;
        this.fixAccess(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object target, Object ... args) throws IllegalAccessException, InvocationTargetException {
        if (this.fastMethod == null) {
            MethodInvoker methodInvoker = this;
            synchronized (methodInvoker) {
                try {
                    this.fastMethod = FastMethod.create(this.method);
                }
                catch (Throwable e) {
                    log.warn("Failed to create fast method for " + this.method + ", " + e);
                    System.err.println("Failed to create fast method for " + this.method + ", " + e);
                }
                if (this.fastMethod == null) {
                    this.fastMethod = new FastMethod(this.method);
                }
            }
        }
        try {
            return this.fastMethod.invoke(target, args);
        }
        catch (IllegalArgumentException e) {
            if (args != null && args.length == 1 && args[0] == null) {
                return null;
            }
            throw e;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getAccessName() {
        return this.method.getName() + "()";
    }

    public AccessibleObject getAccessibleObject() {
        return this.method;
    }

    @Override
    public Class<?> getType() {
        if (this.beSetter) {
            return this.method.getParameterTypes()[0];
        }
        return this.method.getReturnType();
    }
}

