/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.cglib.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ibatis.asm.Case;
import org.ibatis.asm.ClassWriter;
import org.ibatis.asm.FieldVisitor;
import org.ibatis.asm.Label;
import org.ibatis.asm.MethodEmitter;
import org.ibatis.asm.Opcodes;
import org.ibatis.asm.Type;
import org.ibatis.cglib.NamingPolicy;
import org.ibatis.cglib.Predicate;
import org.ibatis.cglib.ReflectUtil;
import org.ibatis.cglib.proxy.Callback;
import org.ibatis.cglib.proxy.CallbackFilter;
import org.ibatis.cglib.proxy.Factory;
import org.ibatis.cglib.proxy.MProxy;
import org.ibatis.cglib.proxy.MethodProxy;

public class Enhancer
implements Opcodes {
    private static final boolean debug = false;
    Class<?> superclass;
    CallbackFilter filter;
    Callback[] callbacks = new Callback[0];
    boolean entity;
    NamingPolicy namingPolicy;
    private static final Map<Object, Class<? extends Factory>> factorys = new LinkedHashMap<Object, Class<? extends Factory>>(){
        private static final long serialVersionUID = 4291658538184450258L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, Class<? extends Factory>> eldest) {
            return this.size() > ReflectUtil.getCatchSize();
        }
    };
    private static final Type proxyType = Type.getType(MethodProxy.class);
    private static final Type proxyImplType = Type.getType(MProxy.class);
    private static final Type callbackType = Type.getType(Callback.class);
    private static final Type callbackArrayType = callbackType.getArrayType(1);
    private static final Type factoryType = Type.getType(Factory.class);
    private static final Type strArrayType = T_String.getArrayType(1);
    private static final Type classArrayType = T_Class.getArrayType(1);
    private static final Type objectArrayType = T_Object.getArrayType(1);
    private static final Type aoType = Type.getType(AccessibleObject.class);
    private static final Type aoArrayType = aoType.getArrayType(1);

    public static Object create(Class<?> type, CallbackFilter filter, Callback ... callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(type);
        e.setCallback(callback);
        e.setCallbackFilter(filter);
        return e.create(false);
    }

    public Object create() {
        return this.create(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(boolean entity) {
        this.entity = entity;
        Object key = this.toKey();
        try {
            Class<? extends Factory> clazz = null;
            Map<Object, Class<? extends Factory>> map = factorys;
            synchronized (map) {
                clazz = factorys.get(key);
                if (clazz == null) {
                    clazz = this.doCreate(key);
                    factorys.put(key, clazz);
                }
            }
            Factory f = clazz.newInstance();
            for (int i = 0; i < this.callbacks.length; ++i) {
                f.setCallback(i, this.callbacks[i]);
            }
            return f;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Object toKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.superclass);
        key.add(this.filter);
        for (Callback cb : this.callbacks) {
            key.add(cb);
        }
        key.add(this.entity);
        return key;
    }

    public void setCallbackFilter(CallbackFilter filter) {
        this.filter = filter;
    }

    public void setCallback(Callback ... callbacks) {
        for (Callback cb : callbacks) {
            if (cb != null) continue;
            throw new IllegalArgumentException("Null or empty callbacks");
        }
        this.callbacks = callbacks;
    }

    public void setSuperclass(Class<?> superclass) {
        int mod = superclass.getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isAbstract(mod)) {
            throw new IllegalArgumentException("Cannot inherit " + superclass);
        }
        if (Factory.class.isAssignableFrom(superclass)) {
            throw new IllegalArgumentException(superclass + " is a Factory");
        }
        try {
            if (Modifier.isPrivate(superclass.getDeclaredConstructor(new Class[0]).getModifiers())) {
                throw new IllegalArgumentException(superclass + " has no default Constructor");
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(superclass + " has no default Constructor");
        }
        this.superclass = superclass;
    }

    public void setNamingPolicy(NamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
    }

    public static boolean isEnhanced(Class<?> type) {
        return type.isSynthetic() && Factory.class.isAssignableFrom(type);
    }

    public static boolean isGenerated(Class<?> type) {
        if (Enhancer.isEnhanced(type)) {
            return true;
        }
        for (Class<?> iface : type.getInterfaces()) {
            if (!iface.getName().endsWith(".cglib.proxy.Factory")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Class<? extends Factory> doCreate(Object key) throws Exception {
        String desc;
        List<Method> allMethods = ReflectUtil.loadMethods(this.superclass);
        LinkedHashMap<Method, Integer> methods = ReflectUtil.filterMethods(allMethods, this.filter, this.callbacks);
        LinkedHashMap<Method, MProxy> allProxys = new LinkedHashMap<Method, MProxy>();
        final ArrayList<Method> proxys = new ArrayList<Method>();
        for (Method m : methods.keySet()) {
            int mIdx = methods.get(m);
            MProxy proxy = new MProxy(mIdx, m, m);
            allProxys.put(m, proxy);
            if (mIdx < 0) continue;
            proxys.add(m);
        }
        final ArrayList<String> attrs = new ArrayList<String>();
        LinkedHashMap<String, String> as = new LinkedHashMap<String, String>();
        final LinkedHashMap<String, AccessibleObject[]> aos = new LinkedHashMap<String, AccessibleObject[]>();
        boolean advanced = this.entity;
        if (advanced) {
            Object ao;
            Map<String, Field> fields = ReflectUtil.loadFields(this.superclass);
            Map<Method, String> propNames = ReflectUtil.mapPropertyName(allMethods);
            for (Method m : proxys) {
                Field field;
                String attr = propNames.get(m);
                if (attr == null) continue;
                MProxy proxy = (MProxy)allProxys.get(m);
                ao = new ArrayList();
                if (m.getAnnotations().length > 0) {
                    ao.add(m);
                }
                if ((field = fields.get(attr.toLowerCase())) != null && field.getAnnotations().length > 0) {
                    ao.add(field);
                }
                for (Method other : propNames.keySet()) {
                    String oattr;
                    if (m == other || (oattr = propNames.get(other)) == null || !attr.equalsIgnoreCase(oattr) || other.getAnnotations().length <= 0) continue;
                    ao.add(other);
                }
                proxy.accessibleObjects = ao.toArray(new AccessibleObject[ao.size()]);
            }
            for (Method m : propNames.keySet()) {
                String n = propNames.get(m);
                String ln = n.toLowerCase();
                if (as.put(ln, n) == null) {
                    attrs.add(ln);
                }
                if ((ao = (AccessibleObject[])aos.get(ln)) == null) {
                    ao = new AccessibleObject[3];
                    aos.put(ln, (AccessibleObject[])ao);
                }
                if (m.getName().startsWith("set")) {
                    ao[2] = m;
                } else {
                    ao[1] = m;
                }
                Field field = fields.get(ln);
                ao[0] = field;
            }
        }
        Type beanType = Type.getType(this.superclass);
        NamingPolicy np = this.namingPolicy;
        if (np == null) {
            np = NamingPolicy.INSTANCE;
        }
        String cn = np.getClassName(this.superclass.getName(), this.getClass().getName(), key, new Predicate(){

            @Override
            public boolean evaluate(Object arg) {
                try {
                    Enhancer.this.superclass.getClassLoader().loadClass((String)arg);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        final Type goal = Type.getObjectType(cn.replace('.', '/'));
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 4129, goal.getInternalName(), null, beanType.getInternalName(), new String[]{factoryType.getInternalName()});
        cw.visitSource("<generated>", null);
        if (advanced) {
            FieldVisitor fv = cw.visitField(26, "$attrIndex", T_Map.getDescriptor(), null, null);
            fv.visitEnd();
            fv = cw.visitField(26, "$attrs", strArrayType.getDescriptor(), null, null);
            fv.visitEnd();
        }
        int idx = 0;
        for (Method method : proxys) {
            FieldVisitor fv = cw.visitField(26, "$" + ++idx + method.getName(), proxyType.getDescriptor(), null, null);
            fv.visitEnd();
        }
        MethodEmitter e = cw.visitMethodX(false, 8, "<clinit>", "()V", null, null);
        e.start_method();
        int idx2 = 0;
        for (Method m : proxys) {
            MProxy proxy = (MProxy)allProxys.get(m);
            e.new_instance(proxyImplType);
            e.dup();
            e.push(++idx2);
            e.push(m.getDeclaringClass());
            e.push(m.getName());
            Class<?>[] pcs = m.getParameterTypes();
            e.push(pcs.length);
            e.newarray(T_Class);
            e.store_local(classArrayType, 1);
            for (int j = 0; j < pcs.length; ++j) {
                e.load_local(classArrayType, 1);
                e.push(j);
                e.push(Type.getType(pcs[j]));
                e.aastore();
            }
            e.load_local(classArrayType, 1);
            e.invoke_virtual(T_Class, "getDeclaredMethod", Type.getMethodDescriptor(T_Method, T_String, classArrayType));
            e.push(proxy.accessibleObjects.length);
            e.newarray(aoType);
            e.store_local(aoArrayType, 2);
            for (int i = 0; i < proxy.accessibleObjects.length; ++i) {
                AccessibleObject ao = proxy.accessibleObjects[i];
                e.load_local(aoArrayType, 2);
                e.push(i);
                if (ao instanceof Field) {
                    Field aof = (Field)ao;
                    e.push(aof.getDeclaringClass());
                    e.push(aof.getName());
                    e.invoke_virtual(T_Class, "getDeclaredField", Type.getMethodDescriptor(T_Field, T_String));
                } else {
                    Method aom = (Method)ao;
                    e.push(aom.getDeclaringClass());
                    e.push(aom.getName());
                    Class<?>[] pcs2 = aom.getParameterTypes();
                    e.push(pcs2.length);
                    e.newarray(T_Class);
                    e.store_local(classArrayType, 1);
                    for (int j = 0; j < pcs2.length; ++j) {
                        e.load_local(classArrayType, 1);
                        e.push(j);
                        e.push(Type.getType(pcs2[j]));
                        e.aastore();
                    }
                    e.load_local(classArrayType, 1);
                    e.invoke_virtual(T_Class, "getDeclaredMethod", Type.getMethodDescriptor(T_Method, T_String, classArrayType));
                }
                e.aastore();
            }
            e.load_local(aoArrayType, 2);
            e.invoke_constructor(proxyImplType, Type.getMethodDescriptor(T_void, T_int, T_Method, aoArrayType));
            e.putstatic(goal, "$" + idx2 + m.getName(), proxyType);
        }
        if (advanced) {
            void var17_33;
            Type type = Type.getType(LinkedHashMap.class);
            desc = Type.getMethodDescriptor(T_Object, T_Object, T_Object);
            e.new_instance(type);
            e.dup();
            e.invoke_constructor(type);
            e.putstatic(goal, "$attrIndex", T_Map);
            for (int i = 0; i < attrs.size(); ++i) {
                e.getstatic(goal, "$attrIndex", T_Map);
                e.push((String)attrs.get(i));
                e.push(i + 1);
                e.box(T_int);
                e.invoke_interface(T_Map, "put", desc);
                e.pop();
            }
            e.push(attrs.size());
            e.newarray(T_String);
            boolean bl = false;
            while (var17_33 < attrs.size()) {
                e.dup();
                e.push((int)var17_33);
                e.push((String)as.get(attrs.get((int)var17_33)));
                e.aastore();
                ++var17_33;
            }
            e.putstatic(goal, "$attrs", strArrayType);
        }
        e.return_void();
        e.end_method();
        FieldVisitor fv = cw.visitField(18, "$callbacks", callbackArrayType.getDescriptor(), null, null);
        fv.visitEnd();
        MethodEmitter e2 = cw.visitMethodX(false, 1, "<init>", "()V", null, null);
        e2.start_method();
        Label label = e2.mark();
        e2.load_local(goal, 0);
        e2.invoke_constructor(beanType, "()V");
        e2.load_local(goal, 0);
        e2.push(this.callbacks.length);
        e2.newarray(callbackType);
        e2.putfield(goal, "$callbacks", callbackArrayType);
        e2.return_void();
        Label end = e2.mark();
        e2.mark_local("this", goal, label, end, 0);
        e2.end_method();
        e = cw.visitMethodX(false, 145, "newInstance", Type.getMethodDescriptor(T_Object, callbackArrayType), null, null);
        e.start_method();
        Label start2 = e.mark();
        e.new_instance(goal);
        e.dup();
        e.invoke_constructor(goal, "()V");
        e.store_local(goal, 2);
        e.load_local(callbackArrayType, 1);
        e.push(0);
        e.load_local(goal, 2);
        e.getfield(goal, "$callbacks", callbackArrayType);
        e.push(0);
        e.push(this.callbacks.length);
        e.invoke_static(Type.getType(System.class), "arraycopy", Type.getMethodDescriptor(T_void, T_Object, T_int, T_Object, T_int, T_int));
        e.load_local(goal, 2);
        e.return_value(goal);
        Label label2 = e.mark();
        e.mark_local("this", goal, start2, label2, 0);
        e.end_method();
        e = cw.visitMethodX(false, 17, "getCallback", Type.getMethodDescriptor(callbackType, T_int), null, null);
        e.start_method();
        Object start = e.mark();
        e.load_local(goal, 0);
        e.getfield(goal, "$callbacks", callbackArrayType);
        e.load_local(T_int, 1);
        e.aaload();
        e.return_value(callbackType);
        Label label3 = e.mark();
        e.mark_local("this", goal, (Label)start, label3, 0);
        e.end_method();
        e = cw.visitMethodX(false, 17, "setCallback", Type.getMethodDescriptor(T_void, T_int, callbackType), null, null);
        e.start_method();
        start = e.mark();
        e.load_local(goal, 0);
        e.getfield(goal, "$callbacks", callbackArrayType);
        e.load_local(T_int, 1);
        e.load_local(callbackType, 2);
        e.aastore();
        e.return_void();
        Label label4 = e.mark();
        e.mark_local("this", goal, (Label)start, label4, 0);
        e.end_method();
        e = cw.visitMethodX(false, 17, "getCallbacks", Type.getMethodDescriptor(callbackArrayType, new Type[0]), null, null);
        e.start_method();
        start = e.mark();
        e.load_local(goal, 0);
        e.getfield(goal, "$callbacks", callbackArrayType);
        e.return_value(callbackArrayType);
        Label label5 = e.mark();
        e.mark_local("this", goal, (Label)start, label5, 0);
        e.end_method();
        if (advanced) {
            e = cw.visitMethodX(false, 1, "$attrs", Type.getMethodDescriptor(T_List, new Type[0]), null, null);
            e.start_method();
            start = e.mark();
            e.getstatic(goal, "$attrs", strArrayType);
            e.invoke_static(Type.getType(Arrays.class), "asList", Type.getMethodDescriptor(T_List, objectArrayType));
            e.invoke_static(Type.getType(Collections.class), "unmodifiableList", Type.getMethodDescriptor(T_List, T_List));
            e.return_value(T_List);
            Label label6 = e.mark();
            e.mark_local("this", goal, (Label)start, label6, 0);
            e.end_method();
            e = cw.visitMethodX(false, 1, "$type", Type.getMethodDescriptor(T_Class, T_String), null, null);
            e.start_method();
            start = e.mark();
            e.getstatic(goal, "$attrIndex", T_Map);
            e.load_local(T_String, 1);
            e.invoke_virtual(T_String, "toLowerCase", Type.getMethodDescriptor(T_String, new Type[0]));
            e.invoke_interface(T_Map, "get", Type.getMethodDescriptor(T_Object, T_Object));
            e.checkcast(T_Integer);
            e.unbox_or_zero(T_int);
            int[] nArray = new int[attrs.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i + 1;
            }
            e.process_switch(nArray, new Case(){

                @Override
                public void processCase(MethodEmitter ce, int key, Label end) {
                    String attr = (String)attrs.get(key - 1);
                    AccessibleObject[] ao = (AccessibleObject[])aos.get(attr);
                    if (ao[1] != null) {
                        Method m = (Method)ao[1];
                        Class<?> clazz = m.getReturnType();
                        ce.push(clazz);
                    } else if (ao[2] != null) {
                        Method m = (Method)ao[2];
                        Class<?> clazz = m.getParameterTypes()[0];
                        ce.push(clazz);
                    } else if (ao[0] != null) {
                        Field f = (Field)ao[0];
                        Class<?> clazz = f.getType();
                        ce.push(clazz);
                    } else {
                        ce.aconst_null();
                    }
                    ce.return_value(Opcodes.T_Class);
                }

                @Override
                public void processDefault(MethodEmitter ce) {
                    ce.aconst_null();
                    ce.return_value(Opcodes.T_Class);
                }
            }, true);
            end = e.mark();
            e.mark_local("this", goal, (Label)start, end, 0);
            e.end_method();
            e = cw.visitMethodX(false, 1, "$get", Type.getMethodDescriptor(T_Object, T_String), null, null);
            e.start_method();
            start = e.mark();
            e.getstatic(goal, "$attrIndex", T_Map);
            e.load_local(T_String, 1);
            e.invoke_virtual(T_String, "toLowerCase", Type.getMethodDescriptor(T_String, new Type[0]));
            e.invoke_interface(T_Map, "get", Type.getMethodDescriptor(T_Object, T_Object));
            e.checkcast(T_Integer);
            e.unbox_or_zero(T_int);
            int[] nArray2 = new int[attrs.size()];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = i + 1;
            }
            e.process_switch(nArray2, new Case(){

                @Override
                public void processCase(MethodEmitter ce, int key, Label end) {
                    String attr = (String)attrs.get(key - 1);
                    AccessibleObject[] ao = (AccessibleObject[])aos.get(attr);
                    if (ao[1] != null) {
                        Method m = (Method)ao[1];
                        ce.load_this();
                        ce.super_invoke(Type.getType(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                        Type rt = Type.getType(m.getReturnType());
                        if (rt.isPrimitive()) {
                            ce.box(rt);
                        }
                    } else if (ReflectUtil.canAccess(Enhancer.this.superclass, ao[0])) {
                        Field f = (Field)ao[0];
                        f.setAccessible(true);
                        Type ft = Type.getType(f.getType());
                        ce.load_this();
                        ce.getfield(Type.getType(f.getDeclaringClass()), f.getName(), ft);
                        if (ft.isPrimitive()) {
                            ce.box(ft);
                        }
                    } else {
                        ce.aconst_null();
                    }
                    ce.return_value(Opcodes.T_Object);
                }

                @Override
                public void processDefault(MethodEmitter ce) {
                    ce.aconst_null();
                    ce.return_value(Opcodes.T_Object);
                }
            }, true);
            end = e.mark();
            e.mark_local("this", goal, (Label)start, end, 0);
            e.end_method();
            e = cw.visitMethodX(false, 1, "$set", Type.getMethodDescriptor(T_void, T_String, T_Object), null, null);
            e.start_method();
            start = e.mark();
            e.getstatic(goal, "$attrIndex", T_Map);
            e.load_local(T_String, 1);
            e.invoke_virtual(T_String, "toLowerCase", Type.getMethodDescriptor(T_String, new Type[0]));
            e.invoke_interface(T_Map, "get", Type.getMethodDescriptor(T_Object, T_Object));
            e.checkcast(T_Integer);
            e.unbox_or_zero(T_int);
            int[] nArray3 = new int[attrs.size()];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = i + 1;
            }
            e.process_switch(nArray3, new Case(){

                @Override
                public void processCase(MethodEmitter ce, int key, Label end) {
                    String attr = (String)attrs.get(key - 1);
                    AccessibleObject[] ao = (AccessibleObject[])aos.get(attr);
                    if (ao[2] != null) {
                        Method m = (Method)ao[2];
                        ce.load_this();
                        ce.load_local(Opcodes.T_Object, 2);
                        Type pt = Type.getType(m.getParameterTypes()[0]);
                        if (pt.isPrimitive()) {
                            ce.checkcast(pt.toReferenceType());
                            ce.unbox_or_zero(pt);
                        } else {
                            ce.checkcast(pt);
                        }
                        ce.super_invoke(Type.getType(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                    } else if (ReflectUtil.canAccess(Enhancer.this.superclass, ao[0])) {
                        Field f = (Field)ao[0];
                        Type ft = Type.getType(f.getType());
                        ce.load_this();
                        ce.load_local(Opcodes.T_Object, 2);
                        if (ft.isPrimitive()) {
                            ce.checkcast(ft.toReferenceType());
                            ce.unbox_or_zero(ft);
                        } else {
                            ce.checkcast(ft);
                        }
                        ce.putfield(Type.getType(f.getDeclaringClass()), f.getName(), ft);
                    }
                    ce.return_void();
                }

                @Override
                public void processDefault(MethodEmitter ce) {
                    ce.return_void();
                }
            }, true);
            end = e.mark();
            e.mark_local("this", goal, (Label)start, end, 0);
            e.end_method();
            e = cw.visitMethodX(false, 1, "$annotation", Type.getMethodDescriptor(T_Annotation, T_String, T_Class), "<T::Ljava/lang/annotation/Annotation;>(Ljava/lang/String;Ljava/lang/Class<TT;>;)TT;", null);
            e.start_method();
            start = e.mark();
            e.getstatic(goal, "$attrIndex", T_Map);
            e.load_local(T_String, 1);
            e.invoke_virtual(T_String, "toLowerCase", Type.getMethodDescriptor(T_String, new Type[0]));
            e.invoke_interface(T_Map, "get", Type.getMethodDescriptor(T_Object, T_Object));
            e.checkcast(T_Integer);
            e.unbox_or_zero(T_int);
            int[] nArray4 = new int[attrs.size()];
            for (int i = 0; i < nArray4.length; ++i) {
                nArray4[i] = i + 1;
            }
            e.process_switch(nArray4, new Case(){

                @Override
                public void processCase(MethodEmitter ce, int key, Label end) {
                    AccessibleObject[] ao;
                    String attr = (String)attrs.get(key - 1);
                    for (AccessibleObject a : ao = (AccessibleObject[])aos.get(attr)) {
                        if (a == null || a.getAnnotations().length <= 0) continue;
                        if (a instanceof Field) {
                            Field f = (Field)a;
                            ce.push(f.getDeclaringClass());
                            ce.push(f.getName());
                            ce.invoke_virtual(Opcodes.T_Class, "getDeclaredField", Type.getMethodDescriptor(Opcodes.T_Field, Opcodes.T_String));
                            ce.load_local(Opcodes.T_Class, 2);
                            ce.invoke_virtual(Opcodes.T_Field, "getAnnotation", Type.getMethodDescriptor(Opcodes.T_Annotation, Opcodes.T_Class));
                            ce.store_local(Opcodes.T_Annotation, 3);
                            ce.load_local(Opcodes.T_Annotation, 3);
                            Label nullAnnotation = ce.make_label();
                            ce.ifnull(nullAnnotation);
                            ce.load_local(Opcodes.T_Annotation, 3);
                            ce.return_value(Opcodes.T_Annotation);
                            ce.mark(nullAnnotation);
                            continue;
                        }
                        Method m = (Method)a;
                        ce.push(m.getDeclaringClass());
                        ce.push(m.getName());
                        Class<?>[] pcs = m.getParameterTypes();
                        ce.push(pcs.length);
                        ce.newarray(Opcodes.T_Class);
                        ce.store_local(classArrayType, 4);
                        for (int j = 0; j < pcs.length; ++j) {
                            ce.load_local(classArrayType, 4);
                            ce.push(j);
                            ce.push(Type.getType(pcs[j]));
                            ce.aastore();
                        }
                        ce.load_local(classArrayType, 4);
                        ce.invoke_virtual(Opcodes.T_Class, "getDeclaredMethod", Type.getMethodDescriptor(Opcodes.T_Method, Opcodes.T_String, classArrayType));
                        ce.load_local(Opcodes.T_Class, 2);
                        ce.invoke_virtual(Opcodes.T_Method, "getAnnotation", Type.getMethodDescriptor(Opcodes.T_Annotation, Opcodes.T_Class));
                        ce.store_local(Opcodes.T_Annotation, 3);
                        ce.load_local(Opcodes.T_Annotation, 3);
                        Label nullAnnotation = ce.make_label();
                        ce.ifnull(nullAnnotation);
                        ce.load_local(Opcodes.T_Annotation, 3);
                        ce.return_value(Opcodes.T_Annotation);
                        ce.mark(nullAnnotation);
                    }
                    ce.aconst_null();
                    ce.return_value(Opcodes.T_Annotation);
                }

                @Override
                public void processDefault(MethodEmitter ce) {
                    ce.aconst_null();
                    ce.return_value(Opcodes.T_Annotation);
                }
            }, true);
            end = e.mark();
            e.mark_local("this", goal, (Label)start, end, 0);
            e.end_method();
        } else {
            e = cw.visitMethodX(false, 1, "$attrs", Type.getMethodDescriptor(T_List, new Type[0]), null, null);
            e.start_method();
            start = e.mark();
            e.invoke_static(Type.getType(Collections.class), "emptyList", Type.getMethodDescriptor(T_List, new Type[0]));
            e.return_value(T_List);
            Label label7 = e.mark();
            e.mark_local("this", goal, (Label)start, label7, 0);
            e.end_method();
            e = cw.visitMethodX(false, 1, "$type", Type.getMethodDescriptor(T_Class, T_String), null, null);
            e.start_method();
            start = e.mark();
            e.aconst_null();
            e.return_value(T_Class);
            Label label8 = e.mark();
            e.mark_local("this", goal, (Label)start, label8, 0);
            e.end_method();
            e = cw.visitMethodX(false, 1, "$get", Type.getMethodDescriptor(T_Object, T_String), null, null);
            e.start_method();
            start = e.mark();
            e.aconst_null();
            e.return_value(T_Object);
            Label label9 = e.mark();
            e.mark_local("this", goal, (Label)start, label9, 0);
            e.end_method();
            e = cw.visitMethodX(false, 1, "$set", Type.getMethodDescriptor(T_void, T_String, T_Object), null, null);
            e.start_method();
            start = e.mark();
            e.return_void();
            Label label10 = e.mark();
            e.mark_local("this", goal, (Label)start, label10, 0);
            e.end_method();
            e = cw.visitMethodX(false, 1, "$annotation", Type.getMethodDescriptor(T_Annotation, T_String, T_Class), "<T::Ljava/lang/annotation/Annotation;>(Ljava/lang/String;Ljava/lang/Class<TT;>;)TT;", null);
            e.start_method();
            start = e.mark();
            e.aconst_null();
            e.return_value(T_Annotation);
            Label label11 = e.mark();
            e.mark_local("this", goal, (Label)start, label11, 0);
            e.end_method();
        }
        idx = 0;
        for (Method method : proxys) {
            ++idx;
            desc = Type.getMethodDescriptor(method);
            MethodEmitter e3 = cw.visitMethodX(false, 1, method.getName(), desc, null, null);
            e3.start_method();
            Label start3 = e3.mark();
            Label nullInterceptor = e3.make_label();
            e3.load_local(goal, 0);
            e3.getfield(goal, "$callbacks", callbackArrayType);
            e3.dup();
            e3.ifnull(nullInterceptor);
            int callbackIdx = methods.get(method);
            e3.push(callbackIdx);
            e3.aaload();
            e3.dup();
            e3.ifnull(nullInterceptor);
            e3.getstatic(goal, "$" + idx + method.getName(), proxyType);
            e3.load_local(goal, 0);
            e3.push(method.getParameterTypes().length);
            e3.newarray(T_Object);
            int aIdx = 0;
            int varIdx = 1;
            Class<?>[] classArray = method.getParameterTypes();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> pc = classArray[i];
                e3.dup();
                e3.push(aIdx++);
                Type tc = Type.getType(pc);
                e3.load_local(tc, varIdx);
                varIdx += tc.getSize();
                e3.box(tc);
                e3.aastore();
            }
            e3.invoke_interface(callbackType, "intercept", Type.getMethodDescriptor(T_Object, proxyType, T_Object, objectArrayType));
            Type rt = Type.getType(method.getReturnType());
            if (rt.isVoid()) {
                e3.pop();
            } else if (rt.isPrimitive()) {
                e3.checkcast(rt.toReferenceType());
                e3.unbox_or_zero(rt);
            } else {
                e3.checkcast(rt);
            }
            e3.return_value(rt);
            e3.mark(nullInterceptor);
            e3.pop();
            e3.load_local(goal, 0);
            int varIdx2 = 1;
            for (Class<?> pc : method.getParameterTypes()) {
                Type tc = Type.getType(pc);
                e3.load_local(tc, varIdx2);
                varIdx2 += tc.getSize();
            }
            e3.super_invoke(Type.getType(method.getDeclaringClass()), method.getName(), desc);
            e3.return_value(Type.getType(method.getReturnType()));
            Label end3 = e3.mark();
            e3.mark_local("this", goal, start3, end3, 0);
            e3.end_method();
        }
        e = cw.visitMethodX(false, 1, "$invoke", Type.getMethodDescriptor(T_Object, T_int, T_Object.getArrayType(1)), null, null);
        e.start_method();
        start = e.mark();
        int[] nArray = new int[proxys.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + 1;
        }
        e.load_local(T_int, 1);
        e.process_switch(nArray, new Case(){

            @Override
            public void processCase(MethodEmitter ce, int key, Label end) {
                Method m = (Method)proxys.get(key - 1);
                ce.load_local(goal, 0);
                Class<?>[] pcs = m.getParameterTypes();
                for (int j = 0; j < pcs.length; ++j) {
                    ce.load_local(objectArrayType, 2);
                    ce.aaload(j);
                    Type pt = Type.getType(pcs[j]);
                    if (pt.isPrimitive()) {
                        ce.checkcast(pt.toReferenceType());
                        ce.unbox_or_zero(pt);
                        continue;
                    }
                    ce.checkcast(pt);
                }
                ce.super_invoke(Type.getType(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                Type rt = Type.getType(m.getReturnType());
                if (rt.isVoid()) {
                    ce.aconst_null();
                } else if (rt.isPrimitive()) {
                    ce.box(rt);
                }
                ce.return_value(Opcodes.T_Object);
            }

            @Override
            public void processDefault(MethodEmitter ce) {
                ce.aconst_null();
                ce.return_value(Opcodes.T_Object);
            }
        }, true);
        end = e.mark();
        e.mark_local("this", goal, (Label)start, end, 0);
        e.end_method();
        cw.visitEnd();
        byte[] bs = cw.toByteArray();
        Class<?> clazz = ReflectUtil.defineClass(cn, bs, this.superclass.getClassLoader());
        return clazz;
    }
}

