/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.client;

import com.ibatis.common.RunStats;
import com.ibatis.common.Statsable;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.client.BatchResult;
import com.ibatis.sqlmap.client.event.PageHandler;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.cache.CacheRoot;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.execution.Batch;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.DefaultSqlExecutor;
import com.ibatis.sqlmap.engine.execution.ExecuteNotifier;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.ibatis.client.Cache;

public class SqlExecutor
implements com.ibatis.sqlmap.engine.execution.SqlExecutor,
Statsable {
    private static final ILog log = ILogFactory.getLog(SqlExecutor.class);
    final DefaultSqlExecutor delegate;
    SqlMapConfiguration config;
    long threshold = 1000L;
    long page_threshold = 60000L;
    boolean traceSql = false;
    boolean debugSql = false;
    boolean statsSql = false;
    boolean checkSql = false;
    Map<String, SqlStat> sqlStats = new ConcurrentHashMap<String, SqlStat>();

    public SqlExecutor() {
        this.delegate = new DefaultSqlExecutor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        long t = System.currentTimeMillis();
        int rows = 0;
        try {
            rows = this.delegate.executeUpdate(id, statementScope, conn, sql, parameters);
        }
        finally {
            t = System.currentTimeMillis() - t;
            this.statsSql(id, sql, t);
            this.logSql("executeUpdate", statementScope.getErrorContext(), t, 0, -1, rows);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeInsert(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters, ResultMap keyResultMap) throws SQLException {
        long t = System.currentTimeMillis();
        T r = null;
        try {
            T t2 = r = (T)this.delegate.executeInsert(id, statementScope, conn, sql, parameters, keyResultMap);
            return t2;
        }
        finally {
            t = System.currentTimeMillis() - t;
            this.statsSql(id, sql, t);
            this.logInsert("executeInsert", statementScope.getErrorContext(), t, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addBatch(StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        long t = System.currentTimeMillis();
        try {
            int n = this.delegate.doAddBatch(true, statementScope, conn, sql, parameters);
            return n;
        }
        finally {
            Batch batch = statementScope.getSession().getBatch();
            if (batch != null && batch.isCleanup()) {
                t = System.currentTimeMillis() - t;
                Map<ExecuteNotifier, String> idSqls = batch.popBatchedMap();
                if (idSqls != null) {
                    if (this.statsSql) {
                        for (ExecuteNotifier en : idSqls.keySet()) {
                            this.statsSql("~" + en.getId(), idSqls.get(en), t / (long)idSqls.size());
                        }
                    }
                    idSqls.clear();
                }
                this.logBatch("addBatch", batch.toString(), batch.popErrorContexts(), t, batch.getTotalRows());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeBatch(SessionScope sessionScope) throws SQLException {
        long t = System.currentTimeMillis();
        Batch batch = sessionScope.getBatch();
        try {
            int n = this.delegate.executeBatch(sessionScope);
            return n;
        }
        finally {
            if (batch != null) {
                t = System.currentTimeMillis() - t;
                Map<ExecuteNotifier, String> idSqls = batch.popBatchedMap();
                if (idSqls != null) {
                    if (this.statsSql) {
                        for (ExecuteNotifier en : idSqls.keySet()) {
                            this.statsSql("~" + en.getId(), idSqls.get(en), t / (long)idSqls.size());
                        }
                    }
                    idSqls.clear();
                }
                this.logBatch("executeBatch", batch.toString(), batch.popErrorContexts(), t, batch.getTotalRows());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchResult> executeBatchDetailed(SessionScope sessionScope) throws SQLException, BatchException {
        long t = System.currentTimeMillis();
        Batch batch = sessionScope.getBatch();
        try {
            List<BatchResult> list = this.delegate.executeBatchDetailed(sessionScope);
            return list;
        }
        finally {
            if (batch != null) {
                t = System.currentTimeMillis() - t;
                Map<ExecuteNotifier, String> idSqls = batch.popBatchedMap();
                if (idSqls != null) {
                    if (this.statsSql) {
                        for (ExecuteNotifier en : idSqls.keySet()) {
                            this.statsSql("~" + en.getId(), idSqls.get(en), t / (long)idSqls.size());
                        }
                    }
                    idSqls.clear();
                }
                this.logBatch("executeBatchDetailed", batch.toString(), batch.popErrorContexts(), t, batch.getTotalRows());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters, int skip, int max, RowHandlerCallback callback) throws SQLException {
        long t = System.currentTimeMillis();
        Integer rows = null;
        try {
            this.delegate.executeQuery(id, statementScope, conn, sql, parameters, skip, max, callback);
            rows = callback.getRowHandler().getRows();
        }
        finally {
            t = System.currentTimeMillis() - t;
            this.statsSql(id, sql, t);
            this.logSql("executeQuery", statementScope.getErrorContext(), t, skip, max, rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQueryPage(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters, int skip, int max, RowHandlerCallback callback, PageHandler pageHandler) throws SQLException {
        long t = System.currentTimeMillis();
        Integer rows = null;
        try {
            this.delegate.executeQueryPage(id, statementScope, conn, sql, parameters, skip, max, callback, pageHandler);
            rows = callback.getRowHandler().getRows();
        }
        finally {
            t = System.currentTimeMillis() - t;
            this.statsSql(id, sql, t);
            this.logSql("executeQueryPage", statementScope.getErrorContext(), t, skip, max, rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdateProcedure(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters) throws SQLException {
        long t = System.currentTimeMillis();
        int r = 0;
        try {
            int n = r = this.delegate.executeUpdateProcedure(id, statementScope, conn, sql, parameters);
            return n;
        }
        finally {
            t = System.currentTimeMillis() - t;
            this.statsSql(id, sql, t);
            this.logSql("executeUpdateProcedure", statementScope.getErrorContext(), t, 0, -1, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQueryProcedure(String id, StatementScope statementScope, Connection conn, String sql, Object[] parameters, int skip, int max, RowHandlerCallback callback) throws SQLException {
        long t = System.currentTimeMillis();
        Integer rows = null;
        try {
            this.delegate.executeQueryProcedure(id, statementScope, conn, sql, parameters, skip, max, callback);
            rows = callback.getRowHandler().getRows();
        }
        finally {
            t = System.currentTimeMillis() - t;
            this.statsSql(id, sql, t);
            this.logSql("executeQueryProcedure", statementScope.getErrorContext(), t, skip, max, rows);
        }
    }

    void statsSql(String id, String sql, long t) {
        if (this.statsSql) {
            SqlStat s;
            String key = id;
            if (key == null) {
                key = sql;
            }
            if ((s = this.sqlStats.get(key)) == null) {
                s = new SqlStat(key, sql, t);
                this.sqlStats.put(key, s);
            } else {
                s.addCount(t);
            }
        }
    }

    @Override
    public void cleanup(SessionScope sessionScope) {
        Map<ExecuteNotifier, String> idSqls;
        Batch batch = sessionScope.getBatch();
        this.delegate.cleanup(sessionScope);
        if (batch != null && (idSqls = batch.popBatchedMap()) != null) {
            idSqls.clear();
        }
    }

    void logBatch(String methodName, String batchInfo, List<ErrorContext> list, long t, int rows) {
        if (t > this.threshold) {
            ErrorContext ec = new ErrorContext();
            ec.setBatchInfo(batchInfo);
            ec.setDebugInfo("Batch execution time = " + t + " > " + this.threshold);
            log.warn(methodName + "() total rows = " + rows + ec.toStr(list));
        } else if (this.debugSql) {
            ErrorContext ec = new ErrorContext();
            ec.setBatchInfo(batchInfo);
            log.info(methodName + "() total rows = " + rows + ", time = " + t + ec.toStr(list));
        }
    }

    void logSql(String methodName, ErrorContext ec, long t, int skip, int limit, Integer ret) {
        String skipTotal = "";
        if (limit > 0 && ec.getTotal() > 0) {
            skipTotal = ", skip = " + skip + ", total = " + ec.getTotal();
        }
        if (t > this.threshold) {
            ec.setDebugInfo("Execution time = " + t + " > " + this.threshold);
            log.warn(methodName + "() rows = " + ret + skipTotal + ec.toStr());
        } else if (limit > 0 && (long)ec.getTotal() > this.page_threshold) {
            ec.setDebugInfo("Result set total rows " + ec.getTotal() + " > " + this.page_threshold);
            log.warn(methodName + "() rows = " + ret + skipTotal + ", time = " + t + ec.toStr());
        } else if (this.debugSql) {
            log.info(methodName + "() rows = " + ret + skipTotal + ", time = " + t + ec.toStr());
        }
    }

    void logInsert(String methodName, ErrorContext ec, long t, Object ret) {
        if (t > this.threshold) {
            ec.setDebugInfo("Execution time = " + t + " > " + this.threshold);
            log.warn(methodName + "() genKey = " + ret + ec.toStr());
        } else if (this.debugSql) {
            log.info(methodName + "() genKey = " + ret + ", time = " + t + ec.toStr());
        }
    }

    @Override
    public void init(SqlMapConfiguration config, Properties globalProps) {
        long t;
        String str2;
        this.config = config;
        this.delegate.init(config, globalProps);
        try {
            str2 = globalProps.getProperty("sql_executor_threshold", "1000");
            t = Long.parseLong(str2);
            if (t > 0L) {
                this.threshold = t;
            }
        }
        catch (Exception str2) {
            // empty catch block
        }
        try {
            str2 = globalProps.getProperty("sql_executor_page_threshold", "60000");
            t = Long.parseLong(str2);
            if (t > 0L) {
                this.page_threshold = t;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.debugSql = this.traceSql = "true".equals(globalProps.getProperty("sql_executor_trace_sql"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.debugSql = "true".equals(globalProps.getProperty("sql_executor_debug_sql"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.statsSql = !"false".equals(globalProps.getProperty("sql_executor_stats_sql"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.checkSql = "true".equals(globalProps.getProperty("sql_executor_check_sql"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("SqlExecutor " + this.hashCode() + " init() called, threshold=" + this.threshold + ", debug_sql=" + this.debugSql + ", paging_threshold=" + this.page_threshold + ", stats_sql=" + this.statsSql + ", check_sql=" + this.checkSql);
        RunStats.getInstance().addStat(this);
    }

    @Override
    public boolean isTraceSql() {
        return this.traceSql;
    }

    @Override
    public boolean isCheckSql() {
        return this.checkSql;
    }

    @Override
    public boolean isDebugSql() {
        return this.debugSql;
    }

    @Override
    public String getStatus(String h) {
        StringBuilder buf = new StringBuilder("SqlExecutor " + this.hashCode() + " :");
        h = h == null ? "\n" : "\n" + h;
        String f = " ----------------------- %12s:  %-4d -------------------------------------";
        ArrayList<SqlStat> list = new ArrayList<SqlStat>();
        for (SqlStat ss : this.sqlStats.values()) {
            if (ss.count <= 0L) continue;
            list.add(ss);
        }
        Collections.sort(list);
        if (list.size() > 0) {
            buf.append(h).append(String.format(f, "sql stats", list.size()));
            String th = " %9s %9s  %s";
            buf.append(h).append(String.format(th, "count", "avg.time", "id/sql"));
            String tr = " %9d %9d  %s";
            for (SqlStat ss : list) {
                buf.append(h);
                int timeAvg = (int)((double)ss.time / (double)ss.count);
                buf.append(String.format(tr, ss.count, timeAvg, ss.id != null ? ss.id : ss.sql));
            }
        }
        Cache[] caches = this.config.getDelegate().getCacheModels();
        Arrays.sort(caches, new Comparator<Cache>(){

            @Override
            public int compare(Cache o1, Cache o2) {
                if (o2.getRequests() == o1.getRequests()) {
                    return (int)(o2.getHits() - o2.getHits());
                }
                return (int)(o2.getRequests() - o1.getRequests());
            }
        });
        if (caches.length > 0 && caches[0].getRequests() > 0L) {
            buf.append(h).append(String.format(f, "cache stats", caches.length));
            String th = " %9s %9s %9s %9s %9s  %s";
            buf.append(h).append(String.format(th, "requests", "hits", "flushs", "age", "age.max", "id"));
            String tr = " %9d %9d %9d %9d %9d  %s";
            for (Cache c : caches) {
                long max = 0L;
                if (c instanceof CacheModel) {
                    max = ((CacheModel)c).getFlushIntervalSeconds();
                }
                buf.append(h);
                buf.append(String.format(tr, c.getRequests(), c.getHits(), c.getFlushs(), c.getPeriodMillis() / 1000L, max, c.getId()));
            }
        }
        CacheRoot[] cacheRoots = this.config.getDelegate().getCacheRoots().getRoots();
        Arrays.sort(cacheRoots, new Comparator<CacheRoot>(){

            @Override
            public int compare(CacheRoot o1, CacheRoot o2) {
                if (o1.isReal() != o2.isReal()) {
                    if (o1.isReal()) {
                        return -1;
                    }
                    return 1;
                }
                if (o2.getFlushCount() == o1.getFlushCount()) {
                    return (int)(o2.getLastFlush() - o2.getLastFlush());
                }
                return (int)(o2.getFlushCount() - o1.getFlushCount());
            }
        });
        if (cacheRoots.length > 0 && cacheRoots[0].getLastFlush() > 0L) {
            long t = System.currentTimeMillis();
            buf.append(h).append(String.format(f, "roots stats", cacheRoots.length));
            String th = " %9s %9s  %s";
            buf.append(h).append(String.format(th, "flushs", "age", "id"));
            String tr = " %9d %9d  %s";
            for (CacheRoot c : cacheRoots) {
                if (c.getFlushCount() <= 0L) continue;
                String r = c.isReal() ? "" : "~";
                buf.append(h);
                buf.append(String.format(tr, c.getFlushCount(), (t - c.getLastFlush()) / 1000L, r + c.getId()));
            }
        }
        buf.append(h).append(" ---------------------------------------------------------------------------------");
        return buf.toString();
    }

    public static class SqlStat
    implements Comparable<SqlStat> {
        String id;
        String sql;
        long count;
        long time;

        public SqlStat(String id, String sql, long t) {
            this.id = id;
            this.sql = sql;
            this.time = t;
            this.count = 1L;
        }

        public void addCount(long t) {
            ++this.count;
            this.time += t;
        }

        public String toString() {
            return this.count + ", " + this.time + " -> " + this.sql;
        }

        @Override
        public int compareTo(SqlStat o) {
            if (o == null) {
                return -1;
            }
            if (o.count == this.count) {
                return (int)(o.time - this.time);
            }
            return (int)(o.count - this.count);
        }
    }
}

