/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.jgroups.ehcache;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ibatis.jgroups.ehcache.BootstrapRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BootstrapRequestMap {
    private static final Logger LOG = LoggerFactory.getLogger((String)BootstrapRequestMap.class.getName());
    private final ConcurrentMap<String, Reference<BootstrapRequest>> bootstrapRequests = new ConcurrentHashMap<String, Reference<BootstrapRequest>>();
    private final Object requestChangeNotifier = new Object();

    BootstrapRequestMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForMapSize(int size, long duration) {
        long waitTime = Math.min(duration, 1000L);
        long start = System.currentTimeMillis();
        this.cleanBootstrapRequests();
        while (this.bootstrapRequests.size() != size && System.currentTimeMillis() - start < duration) {
            try {
                Object object = this.requestChangeNotifier;
                synchronized (object) {
                    this.requestChangeNotifier.wait(waitTime);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for BootstrapRequestMap to empty", (Throwable)e);
            }
            this.cleanBootstrapRequests();
        }
        return this.bootstrapRequests.size() == size;
    }

    public Set<String> keySet() {
        this.cleanBootstrapRequests();
        return Collections.unmodifiableSet(this.bootstrapRequests.keySet());
    }

    public boolean isEmpty() {
        this.cleanBootstrapRequests();
        return this.bootstrapRequests.isEmpty();
    }

    public int size() {
        this.cleanBootstrapRequests();
        return this.bootstrapRequests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootstrapRequest put(String cacheName, BootstrapRequest bootstrapRequest) {
        Reference oldReference = this.bootstrapRequests.put(cacheName, new WeakReference<BootstrapRequest>(bootstrapRequest));
        Object object = this.requestChangeNotifier;
        synchronized (object) {
            this.requestChangeNotifier.notifyAll();
        }
        if (oldReference != null) {
            return (BootstrapRequest)oldReference.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootstrapRequest get(String cacheName) {
        Reference reference = (Reference)this.bootstrapRequests.get(cacheName);
        if (reference == null) {
            return null;
        }
        BootstrapRequest bootstrapRequest = (BootstrapRequest)reference.get();
        if (bootstrapRequest == null) {
            LOG.info("BootstrapRequest for {} has been GCed, removing from requests map.", (Object)cacheName);
            if (this.bootstrapRequests.remove(cacheName, reference)) {
                Object object = this.requestChangeNotifier;
                synchronized (object) {
                    this.requestChangeNotifier.notifyAll();
                }
            }
            return null;
        }
        return bootstrapRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootstrapRequest remove(String cacheName) {
        Reference reference = (Reference)this.bootstrapRequests.remove(cacheName);
        if (reference == null) {
            return null;
        }
        Object object = this.requestChangeNotifier;
        synchronized (object) {
            this.requestChangeNotifier.notifyAll();
        }
        return (BootstrapRequest)reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanBootstrapRequests() {
        Iterator bootstrapRequestItr = this.bootstrapRequests.entrySet().iterator();
        while (bootstrapRequestItr.hasNext()) {
            Map.Entry bootstrapRequestEntry = bootstrapRequestItr.next();
            if (((Reference)bootstrapRequestEntry.getValue()).get() != null) continue;
            LOG.info("BootstrapRequest for {} has been GCed, removing from requests map.", bootstrapRequestEntry.getKey());
            bootstrapRequestItr.remove();
            Object object = this.requestChangeNotifier;
            synchronized (object) {
                this.requestChangeNotifier.notifyAll();
            }
        }
    }
}

