/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.jgroups.ehcache;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.util.ClassLoaderUtil;
import net.sf.ehcache.util.PropertyUtil;
import org.ibatis.jgroups.ehcache.JGroupsCacheManagerPeerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsCacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)JGroupsCacheManagerPeerProviderFactory.class.getName());
    private static final String CHANNEL_NAME = "channelName";
    private static final String CONNECT = "connect";
    private static final String FILE = "file";

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        JGroupsCacheManagerPeerProvider peerProvider;
        LOG.trace("Creating JGroups CacheManagerPeerProvider for {} with properties:\n{}", (Object)cacheManager.getName(), (Object)properties);
        String connect = this.getProperty(CONNECT, properties);
        String file = this.getProperty(FILE, properties);
        String channelName = this.getProperty(CHANNEL_NAME, properties);
        if (file != null) {
            if (connect != null) {
                LOG.warn("Both 'connect' and 'file' properties set. 'connect' will be ignored");
            }
            ClassLoader contextClassLoader = ClassLoaderUtil.getStandardClassLoader();
            URL configUrl = contextClassLoader.getResource(file);
            LOG.debug("Creating JGroups CacheManagerPeerProvider for {} with configuration file: {}", (Object)cacheManager.getName(), (Object)configUrl);
            peerProvider = new JGroupsCacheManagerPeerProvider(cacheManager, configUrl);
        } else {
            LOG.debug("Creating JGroups CacheManagerPeerProvider for {} with configuration:\n{}", (Object)cacheManager.getName(), (Object)connect);
            peerProvider = new JGroupsCacheManagerPeerProvider(cacheManager, connect);
        }
        peerProvider.setChannelName(channelName);
        return peerProvider;
    }

    private String getProperty(String name, Properties properties) {
        String property = PropertyUtil.extractAndLogProperty((String)name, (Properties)properties);
        if (property != null) {
            property = property.trim();
            if ((property = property.replaceAll(" ", "")).equals("")) {
                property = null;
            }
        }
        return property;
    }
}

