/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.jgroups.oscache;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.FinalizationException;
import com.opensymphony.oscache.base.InitializationException;
import com.opensymphony.oscache.plugins.clustersupport.AbstractBroadcastingListener;
import com.opensymphony.oscache.plugins.clustersupport.ClusterNotification;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.ibatis.jgroups.oscache.NotificationBus;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGroupsBroadcastingListener
extends AbstractBroadcastingListener
implements NotificationBus.Consumer {
    private static final Logger log = LoggerFactory.getLogger(JavaGroupsBroadcastingListener.class);
    private static final String BUS_NAME = "OSCacheBus";
    private static final String CHANNEL_PROPERTIES = "cache.cluster.properties";
    private static final String MULTICAST_IP_PROPERTY = "cache.cluster.multicast.ip";
    private static final String DEFAULT_CHANNEL_PROPERTIES_PRE = "UDP(mcast_addr=";
    private static final String DEFAULT_CHANNEL_PROPERTIES_POST = ";mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;max_xmit_size=8192):UNICAST(timeout=300,600,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
    private static final String DEFAULT_MULTICAST_IP = "231.12.21.132";
    private NotificationBus bus;

    public synchronized void initialize(Cache cache, Config config) throws InitializationException {
        super.initialize(cache, config);
        String properties = config.getProperty(CHANNEL_PROPERTIES);
        String multicastIP = config.getProperty(MULTICAST_IP_PROPERTY);
        if (properties == null && multicastIP == null) {
            multicastIP = DEFAULT_MULTICAST_IP;
        }
        properties = properties == null ? DEFAULT_CHANNEL_PROPERTIES_PRE + multicastIP.trim() + DEFAULT_CHANNEL_PROPERTIES_POST : properties.trim();
        if (log.isInfoEnabled()) {
            log.info("Starting a new JavaGroups broadcasting listener with properties=" + properties);
        }
        try {
            JChannel ch = new JChannel(properties);
            this.setDiscardOwnMessages(ch);
            this.bus = new NotificationBus((Channel)ch, BUS_NAME);
            this.bus.start();
            this.bus.setConsumer(this);
            log.info("JavaGroups clustering support started successfully");
        }
        catch (Exception e) {
            throw new InitializationException("Initialization failed: " + e);
        }
    }

    void setDiscardOwnMessages(JChannel ch) {
        Method m = null;
        try {
            m = ch.getClass().getMethod("setDiscardOwnMessages", Boolean.TYPE);
            m.invoke((Object)ch, false);
            return;
        }
        catch (Exception exception) {
            try {
                m = ch.getClass().getMethod("setOpt", Integer.TYPE, Object.class);
                m.invoke((Object)ch, 3, Boolean.FALSE);
                return;
            }
            catch (Exception exception2) {
                log.warn("JavaGroups channel setDiscardOwnMessages() failed.");
                return;
            }
        }
    }

    public synchronized void finialize() throws FinalizationException {
        if (log.isInfoEnabled()) {
            log.info("JavaGroups shutting down...");
        }
        if (this.bus != null) {
            this.bus.stop();
            this.bus = null;
        } else {
            log.warn("Notification bus wasn't initialized or finialize was invoked before!");
        }
        if (log.isInfoEnabled()) {
            log.info("JavaGroups shutdown complete.");
        }
    }

    protected void sendNotification(ClusterNotification message) {
        this.bus.sendNotification((Serializable)message);
    }

    @Override
    public void handleNotification(Serializable serializable) {
        if (!(serializable instanceof ClusterNotification)) {
            log.error("An unknown cluster notification message received (class=" + serializable.getClass().getName() + "). Notification ignored.");
            return;
        }
        this.handleClusterNotification((ClusterNotification)serializable);
    }

    @Override
    public Serializable getCache() {
        return this.getClass().getSimpleName() + ": " + this.bus.getLocalAddress();
    }

    @Override
    public void memberJoined(Address address) {
        if (log.isDebugEnabled()) {
            log.debug("A new member at address '" + address + "' has joined the cluster");
        }
    }

    @Override
    public void memberLeft(Address address) {
        if (log.isDebugEnabled()) {
            log.debug("Member at address '" + address + "' left the cluster");
        }
    }
}

