/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.jgroups.oscache;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.ibatis.cglib.FastMethod;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class NotificationBus
implements Receiver {
    final List<Address> members = new Vector<Address>();
    Channel channel = null;
    Address local_addr = null;
    Consumer consumer = null;
    String bus_name = "notification_bus";
    int inst = this.hashCode();
    final Promise<Serializable> get_cache_promise = new Promise();
    final Object cache_mutex = new Object();
    protected final Log log = LogFactory.getLog(this.getClass());
    String props = null;
    FastMethod getMembers = null;

    public NotificationBus(Channel channel, String bus_name) throws Exception {
        if (bus_name != null) {
            this.bus_name = bus_name;
        }
        this.inst = System.identityHashCode(channel) + System.identityHashCode(this.bus_name);
        this.channel = channel;
        channel.setReceiver((Receiver)this);
    }

    public void setConsumer(Consumer c) {
        this.consumer = c;
    }

    public Address getLocalAddress() {
        if (this.local_addr != null) {
            return this.local_addr;
        }
        if (this.channel != null) {
            this.local_addr = this.channel.getAddress();
        }
        return this.local_addr;
    }

    public List<Address> getMembership() {
        return this.members;
    }

    public Channel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCoordinator() {
        Address first_mbr = null;
        List<Address> list = this.members;
        synchronized (list) {
            Address address = first_mbr = !this.members.isEmpty() ? this.members.get(0) : null;
            if (first_mbr == null) {
                return true;
            }
        }
        return this.getLocalAddress() != null && this.getLocalAddress().equals(first_mbr);
    }

    public void start() throws Exception {
        this.channel.connect(this.bus_name);
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void sendNotification(Serializable n) {
        this.sendNotification(null, n);
    }

    public void sendNotification(Address dest, Serializable n) {
        block5: {
            Message msg = null;
            byte[] data = null;
            try {
                if (n == null) {
                    return;
                }
                Info info = new Info(1, n);
                info.inst = this.inst;
                data = Util.objectToByteBuffer((Object)info);
                msg = new Message(dest, null, data);
                if (this.channel == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("channel is null. Won't send notification");
                    }
                    return;
                }
                this.channel.send(msg);
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error("error sending notification", ex);
            }
        }
    }

    public Serializable getCacheFromCoordinator(long timeout, int max_tries) {
        return this.getCacheFromMember(null, timeout, max_tries);
    }

    public Serializable getCacheFromMember(Address mbr, long timeout, int max_tries) {
        Serializable cache = null;
        int num_tries = 0;
        Address dst = mbr;
        if (max_tries < 1) {
            max_tries = 1;
        }
        this.get_cache_promise.reset();
        while (num_tries <= max_tries) {
            if (mbr == null && ((dst = this.determineCoordinator()) == null || dst.equals(this.getLocalAddress()))) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("[" + this.getLocalAddress() + "] no coordinator found --> first member (cache is empty)");
                }
                return null;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("[" + this.getLocalAddress() + "] dst=" + dst + ", timeout=" + timeout + ", max_tries=" + max_tries + ", num_tries=" + num_tries);
            }
            Info info = new Info(2);
            Message msg = new Message(dst, null, (Object)info);
            try {
                this.channel.send(msg);
            }
            catch (Exception e) {
                this.log.error("failed sending message", (Throwable)e);
                return null;
            }
            long start = System.currentTimeMillis();
            cache = (Serializable)this.get_cache_promise.getResult(timeout);
            long stop = System.currentTimeMillis();
            if (cache != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("got cache from " + dst + ": cache is valid (waited " + (stop - start) + " msecs on get_cache_promise)");
                }
                return cache;
            }
            if (this.log.isErrorEnabled()) {
                this.log.error("received null cache; retrying (waited " + (stop - start) + " msecs on get_cache_promise)");
            }
            Util.sleep((long)500L);
            ++num_tries;
        }
        if (cache == null && this.log.isErrorEnabled()) {
            this.log.error("[" + this.getLocalAddress() + "] cache is null (num_tries=" + num_tries + ')');
        }
        return cache;
    }

    public void notifyConsumer(Serializable n) {
        if (this.consumer != null && n != null) {
            this.consumer.handleNotification(n);
        }
    }

    public void receive(Message msg) {
        block13: {
            Info info = null;
            if (msg == null || msg.getLength() == 0) {
                return;
            }
            try {
                Object obj = msg.getObject();
                if (!(obj instanceof Info)) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("expected an instance of Info (received " + obj.getClass().getName() + ')');
                    }
                    return;
                }
                info = (Info)obj;
                switch (info.type) {
                    case 1: {
                        if (this.inst != info.inst) {
                            this.notifyConsumer(info.data);
                        }
                        break;
                    }
                    case 2: {
                        this.handleCacheRequest(msg.getSrc());
                        break;
                    }
                    case 3: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("[GET_CACHE_RSP] cache was received from " + msg.getSrc());
                        }
                        this.get_cache_promise.setResult((Object)info.data);
                        break;
                    }
                    default: {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("type " + info.type + " unknown");
                        }
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) break block13;
                this.log.error("exception=" + ex);
            }
        }
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void viewAccepted(View new_view) {
        Vector<Address> left_mbrs;
        Vector<Address> joined_mbrs;
        if (new_view == null) {
            return;
        }
        List<Address> tmp = this.getMembers(new_view);
        List<Address> list = this.members;
        synchronized (list) {
            Address tmp_mbr;
            int i;
            joined_mbrs = new Vector<Address>();
            for (i = 0; i < tmp.size(); ++i) {
                tmp_mbr = tmp.get(i);
                if (this.members.contains(tmp_mbr)) continue;
                joined_mbrs.add(tmp_mbr);
            }
            left_mbrs = new Vector<Address>();
            for (i = 0; i < this.members.size(); ++i) {
                tmp_mbr = this.members.get(i);
                if (tmp.contains(tmp_mbr)) continue;
                left_mbrs.add(tmp_mbr);
            }
            this.members.clear();
            this.members.addAll(tmp);
        }
        if (this.consumer != null) {
            if (!joined_mbrs.isEmpty()) {
                for (int i = 0; i < joined_mbrs.size(); ++i) {
                    this.consumer.memberJoined((Address)joined_mbrs.get(i));
                }
            }
            if (!left_mbrs.isEmpty()) {
                for (int i = 0; i < left_mbrs.size(); ++i) {
                    this.consumer.memberLeft((Address)left_mbrs.get(i));
                }
            }
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    Address determineCoordinator() {
        List<Address> v = this.channel != null ? this.getMembers(this.channel.getView()) : null;
        return v != null ? v.get(0) : null;
    }

    List<Address> getMembers(View view) {
        try {
            if (this.getMembers == null) {
                Method m = view.getClass().getMethod("getMembers", new Class[0]);
                this.getMembers = FastMethod.create(m);
            }
            return (List)this.getMembers.invoke(view, new Object[0]);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCacheRequest(Address sender) throws Exception {
        Serializable cache = null;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("sender is null");
            }
            return;
        }
        Object object = this.cache_mutex;
        synchronized (object) {
            cache = this.getCache();
            Info info = new Info(3, cache);
            Message msg = new Message(sender, null, (Object)info);
            if (this.log.isInfoEnabled()) {
                this.log.info("[" + this.getLocalAddress() + "] returning cache to " + sender);
            }
            this.channel.send(msg);
        }
    }

    public Serializable getCache() {
        return this.consumer != null ? this.consumer.getCache() : null;
    }

    public void getState(OutputStream arg0) throws Exception {
    }

    public void setState(InputStream arg0) throws Exception {
    }

    public void unblock() {
    }

    private static class Info
    implements Serializable {
        public static final int NOTIFICATION = 1;
        public static final int GET_CACHE_REQ = 2;
        public static final int GET_CACHE_RSP = 3;
        int type = 0;
        int inst;
        Serializable data = null;
        private static final long serialVersionUID = -1L;

        public Info(int type) {
            this.type = type;
        }

        public Info(int type, Serializable data) {
            this.type = type;
            this.data = data;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type= ");
            if (this.type == 1) {
                sb.append("NOTIFICATION");
            } else if (this.type == 2) {
                sb.append("GET_CACHE_REQ");
            } else if (this.type == 3) {
                sb.append("GET_CACHE_RSP");
            } else {
                sb.append("<unknown>");
            }
            if (this.data != null) {
                if (this.type == 1) {
                    sb.append(", notification=" + this.data);
                } else if (this.type == 3) {
                    sb.append(", cache=" + this.data);
                }
            }
            return sb.toString();
        }
    }

    public static interface Consumer {
        public void handleNotification(Serializable var1);

        public Serializable getCache();

        public void memberJoined(Address var1);

        public void memberLeft(Address var1);
    }
}

