/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl;

import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import java.util.ArrayList;
import java.util.Set;
import org.ibatis.persist.Parameter;
import org.ibatis.persist.criteria.CommonAbstractCriteria;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.criteria.Predicate;
import org.ibatis.persist.criteria.Root;
import org.ibatis.persist.criteria.Subquery;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.CriteriaStatement;
import org.ibatis.persist.impl.CriteriaSubqueryImpl;
import org.ibatis.persist.impl.ParameterInfo;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.path.RootImpl;
import org.ibatis.persist.meta.EntityType;

public abstract class CriteriaManipulation<T>
implements CriteriaStatement,
CommonAbstractCriteria {
    private final CriteriaBuilderImpl criteriaBuilder;
    private RootImpl<T> root;
    private Predicate restriction;
    RenderingContext rc;
    ParameterMap parameterMap;

    protected CriteriaManipulation(CriteriaBuilderImpl criteriaBuilder, Class<T> entityClass) {
        this.criteriaBuilder = criteriaBuilder;
        EntityType<T> entityType = criteriaBuilder.getEntityManager().initEntityClass(entityClass);
        if (entityType != null && !entityType.isFailed()) {
            this.from(entityType);
        }
    }

    protected CriteriaBuilderImpl criteriaBuilder() {
        return this.criteriaBuilder;
    }

    public Root<T> from(Class<T> entityClass) {
        EntityType<T> entityType = this.criteriaBuilder.getEntityManager().initEntityClass(entityClass);
        if (entityType == null || entityType.isFailed()) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return this.from(entityType);
    }

    public Root<T> from(EntityType<T> entityType) {
        if (entityType == null || entityType.isFailed()) {
            throw new IllegalArgumentException("null or bad entity");
        }
        this.root = new RootImpl<T>(this.criteriaBuilder, entityType, null);
        return this.root;
    }

    public Root<T> getRoot() {
        return this.root;
    }

    protected void setRestriction(Expression<Boolean> restriction) {
        this.restriction = this.criteriaBuilder.wrap(restriction);
    }

    public void setRestriction(Predicate ... restrictions) {
        this.restriction = this.criteriaBuilder.and(restrictions);
    }

    @Override
    public Predicate getRestriction() {
        return this.restriction;
    }

    @Override
    public <U> Subquery<U> subquery(Class<U> type) {
        return new CriteriaSubqueryImpl<U>(this.criteriaBuilder(), type, this);
    }

    protected void validate() {
        if (this.root == null) {
            throw new IllegalStateException("UPDATE/DELETE criteria must name root entity");
        }
    }

    protected abstract void renderQuery(RenderingContext var1);

    protected void renderRoot(RenderingContext rc) {
        this.root.renderFrom(rc);
    }

    protected void renderRestrictions(RenderingContext rc) {
        if (this.getRestriction() != null) {
            rc.append(" where ");
            ((Renderable)((Object)this.getRestriction())).render(rc);
        }
    }

    @Override
    public synchronized void prepare() {
        if (this.rc == null) {
            this.validate();
            this.rc = new RenderingContext();
            this.rc.setQuery(false);
            this.renderQuery(this.rc);
        }
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    @Override
    public String getSql() {
        this.prepare();
        return this.rc.getSql();
    }

    @Override
    public ParameterInfo<?>[] getParameterInfos() {
        this.prepare();
        return this.rc.getParameterInfos();
    }

    public Set<? extends Parameter<?>> getParameters() {
        this.prepare();
        return this.rc.getParameters();
    }

    public Parameter<?> getParameter(String name) {
        for (Parameter<?> p : this.getParameters()) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        throw new IllegalArgumentException(name);
    }

    public <R> Parameter<R> getParameter(String name, Class<R> type) {
        for (Parameter<?> p : this.getParameters()) {
            if (!name.equals(p.getName()) || !type.isAssignableFrom(p.getParameterType())) continue;
            return p;
        }
        throw new IllegalArgumentException(name);
    }

    public boolean isBound(Parameter<?> param) {
        Object r = ((ParameterInfo)((Object)param)).getParameterValue();
        return r != ParameterInfo.None;
    }

    public <R> R getParameterValue(Parameter<R> param) {
        Object r = ((ParameterInfo)((Object)param)).getParameterValue();
        if (r == ParameterInfo.None) {
            return null;
        }
        return (R)r;
    }

    public <R> R getParameterValue(String name) {
        return (R)this.getParameterValue(this.getParameter(name));
    }

    @Override
    public ParameterMap makeParameterMap(SqlMapExecutorDelegate delegate) {
        if (this.parameterMap == null) {
            this.parameterMap = new ParameterMap(delegate);
            ArrayList<ParameterMapping> maps = new ArrayList<ParameterMapping>();
            for (ParameterInfo<?> pi : this.getParameterInfos()) {
                ParameterMapping map = new ParameterMapping();
                map.setMode("IN");
                map.setTypeHandler(delegate.getTypeHandlerFactory().getTypeHandler(pi.getParameterType()));
                map.setJavaType(pi.getParameterType());
                maps.add(map);
            }
            this.parameterMap.setParameterMappingList(maps);
        }
        return this.parameterMap;
    }

    @Override
    public void flushCache(SqlMapExecutorDelegate delegate) {
        if (this.root != null && this.root.getEntityType().isCacheable()) {
            delegate.getEntityManager().flushEntityCache(this.root.getEntityType().getJavaType());
        }
    }

    @Override
    public EntityType<?> getQueryCacheType() {
        return null;
    }
}

