/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl;

import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ibatis.persist.Parameter;
import org.ibatis.persist.criteria.CompoundSelection;
import org.ibatis.persist.criteria.CriteriaQuery;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.criteria.Order;
import org.ibatis.persist.criteria.ParameterExpression;
import org.ibatis.persist.criteria.Predicate;
import org.ibatis.persist.criteria.Root;
import org.ibatis.persist.criteria.Selection;
import org.ibatis.persist.criteria.Subquery;
import org.ibatis.persist.impl.AbstractNode;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.CriteriaStatement;
import org.ibatis.persist.impl.ParameterInfo;
import org.ibatis.persist.impl.QueryStructure;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.meta.EntityType;

public class CriteriaQueryImpl<T>
extends AbstractNode
implements CriteriaQuery<T>,
CriteriaStatement {
    private final Class<T> returnType;
    private final QueryStructure<T> queryStructure;
    private List<Order> orderSpecs = Collections.emptyList();
    RenderingContext rc;
    ParameterMap parameterMap;

    public CriteriaQueryImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> returnType) {
        super(criteriaBuilder);
        this.returnType = returnType;
        this.queryStructure = new QueryStructure<T>(this, criteriaBuilder, returnType);
    }

    @Override
    public Class<T> getResultType() {
        return this.returnType;
    }

    @Override
    public CriteriaQuery<T> distinct(boolean applyDistinction) {
        this.queryStructure.setDistinct(applyDistinction);
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.queryStructure.isDistinct();
    }

    @Override
    public Selection<T> getSelection() {
        return this.queryStructure.getSelection();
    }

    public void applySelection(Selection<? extends T> selection) {
        this.queryStructure.setSelection(selection);
    }

    @Override
    public CriteriaQuery<T> select(Selection<? extends T> selection) {
        this.applySelection(selection);
        return this;
    }

    @Override
    public CriteriaQuery<T> multiselect(Selection<?> ... selections) {
        return this.multiselect(Arrays.asList(selections));
    }

    @Override
    public CriteriaQuery<T> multiselect(List<Selection<?>> selections) {
        CompoundSelection<T> selection = this.criteriaBuilder().construct(this.getResultType(), selections);
        this.applySelection(selection);
        return this;
    }

    @Override
    public Set<Root<?>> getRoots() {
        return this.queryStructure.getRoots();
    }

    @Override
    public <X> Root<X> from(Class<X> entityClass) {
        return this.queryStructure.from(entityClass);
    }

    @Override
    public <X> Root<X> from(EntityType<X> entityType) {
        return this.queryStructure.from(entityType);
    }

    @Override
    public Predicate getRestriction() {
        return this.queryStructure.getRestriction();
    }

    @Override
    public CriteriaQuery<T> where(Expression<Boolean> expression) {
        this.queryStructure.setRestriction(this.criteriaBuilder().wrap(expression));
        return this;
    }

    @Override
    public CriteriaQuery<T> where(Predicate ... predicates) {
        this.queryStructure.setRestriction(this.criteriaBuilder().and(predicates));
        return this;
    }

    @Override
    public List<Expression<?>> getGroupList() {
        return this.queryStructure.getGroupings();
    }

    @Override
    public CriteriaQuery<T> groupBy(Expression<?> ... groupings) {
        this.queryStructure.setGroupings(groupings);
        return this;
    }

    @Override
    public CriteriaQuery<T> groupBy(List<Expression<?>> groupings) {
        this.queryStructure.setGroupings(groupings);
        return this;
    }

    @Override
    public Predicate getGroupRestriction() {
        return this.queryStructure.getHaving();
    }

    @Override
    public CriteriaQuery<T> having(Expression<Boolean> expression) {
        this.queryStructure.setHaving(this.criteriaBuilder().wrap(expression));
        return this;
    }

    @Override
    public CriteriaQuery<T> having(Predicate ... predicates) {
        this.queryStructure.setHaving(this.criteriaBuilder().and(predicates));
        return this;
    }

    @Override
    public List<Order> getOrderList() {
        return this.orderSpecs;
    }

    @Override
    public CriteriaQuery<T> orderBy(Order ... orders) {
        this.orderSpecs = orders != null && orders.length > 0 ? Arrays.asList(orders) : Collections.emptyList();
        return this;
    }

    @Override
    public CriteriaQuery<T> orderBy(List<Order> orders) {
        this.orderSpecs = orders;
        return this;
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        this.prepare();
        return this.rc.getParameters();
    }

    @Override
    public <U> Subquery<U> subquery(Class<U> subqueryType) {
        return this.queryStructure.subquery(subqueryType);
    }

    void validate() {
        if (this.getRoots().isEmpty()) {
            throw new IllegalStateException("No criteria query roots were specified");
        }
        if (this.getSelection() == null && !this.hasImplicitSelection()) {
            throw new IllegalStateException("No explicit selection and an implicit one could not be determined");
        }
    }

    private boolean hasImplicitSelection() {
        if (this.getRoots().size() != 1) {
            return false;
        }
        Root<?> root = this.getRoots().iterator().next();
        Class<?> javaType = root.getModel().getJavaType();
        return javaType == null || javaType == this.returnType;
    }

    @Override
    public <R> CriteriaQuery<T> setParameter(Parameter<R> param, R value) {
        ParameterInfo pi = (ParameterInfo)((Object)param);
        pi.setParameterValue(value);
        return this;
    }

    @Override
    public <R> CriteriaQuery<T> setParameter(String name, R value) {
        return this.setParameter(this.getParameter(name), (Object)value);
    }

    @Override
    public <R> CriteriaQuery<T> setParameter(int position, R value) {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.getPosition() == null || parameter.getPosition() != position) continue;
            this.setParameter(parameter, (Object)value);
            return this;
        }
        throw new IllegalArgumentException("" + position);
    }

    @Override
    public Parameter<?> getParameter(String name) {
        for (Parameter parameter : this.getParameters()) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        throw new IllegalArgumentException(name);
    }

    @Override
    public <R> Parameter<R> getParameter(String name, Class<R> type) {
        for (Parameter parameter : this.getParameters()) {
            if (!name.equals(parameter.getName()) || !type.isAssignableFrom(parameter.getParameterType())) continue;
            return parameter;
        }
        throw new IllegalArgumentException(name);
    }

    @Override
    public boolean isBound(Parameter<?> param) {
        Object r = ((ParameterInfo)((Object)param)).getParameterValue();
        return r != ParameterInfo.None;
    }

    @Override
    public <R> R getParameterValue(Parameter<R> param) {
        Object r = ((ParameterInfo)((Object)param)).getParameterValue();
        if (r == ParameterInfo.None) {
            return null;
        }
        return (R)r;
    }

    @Override
    public <R> R getParameterValue(String name) {
        return (R)this.getParameterValue(this.getParameter(name));
    }

    @Override
    public synchronized void prepare() {
        if (this.rc == null) {
            this.rc = new RenderingContext();
            this.validate();
            this.queryStructure.render(this.rc);
            if (!this.getOrderList().isEmpty()) {
                this.rc.append(" order by ");
                String sep = "";
                for (Order orderSpec : this.getOrderList()) {
                    this.rc.append(sep);
                    ((Renderable)((Object)orderSpec.getExpression())).render(this.rc);
                    this.rc.append(orderSpec.isAscending() ? " asc" : " desc");
                    sep = ", ";
                }
            }
        }
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public String getSql() {
        this.prepare();
        return this.rc.getSql();
    }

    @Override
    public ParameterInfo<?>[] getParameterInfos() {
        this.prepare();
        return this.rc.getParameterInfos();
    }

    @Override
    public ParameterMap makeParameterMap(SqlMapExecutorDelegate delegate) {
        if (this.parameterMap == null) {
            this.parameterMap = new ParameterMap(delegate);
            ArrayList<ParameterMapping> maps = new ArrayList<ParameterMapping>();
            for (ParameterInfo<?> pi : this.getParameterInfos()) {
                ParameterMapping map = new ParameterMapping();
                map.setMode("IN");
                map.setTypeHandler(delegate.getTypeHandlerFactory().getTypeHandler(pi.getParameterType()));
                map.setJavaType(pi.getParameterType());
                maps.add(map);
            }
            this.parameterMap.setParameterMappingList(maps);
        }
        return this.parameterMap;
    }

    @Override
    public void flushCache(SqlMapExecutorDelegate delegate) {
    }

    @Override
    public EntityType<?> getQueryCacheType() {
        Root<?> root;
        Set<Root<?>> roots = this.queryStructure.getRoots();
        if (roots.size() == 1 && (root = roots.iterator().next()).getModel().isCacheable()) {
            return root.getModel();
        }
        return null;
    }
}

