/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl;

import java.util.ArrayList;
import java.util.List;
import org.ibatis.persist.Parameter;
import org.ibatis.persist.criteria.CriteriaUpdate;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.criteria.Path;
import org.ibatis.persist.criteria.Predicate;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.CriteriaManipulation;
import org.ibatis.persist.impl.ExpressionImplementor;
import org.ibatis.persist.impl.ParameterInfo;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.path.AttributePathImpl;
import org.ibatis.persist.impl.util.GetterInterceptor;

public class CriteriaUpdateImpl<T>
extends CriteriaManipulation<T>
implements CriteriaUpdate<T> {
    private List<Assignment> assignments = new ArrayList<Assignment>();

    public CriteriaUpdateImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> targetEntity) {
        super(criteriaBuilder, targetEntity);
    }

    @Override
    public <Y, X extends Y> CriteriaUpdate<T> set(Path<Y> attributePath, X value) {
        Expression<X> valueExpression = value == null ? this.criteriaBuilder().nullLiteral(attributePath.getJavaType()) : this.criteriaBuilder().literal(value);
        this.addAssignment(attributePath, valueExpression);
        return this;
    }

    @Override
    public <Y> CriteriaUpdate<T> set(Path<Y> attributePath, Expression<? extends Y> value) {
        this.addAssignment(attributePath, value);
        return this;
    }

    @Override
    public <Y> CriteriaUpdate<T> set(Y attribute, Y value) {
        String attributeName = GetterInterceptor.take();
        Path<String> attributePath = this.getRoot().get(attributeName);
        Expression<Object> valueExpression = value == null ? this.criteriaBuilder().nullLiteral(attributePath.getJavaType()) : this.criteriaBuilder().literal(value);
        this.addAssignment(attributePath, valueExpression);
        return this;
    }

    @Override
    public <Y> CriteriaUpdate<T> set(Y attribute, Expression<? extends Y> value) {
        String attributeName = GetterInterceptor.take();
        Path<String> attributePath = this.getRoot().get(attributeName);
        this.addAssignment(attributePath, value);
        return this;
    }

    protected <Y> void addAssignment(Path<Y> attributePath, Expression<? extends Y> value) {
        if (value == null) {
            throw new IllegalArgumentException("Assignment value expression cannot be null. Did you mean to pass null as a literal?");
        }
        this.assignments.add(new Assignment((AttributePathImpl)attributePath, value));
    }

    @Override
    public CriteriaUpdate<T> where(Expression<Boolean> restriction) {
        this.setRestriction(restriction);
        return this;
    }

    @Override
    public CriteriaUpdate<T> where(Predicate ... restrictions) {
        this.setRestriction(restrictions);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.assignments.isEmpty()) {
            throw new IllegalStateException("No assignments specified as part of UPDATE criteria");
        }
    }

    @Override
    protected void renderQuery(RenderingContext rc) {
        rc.append("update ");
        this.renderRoot(rc);
        this.renderAssignments(rc);
        this.renderRestrictions(rc);
    }

    private void renderAssignments(RenderingContext rc) {
        rc.append(" set ");
        boolean first = true;
        for (Assignment assignment : this.assignments) {
            if (!first) {
                rc.append(", ");
            }
            assignment.attributePath.render(rc);
            rc.append(" = ");
            assignment.value.render(rc);
            first = false;
        }
    }

    @Override
    public <R> CriteriaUpdate<T> setParameter(Parameter<R> param, R value) {
        ParameterInfo pi = (ParameterInfo)((Object)param);
        pi.setParameterValue(value);
        return this;
    }

    @Override
    public <R> CriteriaUpdate<T> setParameter(String name, R value) {
        return this.setParameter(this.getParameter(name), (Object)value);
    }

    @Override
    public <R> CriteriaUpdate<T> setParameter(int position, R value) {
        for (Parameter<?> p : this.getParameters()) {
            if (p.getPosition() == null || p.getPosition() != position) continue;
            this.setParameter(p, (Object)value);
            return this;
        }
        throw new IllegalArgumentException("" + position);
    }

    @Override
    public Class<?> getResultType() {
        return Integer.class;
    }

    private class Assignment<A> {
        private final AttributePathImpl<A> attributePath;
        private final ExpressionImplementor<? extends A> value;

        private Assignment(AttributePathImpl<A> attributePath, Expression<? extends A> value) {
            this.attributePath = attributePath;
            this.value = (ExpressionImplementor)value;
        }
    }
}

