/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl;

import com.ibatis.common.Objects;
import com.ibatis.common.Page;
import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.sqlmap.client.event.PageHandler;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.AutoResultMap;
import com.ibatis.sqlmap.engine.mapping.statement.DefaultRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ibatis.client.Cache;
import org.ibatis.persist.PersistenceException;
import org.ibatis.persist.criteria.CriteriaBuilder;
import org.ibatis.persist.criteria.CriteriaDelete;
import org.ibatis.persist.criteria.CriteriaQuery;
import org.ibatis.persist.criteria.CriteriaUpdate;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.CriteriaStatement;
import org.ibatis.persist.impl.EntityTypeImpl;
import org.ibatis.persist.impl.ExecuteContext;
import org.ibatis.persist.impl.ParameterInfo;
import org.ibatis.persist.meta.EntityType;

public class EntityManager {
    static final ILog log = ILogFactory.getLog(EntityManager.class);
    SqlMapExecutorDelegate delegate;
    XmlParserState state;
    CriteriaBuilderImpl criteriaBuilderImpl;
    private Map<Class<?>, EntityType<?>> entityClassMap = new LinkedHashMap();

    public EntityManager(SqlMapExecutorDelegate delegate, XmlParserState state) {
        this.delegate = delegate;
        this.state = state;
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public <E> E insertEntity(SessionScope sessionScope, Class<E> cls, E entity) throws SQLException {
        EntityType<E> ep = this.initEntityClass(cls);
        if (ep == null || ep.isFailed()) {
            throw new RuntimeException(ep.getErrorMessage());
        }
        String statId = ep.getInsertStatementId();
        this.delegate.insert(sessionScope, statId, ep.getInsertParameter(entity));
        return entity;
    }

    public <E, K> int updateEntity(SessionScope sessionScope, Class<E> cls, E entity) throws SQLException {
        EntityType<E> ep = this.initEntityClass(cls);
        if (ep == null || ep.isFailed()) {
            throw new RuntimeException(ep.getErrorMessage());
        }
        String statId = ep.getUpdateStatementId();
        return this.delegate.update(sessionScope, statId, ep.getUpdateParameter(entity));
    }

    public <E, K> int deleteEntity(SessionScope sessionScope, Class<E> cls, K key) throws SQLException {
        EntityType<E> ep = this.initEntityClass(cls);
        if (ep.isFailed()) {
            throw new RuntimeException(ep.getErrorMessage());
        }
        String statId = ep.getDeleteStatementId();
        return this.delegate.update(sessionScope, statId, ep.getDeleteParameter(key));
    }

    public <E, K> E findEntity(SessionScope sessionScope, Class<E> cls, K key) throws SQLException {
        EntityType<E> ep = this.initEntityClass(cls);
        if (ep.isFailed()) {
            throw new RuntimeException(ep.getErrorMessage());
        }
        String statId = ep.getFindStatementId();
        return (E)this.delegate.queryForObject(sessionScope, statId, ep.getFindParameter(key));
    }

    public <T> T executeQueryObject(SessionScope sessionScope, CriteriaQuery<T> criteriaQuery) {
        List<T> list = this.executeQuery(sessionScope, criteriaQuery, 0, 2);
        T t = null;
        if (list.size() > 1) {
            throw new PersistenceException("executeQueryObject returned too many results.");
        }
        if (list.size() > 0) {
            t = list.get(0);
        }
        return t;
    }

    public <T> List<T> executeQuery(SessionScope sessionScope, CriteriaQuery<T> criteriaQuery) {
        return this.executeQuery(sessionScope, criteriaQuery, 0, -1);
    }

    public <T> List<T> executeQuery(SessionScope sessionScope, final CriteriaQuery<T> criteriaQuery, final int skip, final int max) {
        ExecuteContext e = new ExecuteContext<List<T>>(){

            @Override
            public List<T> execute(StatementScope statementScope, Transaction trans) throws SQLException {
                Object old;
                CriteriaStatement exec = (CriteriaStatement)((Object)criteriaQuery);
                exec.prepare();
                String sql = exec.getSql();
                Class<?> resultClass = exec.getResultType();
                ParameterInfo<?>[] params = exec.getParameterInfos();
                Object[] parameters = new Object[params.length];
                for (int i = 0; params != null && i < params.length; ++i) {
                    parameters[i] = params[i].getParameterValue();
                }
                EntityType<?> cacheType = exec.getQueryCacheType();
                CacheModel cm = null;
                CacheKey key = null;
                if (cacheType != null) {
                    key = new CacheKey();
                    key.update("executeCriteriaQuery");
                    key.update(skip);
                    key.update(max);
                    key.update(cacheType.getJavaType());
                    key.update(sql);
                    key.update(resultClass);
                    for (Object arg : parameters) {
                        key.update(arg);
                    }
                    cm = EntityManager.this.delegate.findCacheModel(cacheType.getEntityCacheModelId());
                }
                if (cm != null && (old = cm.getObject(key)) instanceof List) {
                    return (List)Objects.uncheckedCast(old);
                }
                ParameterMap pm = exec.makeParameterMap(EntityManager.this.delegate);
                AutoResultMap arm = new AutoResultMap(EntityManager.this.getDelegate(), false);
                arm.setResultClass(resultClass);
                DefaultRowHandler rowHandler = new DefaultRowHandler();
                RowHandlerCallback callback = new RowHandlerCallback(arm, null, rowHandler);
                statementScope.setParameterMap(pm);
                statementScope.setResultMap(arm);
                if (cm != null) {
                    EntityManager.this.delegate.getSqlExecutor().executeQuery(null, statementScope, trans.getConnection(), sql, parameters, skip, max, callback);
                    List list = rowHandler.getList();
                    cm.putObject((Object)key, list);
                    return list;
                }
                EntityManager.this.delegate.getSqlExecutor().executeQuery(null, statementScope, trans.getConnection(), sql, parameters, skip, max, callback);
                List list = rowHandler.getList();
                return list;
            }
        };
        try {
            return (List)this.delegate.executeCallback(sessionScope, e);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), ex);
        }
    }

    public <T> int executeQueryPage(SessionScope sessionScope, final CriteriaQuery<T> criteriaQuery, final List<T> page, final int skip, final int max) {
        ExecuteContext<Integer> e = new ExecuteContext<Integer>(){

            @Override
            public Integer execute(StatementScope statementScope, Transaction trans) throws SQLException {
                Object old;
                CriteriaStatement exec = (CriteriaStatement)((Object)criteriaQuery);
                exec.prepare();
                String sql = exec.getSql();
                Class<?> resultClass = exec.getResultType();
                ParameterInfo<?>[] params = exec.getParameterInfos();
                Object[] parameters = new Object[params.length];
                for (int i = 0; params != null && i < params.length; ++i) {
                    parameters[i] = params[i].getParameterValue();
                }
                EntityType<?> cacheType = exec.getQueryCacheType();
                CacheModel cm = null;
                CacheKey key = null;
                if (cacheType != null) {
                    key = new CacheKey();
                    key.update("executeCriteriaQueryPage");
                    key.update(page != null);
                    key.update(skip);
                    key.update(max);
                    key.update(cacheType.getJavaType());
                    key.update(sql);
                    key.update(resultClass);
                    for (Object arg : parameters) {
                        key.update(arg);
                    }
                    cm = EntityManager.this.delegate.findCacheModel(cacheType.getEntityCacheModelId());
                }
                if (cm != null && (old = cm.getObject(key)) instanceof Page) {
                    Page pageObject = (Page)Objects.uncheckedCast(old);
                    if (page != null) {
                        page.addAll(pageObject.list);
                    }
                    return pageObject.total;
                }
                ParameterMap pm = exec.makeParameterMap(EntityManager.this.delegate);
                AutoResultMap arm = new AutoResultMap(EntityManager.this.getDelegate(), false);
                arm.setResultClass(resultClass);
                statementScope.setParameterMap(pm);
                statementScope.setResultMap(arm);
                if (cm != null) {
                    ArrayList p = new ArrayList();
                    PageHandler pageHandler = new PageHandler(p);
                    RowHandlerCallback callback = new RowHandlerCallback(arm, null, pageHandler);
                    EntityManager.this.delegate.getSqlExecutor().executeQueryPage(null, statementScope, trans.getConnection(), sql, parameters, skip, max, callback, pageHandler);
                    int total = pageHandler.getTotal();
                    cm.putObject((Object)key, new Page(total, p));
                    if (page != null) {
                        page.addAll(p);
                    }
                    return total;
                }
                PageHandler pageHandler = new PageHandler(page);
                RowHandlerCallback callback = new RowHandlerCallback(arm, null, pageHandler);
                EntityManager.this.delegate.getSqlExecutor().executeQueryPage(null, statementScope, trans.getConnection(), sql, parameters, skip, max, callback, pageHandler);
                return pageHandler.handleTotal(0);
            }
        };
        try {
            return this.delegate.executeCallback(sessionScope, e);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), ex);
        }
    }

    public <T> int executeUpdate(SessionScope sessionScope, final CriteriaUpdate<T> updateQuery) {
        ExecuteContext<Integer> e = new ExecuteContext<Integer>(){

            @Override
            public Integer execute(StatementScope statementScope, Transaction trans) throws SQLException {
                CriteriaStatement exec = (CriteriaStatement)((Object)updateQuery);
                exec.prepare();
                String sql = exec.getSql();
                ParameterInfo<?>[] params = exec.getParameterInfos();
                Object[] parameters = new Object[params.length];
                for (int i = 0; params != null && i < params.length; ++i) {
                    parameters[i] = params[i].getParameterValue();
                }
                ParameterMap pm = exec.makeParameterMap(EntityManager.this.delegate);
                statementScope.setParameterMap(pm);
                int ret = EntityManager.this.delegate.getSqlExecutor().executeUpdate(null, statementScope, trans.getConnection(), sql, parameters);
                exec.flushCache(EntityManager.this.delegate);
                return ret;
            }
        };
        try {
            return this.delegate.executeCallback(sessionScope, e);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), ex);
        }
    }

    public <T> int executeDelete(SessionScope sessionScope, final CriteriaDelete<T> deleteQuery) {
        ExecuteContext<Integer> e = new ExecuteContext<Integer>(){

            @Override
            public Integer execute(StatementScope statementScope, Transaction trans) throws SQLException {
                CriteriaStatement exec = (CriteriaStatement)((Object)deleteQuery);
                exec.prepare();
                String sql = exec.getSql();
                ParameterInfo<?>[] params = exec.getParameterInfos();
                Object[] parameters = new Object[params.length];
                for (int i = 0; params != null && i < params.length; ++i) {
                    parameters[i] = params[i].getParameterValue();
                }
                ParameterMap pm = exec.makeParameterMap(EntityManager.this.delegate);
                statementScope.setParameterMap(pm);
                int ret = EntityManager.this.delegate.getSqlExecutor().executeUpdate(null, statementScope, trans.getConnection(), sql, parameters);
                exec.flushCache(EntityManager.this.delegate);
                return ret;
            }
        };
        try {
            return this.delegate.executeCallback(sessionScope, e);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), ex);
        }
    }

    public CriteriaBuilder getCriteriaBuilder() {
        if (this.criteriaBuilderImpl == null) {
            this.criteriaBuilderImpl = new CriteriaBuilderImpl(this);
        }
        return this.criteriaBuilderImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> EntityType<E> initEntityClass(Class<E> cls) {
        EntityTypeImpl<E> ep = (EntityTypeImpl<E>)Objects.uncheckedCast(this.entityClassMap.get(cls));
        if (ep == null) {
            Map<Class<?>, EntityType<?>> map = this.entityClassMap;
            synchronized (map) {
                ep = (EntityType)Objects.uncheckedCast(this.entityClassMap.get(cls));
                if (ep == null) {
                    EntityTypeImpl<E> epi = new EntityTypeImpl<E>(cls, this);
                    if (!epi.isFailed()) {
                        long time = System.currentTimeMillis();
                        SqlMapParser mapParser = new SqlMapParser(this.state, false);
                        String xml = epi.buildSqlMapXml();
                        try {
                            this.state.getConfig().getErrorContext().setResource(epi.getResourceLocation());
                            ILog log = ILogFactory.getLog(this.delegate.getSqlExecutor().getClass());
                            mapParser.parse(epi.getResourceLocation(), new StringReader(xml));
                            this.state.getConfig().finalizeSqlMapConfig();
                            log.info("Load entity " + cls + " elapsed time " + (System.currentTimeMillis() - time));
                        }
                        catch (Exception ex) {
                            log.error(ex.getMessage(), ex);
                            if (this.delegate.getSqlExecutor().isDebugSql()) {
                                log.info(xml);
                            }
                            epi.setError(ex);
                        }
                    }
                    ep = epi;
                    this.entityClassMap.put(cls, ep);
                }
            }
        }
        return ep;
    }

    public Cache findEntityCache(Class<?> entityClass) {
        EntityType<?> ep = this.entityClassMap.get(entityClass);
        if (ep != null && !ep.isFailed() && ep.isCacheable()) {
            return this.delegate.findCacheModel(ep.getEntityCacheModelId());
        }
        return null;
    }

    public void flushEntityCache(Class<?> entityClass) {
        Cache cache = this.findEntityCache(entityClass);
        if (cache != null) {
            cache.flush();
        }
    }
}

