/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ibatis.cglib.ClassInfo;
import org.ibatis.cglib.Invoker;
import org.ibatis.persist.Cacheable;
import org.ibatis.persist.Column;
import org.ibatis.persist.Entity;
import org.ibatis.persist.Id;
import org.ibatis.persist.IdClass;
import org.ibatis.persist.PersistenceException;
import org.ibatis.persist.Table;
import org.ibatis.persist.Transient;
import org.ibatis.persist.impl.EntityManager;
import org.ibatis.persist.meta.Attribute;
import org.ibatis.persist.meta.EntityType;

public class EntityTypeImpl<E>
implements EntityType<E> {
    private static final ILog log = ILogFactory.getLog(EntityTypeImpl.class);
    EntityManager entityManager;
    Class<E> entityClass;
    String entityName;
    String namespace;
    String tableName;
    String tableQName;
    Class<?> idClass;
    Attribute<E, ?> idAttr;
    boolean cacheable;
    String cacheType;
    int cacheMinutes;
    Set<Class<?>> cacheRoots = new HashSet();
    Exception error;
    private Map<String, Attribute<E, ?>> attributes = new LinkedHashMap();
    private Map<String, Attribute<E, ?>> keys = new LinkedHashMap();
    private List<String> attrNames = new ArrayList<String>();
    static final Set<Class<?>> PrimaryKeyTypes = new HashSet();

    public EntityTypeImpl(Class<E> entityClass, EntityManager entityManager) {
        Cacheable ca;
        this.entityManager = entityManager;
        if (entityClass == null) {
            this.setError(new PersistenceException("entity class is null."));
            return;
        }
        if (entityClass.getEnclosingClass() != null) {
            this.setError(new PersistenceException("entity " + entityClass + " is not top-level."));
            return;
        }
        Constructor<E> con = null;
        try {
            con = entityClass.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (con == null || !Modifier.isPublic(con.getModifiers())) {
            this.setError(new PersistenceException("entity " + entityClass + " has no public default constructor."));
            return;
        }
        Entity en = entityClass.getAnnotation(Entity.class);
        if (en == null) {
            this.setError(new PersistenceException("entity " + entityClass + " has no @Entity annotation."));
            return;
        }
        Table tb = entityClass.getAnnotation(Table.class);
        if (tb == null) {
            this.setError(new PersistenceException("entity " + entityClass + " has no @Table annotation."));
            return;
        }
        this.entityClass = entityClass;
        IdClass idc = entityClass.getAnnotation(IdClass.class);
        if (idc != null) {
            this.idClass = idc.value();
        }
        this.entityName = en.name();
        if (this.entityName.isEmpty()) {
            this.entityName = entityClass.getSimpleName();
        }
        this.namespace = en.namespace();
        if (this.namespace.isEmpty()) {
            this.namespace = entityClass.getPackage().getName();
        }
        if ((ca = entityClass.getAnnotation(Cacheable.class)) != null) {
            this.cacheable = ca.value();
        }
        if (this.cacheable) {
            this.cacheType = ca.type();
            this.cacheMinutes = ca.minutes();
            for (Class<?> cr : ca.roots()) {
                this.cacheRoots.add(cr);
            }
        }
        this.tableName = tb.name();
        if (this.tableName.isEmpty()) {
            this.tableName = this.entityName;
        }
        this.tableQName = this.tableName;
        if (!tb.schema().isEmpty()) {
            this.tableQName = tb.schema() + "." + this.tableQName;
        }
        try {
            ClassInfo ci = ClassInfo.getInstance(entityClass, true);
            List<String> attrs = ci.getPropertyNames();
            for (String attr : attrs) {
                Class<?> type = ci.getGetterType(attr);
                Invoker getter = ci.getGetInvoker(attr);
                Invoker setter = ci.getSetInvoker(attr);
                Column c = getter.getAnnotation(Column.class);
                if (c == null) {
                    c = setter.getAnnotation(Column.class);
                }
                if (c == null) {
                    Transient t = getter.getAnnotation(Transient.class);
                    if (t == null) {
                        t = setter.getAnnotation(Transient.class);
                    }
                    if (t != null) continue;
                }
                String colName = attr;
                if (c != null && !c.name().isEmpty()) {
                    colName = c.name();
                }
                if (entityManager.getDelegate().getTypeHandlerFactory().getTypeHandler(type) == null) {
                    if (c != null) {
                        this.setError(new PersistenceException("Attr '" + attr + "' type '" + type + "' is illegal in entity class: " + entityClass));
                        return;
                    }
                    log.error("Attr '" + attr + "' ignored in entity class: " + entityClass + " because of bad type: " + type);
                    continue;
                }
                Attribute pa = new Attribute(attr, colName, type, getter, setter);
                Id id = pa.getAnnotation(Id.class);
                if (id == null) {
                    this.attributes.put(attr, pa);
                    this.attrNames.add(attr);
                    continue;
                }
                if (!PrimaryKeyTypes.contains(type)) {
                    this.setError(new PersistenceException("Attr '" + attr + "' type '" + type + "' is illegal @Id type in entity class: " + entityClass));
                    return;
                }
                this.idAttr = pa;
                this.keys.put(attr, pa);
                this.attributes.put(attr, pa);
                this.attrNames.add(attr);
            }
        }
        catch (Exception e) {
            log.error("Failed to init entity class: " + entityClass + ", " + e, e);
            this.setError(new PersistenceException("Failed to init entity class: " + entityClass + ", " + e, e));
            return;
        }
        if (this.attributes.isEmpty()) {
            this.setError(new PersistenceException("entity " + entityClass + " has no attr with @Column annotation."));
            return;
        }
        if (this.keys.size() > 1) {
            if (this.idClass == null) {
                this.setError(new PersistenceException("entity " + entityClass + " have multiple Id but without @IdClass."));
                return;
            }
            List<String> list = null;
            try {
                list = ClassInfo.getInstance(this.idClass, true).getPropertyNames();
            }
            catch (Exception e) {
                this.setError(new PersistenceException("entity " + entityClass + " has bad IdClass:" + this.idClass.getName() + ", " + e.getMessage()));
                return;
            }
            for (String keyName : this.keys.keySet()) {
                if (list.contains(keyName)) continue;
                this.setError(new PersistenceException("entity " + entityClass + " has bad IdClass:" + this.idClass.getName()));
                return;
            }
        }
    }

    public void setError(Exception error) {
        this.error = error;
    }

    @Override
    public boolean isFailed() {
        return this.error != null;
    }

    @Override
    public Map<String, Attribute<E, ?>> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Map<String, Attribute<E, ?>> getIdAttributes() {
        return Collections.unmodifiableMap(this.keys);
    }

    public String getResourceLocation() {
        return "ibatis-entity/" + this.entityClass.getName() + ".xml";
    }

    @Override
    public String getErrorMessage() {
        if (this.error != null) {
            return this.error.getMessage() != null ? this.error.getMessage() : this.error.toString();
        }
        return null;
    }

    public String getEntityQName() {
        return this.namespace + "." + this.entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public String getInsertStatementId() {
        return this.entityName + "#insert";
    }

    @Override
    public Object getInsertParameter(E e) {
        return e;
    }

    @Override
    public String getUpdateStatementId() {
        return this.entityName + "#update";
    }

    @Override
    public Object getUpdateParameter(E e) {
        return e;
    }

    @Override
    public String getDeleteStatementId() {
        return this.entityName + "#delete";
    }

    @Override
    public Object getDeleteParameter(Object key) {
        if (this.keys.isEmpty()) {
            throw new UnsupportedOperationException("entity " + this.entityClass + " has no attr with @Id annotation.");
        }
        if (this.idClass != null && this.idClass.isInstance(key)) {
            return key;
        }
        if (this.keys.size() == 1) {
            return key;
        }
        throw new IllegalArgumentException("bad id " + key + " for entity " + this.entityClass);
    }

    @Override
    public String getFindStatementId() {
        return this.entityName + "#find";
    }

    @Override
    public String getEntityCacheModelId() {
        return this.entityName + "#cache";
    }

    @Override
    public Object getFindParameter(Object key) {
        if (this.keys.isEmpty()) {
            throw new UnsupportedOperationException("entity " + this.entityClass + " has no attr with @Id annotation.");
        }
        if (this.idClass != null && this.idClass.isInstance(key)) {
            return key;
        }
        if (this.keys.size() == 1) {
            return key;
        }
        throw new IllegalArgumentException("bad id " + key + " for entity " + this.entityClass);
    }

    public String buildSqlMapXml() {
        StringBuilder pw = new StringBuilder(4096);
        pw.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        pw.append("<!DOCTYPE sqlMap PUBLIC '-//iBATIS.org//DTD SQL Map 2.4//EN' 'sql-map-2.4.dtd'>\n");
        pw.append("\n");
        pw.append("<sqlMap namespace='").append(this.namespace).append("'>\n");
        this.buildInsertXml(pw);
        this.buildUpdateXml(pw);
        this.buildDeleteXml(pw);
        this.buildFindXml(pw);
        pw.append("</sqlMap>");
        return pw.toString();
    }

    void buildInsertXml(StringBuilder pw) {
        Attribute<E, ?> genKey = null;
        if (this.idAttr != null && this.idAttr.getAnnotation(Id.class).auto()) {
            genKey = this.idAttr;
        }
        pw.append("\n");
        pw.append("  <insert id='").append(this.getInsertStatementId()).append("' parameterClass='").append(this.entityClass.getName()).append("'>\n");
        pw.append("    INSERT INTO ").append(this.tableQName).append(" (");
        boolean first = true;
        for (Attribute<E, ?> pa : this.attributes.values()) {
            if (genKey == pa) continue;
            if (first) {
                pw.append("\n");
            } else {
                pw.append(",\n");
            }
            pw.append("      ").append(pa.getColumn());
            first = false;
        }
        pw.append("\n");
        pw.append("    ) VALUES (");
        first = true;
        for (Attribute<E, ?> pa : this.attributes.values()) {
            if (genKey == pa) continue;
            if (first) {
                pw.append("\n");
            } else {
                pw.append(",\n");
            }
            pw.append("      #").append(pa.getName()).append("#");
            first = false;
        }
        pw.append("\n");
        pw.append("    )\n");
        if (genKey != null) {
            String rc = genKey.getType().getName();
            pw.append("    <selectKey resultClass='").append(rc).append("' keyProperty='").append(genKey.getName()).append("'/>\n");
        }
        pw.append("  </insert>\n");
    }

    void buildUpdateXml(StringBuilder pw) {
        if (this.keys.isEmpty()) {
            return;
        }
        pw.append("\n");
        pw.append("  <update id='").append(this.getUpdateStatementId()).append("' parameterClass='").append(this.entityClass.getName()).append("'>\n");
        pw.append("    UPDATE ").append(this.tableQName).append(" SET");
        boolean first = true;
        for (Attribute<E, ?> pa : this.attributes.values()) {
            if (this.keys.containsValue(pa)) continue;
            if (first) {
                pw.append("\n");
            } else {
                pw.append(",\n");
            }
            pw.append("      ").append(pa.getColumn()).append(" = #").append(pa.getName()).append("#");
            first = false;
        }
        pw.append("\n");
        pw.append("    WHERE ");
        first = true;
        for (Attribute<E, ?> pa : this.keys.values()) {
            if (!first) {
                pw.append("\n");
                pw.append("      AND ");
            }
            pw.append(pa.getColumn()).append(" = #").append(pa.getName()).append("#\n");
            first = false;
        }
        pw.append("\n");
        pw.append("  </update>\n");
    }

    void buildDeleteXml(StringBuilder pw) {
        if (this.keys.isEmpty()) {
            return;
        }
        pw.append("\n");
        if (this.idClass != null) {
            pw.append("  <delete id='").append(this.getDeleteStatementId()).append("' parameterClass='").append(this.idClass.getName()).append("'>\n");
        } else {
            pw.append("  <delete id='").append(this.getDeleteStatementId()).append("' parameterClass='").append(this.idAttr.getType().getName()).append("'>\n");
        }
        pw.append("    DELETE FROM ").append(this.tableQName);
        pw.append("\n");
        pw.append("    WHERE ");
        boolean first = true;
        for (Attribute<E, ?> pa : this.keys.values()) {
            if (!first) {
                pw.append("\n");
                pw.append("      AND ");
            }
            pw.append(pa.getColumn()).append(" = #").append(pa.getName()).append("#");
            first = false;
        }
        pw.append("\n");
        pw.append("  </delete>\n");
    }

    void buildFindXml(StringBuilder pw) {
        if (this.keys.isEmpty()) {
            return;
        }
        if (this.cacheable) {
            pw.append("\n");
            pw.append("  <cacheModel id='").append(this.getEntityCacheModelId()).append("' type='").append(this.cacheType).append("'>\n");
            pw.append("    <flushInterval minutes='").append(this.cacheMinutes).append("' />\n");
            pw.append("    <flushOnExecute statement='").append(this.getInsertStatementId()).append("' />\n");
            pw.append("    <flushOnExecute statement='").append(this.getDeleteStatementId()).append("' />\n");
            pw.append("    <flushOnExecute statement='").append(this.getUpdateStatementId()).append("' />\n");
            for (Class<?> clazz : this.cacheRoots) {
                pw.append("    <flushOnFlash entityClass='").append(clazz.getName()).append("' />\n");
            }
            pw.append("  </cacheModel>\n");
        }
        pw.append("\n");
        if (this.idClass != null) {
            pw.append("  <select id='").append(this.getFindStatementId()).append("' ");
            if (this.cacheable) {
                pw.append("cacheModel='").append(this.getEntityCacheModelId()).append("' ");
            }
            pw.append("parameterClass='").append(this.idClass.getName()).append("' resultClass='").append(this.entityClass.getName()).append("'>\n");
        } else {
            pw.append("  <select id='").append(this.getFindStatementId()).append("' ");
            if (this.cacheable) {
                pw.append("cacheModel='").append(this.getEntityCacheModelId()).append("' ");
            }
            pw.append("parameterClass='").append(this.idAttr.getType().getName()).append("' resultClass='").append(this.entityClass.getName()).append("'>\n");
        }
        pw.append("    SELECT ");
        boolean first = true;
        for (Attribute<E, ?> pa : this.attributes.values()) {
            if (first) {
                pw.append("\n");
            } else {
                pw.append(",\n");
            }
            pw.append("      ").append(pa.getColumn()).append(" AS ").append(pa.getName());
            first = false;
        }
        pw.append("\n");
        pw.append("    FROM ").append(this.tableQName);
        pw.append("\n");
        pw.append("    WHERE ");
        first = true;
        for (Attribute<E, ?> pa : this.keys.values()) {
            if (!first) {
                pw.append("\n");
                pw.append("      AND ");
            }
            pw.append(pa.getColumn()).append(" = #").append(pa.getName()).append("#");
            first = false;
        }
        pw.append("\n");
        pw.append("  </select>\n");
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public Class<E> getJavaType() {
        return this.entityClass;
    }

    @Override
    public Attribute<E, ?> locateAttribute(String name) {
        Attribute<E, ?> a = this.attributes.get(name);
        if (a == null) {
            for (String n : this.attributes.keySet()) {
                if (!n.equalsIgnoreCase(name)) continue;
                return this.attributes.get(n);
            }
        }
        return a;
    }

    @Override
    public List<String> getAttributeNames() {
        return this.attrNames;
    }

    @Override
    public String getTableName() {
        return this.tableQName;
    }

    static {
        PrimaryKeyTypes.add(Byte.TYPE);
        PrimaryKeyTypes.add(Byte.class);
        PrimaryKeyTypes.add(Character.TYPE);
        PrimaryKeyTypes.add(Character.class);
        PrimaryKeyTypes.add(Short.TYPE);
        PrimaryKeyTypes.add(Short.class);
        PrimaryKeyTypes.add(Integer.TYPE);
        PrimaryKeyTypes.add(Integer.class);
        PrimaryKeyTypes.add(Long.TYPE);
        PrimaryKeyTypes.add(Long.class);
        PrimaryKeyTypes.add(String.class);
        PrimaryKeyTypes.add(java.util.Date.class);
        PrimaryKeyTypes.add(Date.class);
        PrimaryKeyTypes.add(BigDecimal.class);
        PrimaryKeyTypes.add(BigInteger.class);
    }
}

