/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ibatis.persist.Entity;
import org.ibatis.persist.criteria.AbstractQuery;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.criteria.Predicate;
import org.ibatis.persist.criteria.Root;
import org.ibatis.persist.criteria.Selection;
import org.ibatis.persist.criteria.Subquery;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.CriteriaSubqueryImpl;
import org.ibatis.persist.impl.FromImplementor;
import org.ibatis.persist.impl.JoinImplementor;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.path.RootImpl;
import org.ibatis.persist.meta.EntityType;

public class QueryStructure<T> {
    private final AbstractQuery<T> owner;
    private final CriteriaBuilderImpl criteriaBuilder;
    private final boolean isSubQuery;
    private Class<T> resultType;
    private boolean distinct;
    private Selection<? extends T> selection;
    private Set<Root<?>> roots = new LinkedHashSet();
    private JoinImplementor joinImplementor;
    private Predicate restriction;
    private List<Expression<?>> groupings = Collections.emptyList();
    private Predicate having;
    private List<Subquery<?>> subqueries;

    public QueryStructure(AbstractQuery<T> owner, CriteriaBuilderImpl criteriaBuilder, Class<T> resultType) {
        this.owner = owner;
        this.criteriaBuilder = criteriaBuilder;
        this.resultType = resultType;
        this.isSubQuery = Subquery.class.isInstance(owner);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public Selection<? extends T> getSelection() {
        return this.selection;
    }

    public void setSelection(Selection<? extends T> selection) {
        this.selection = selection;
    }

    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    public <X> Root<X> from(Class<X> entityClass) {
        EntityType<X> entityType = this.criteriaBuilder.getEntityManager().initEntityClass(entityClass);
        if (entityType == null || entityType.isFailed()) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return this.from(entityType);
    }

    public <X> Root<X> from(EntityType<X> entityType) {
        RootImpl<X> root = new RootImpl<X>(this.criteriaBuilder, entityType, this);
        this.roots.add(root);
        return root;
    }

    public Predicate getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Predicate restriction) {
        this.restriction = restriction;
    }

    public List<Expression<?>> getGroupings() {
        return this.groupings;
    }

    public void setGroupings(List<Expression<?>> groupings) {
        this.groupings = groupings;
    }

    public void setGroupings(Expression<?> ... groupings) {
        this.groupings = groupings != null && groupings.length > 0 ? Arrays.asList(groupings) : Collections.emptyList();
    }

    public Predicate getHaving() {
        return this.having;
    }

    public void setHaving(Predicate having) {
        this.having = having;
    }

    public List<Subquery<?>> getSubqueries() {
        return this.subqueries;
    }

    public List<Subquery<?>> internalGetSubqueries() {
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        return this.subqueries;
    }

    public <U> Subquery<U> subquery(Class<U> subqueryType) {
        CriteriaSubqueryImpl<U> subquery = new CriteriaSubqueryImpl<U>(this.criteriaBuilder, subqueryType, this.owner);
        this.internalGetSubqueries().add(subquery);
        return subquery;
    }

    public void render(RenderingContext rc) {
        Set<Root<?>> allRoots;
        HashSet<Root> joinedRoots = new HashSet<Root>();
        if (this.joinImplementor != null) {
            this.collectJoinedRoots(this.joinImplementor, joinedRoots);
        }
        if ((allRoots = this.getRoots()).size() > 1) {
            for (Root<?> root : allRoots) {
                ((RootImpl)root).prepareAlias(rc);
            }
        }
        rc.append("select ");
        if (this.isDistinct()) {
            rc.append("distinct ");
        }
        if (this.getSelection() == null) {
            this.locateImplicitSelection().renderProjection(rc);
        } else {
            ((Renderable)((Object)this.getSelection())).renderProjection(rc);
        }
        this.renderFromClause(rc, joinedRoots);
        if (this.getRestriction() != null) {
            rc.append(" where ");
            ((Renderable)((Object)this.getRestriction())).render(rc);
        }
        if (!this.getGroupings().isEmpty()) {
            rc.append(" group by ");
            String sep = "";
            for (Expression<?> grouping : this.getGroupings()) {
                rc.append(sep);
                ((Renderable)((Object)grouping)).render(rc);
                sep = ", ";
            }
            if (this.getHaving() != null) {
                rc.append(" having ");
                ((Renderable)((Object)this.getHaving())).render(rc);
            }
        }
    }

    private Renderable locateImplicitSelection() {
        FromImplementor implicitSelection = null;
        if (!this.isSubQuery) {
            implicitSelection = (FromImplementor)((Object)this.getRoots().iterator().next());
        } else if (this.resultType.getAnnotation(Entity.class) != null) {
            implicitSelection = (FromImplementor)((Object)this.from(this.resultType));
        }
        if (implicitSelection instanceof RootImpl) {
            RootImpl root = (RootImpl)implicitSelection;
            List<String> attrs = root.getEntityType().getAttributeNames();
            ArrayList list = new ArrayList();
            for (String attr : attrs) {
                list.add(root.getAttr(attr));
            }
            return (Renderable)((Object)this.criteriaBuilder.construct(this.resultType, list));
        }
        throw new IllegalStateException("No explicit selection and an implicit one could not be determined");
    }

    private void renderFromClause(RenderingContext rc, Set<Root> joinedRoots) {
        rc.append(" from ");
        String sep = "";
        for (Root<?> root : this.getRoots()) {
            if (joinedRoots.contains(root)) continue;
            rc.append(sep);
            ((RootImpl)root).renderFrom(rc);
            sep = ", ";
        }
        if (this.joinImplementor != null) {
            rc.append(sep);
            this.joinImplementor.renderFrom(rc);
        }
    }

    void collectJoinedRoots(JoinImplementor join, Set<Root> joinedRoots) {
        if (join.getLeft() instanceof Root) {
            joinedRoots.add((Root)((Object)join.getLeft()));
        } else if (join.getLeft() instanceof JoinImplementor) {
            this.collectJoinedRoots((JoinImplementor)join.getLeft(), joinedRoots);
        }
        if (join.getRight() instanceof Root) {
            joinedRoots.add((Root)((Object)join.getRight()));
        } else if (join.getRight() instanceof JoinImplementor) {
            this.collectJoinedRoots((JoinImplementor)join.getLeft(), joinedRoots);
        }
    }

    public void join(JoinImplementor join) {
        if (this.joinImplementor != null && this.joinImplementor != join.getLeft()) {
            throw new IllegalArgumentException("bad join order");
        }
        this.joinImplementor = join;
    }
}

