/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.ibatis.persist.criteria.ParameterExpression;
import org.ibatis.persist.impl.ParameterInfo;

public class RenderingContext {
    Stack<Object> stack = new Stack();
    private int aliasCount = 1;
    ParameterInfo<?>[] parameterInfos;
    Set<ParameterExpression<?>> parameterExpressions;
    boolean query = true;

    public boolean isQuery() {
        return this.query;
    }

    public void setQuery(boolean query) {
        this.query = query;
    }

    public String generateAlias() {
        return "_t" + this.aliasCount++;
    }

    public RenderingContext append(String str) {
        StringBuilder buf = this.buffer();
        buf.append(str);
        return this;
    }

    synchronized StringBuilder buffer() {
        Object top;
        if (this.stack.size() > 0 && (top = this.stack.peek()) instanceof StringBuilder) {
            return (StringBuilder)top;
        }
        this.stack.push(new StringBuilder());
        return (StringBuilder)this.stack.peek();
    }

    public synchronized RenderingContext append(ParameterInfo<?> parameter) {
        this.stack.push(parameter);
        return this;
    }

    public RenderingContext append(char c) {
        StringBuilder buf = this.buffer();
        buf.append(c);
        return this;
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        for (Object e : this.stack) {
            if (e instanceof StringBuilder) {
                buf.append(e.toString());
                continue;
            }
            buf.append("?");
        }
        return buf.toString();
    }

    public ParameterInfo<?>[] getParameterInfos() {
        if (this.parameterInfos == null) {
            ArrayList<ParameterInfo> list = new ArrayList<ParameterInfo>();
            for (Object e : this.stack) {
                if (!(e instanceof ParameterInfo)) continue;
                list.add((ParameterInfo)e);
            }
            this.parameterInfos = list.toArray(new ParameterInfo[list.size()]);
        }
        return this.parameterInfos;
    }

    public Set<ParameterExpression<?>> getParameters() {
        if (this.parameterExpressions == null) {
            this.parameterExpressions = new HashSet();
            for (Object e : this.stack) {
                if (!(e instanceof ParameterExpression)) continue;
                this.parameterExpressions.add((ParameterExpression)e);
            }
        }
        return Collections.unmodifiableSet(this.parameterExpressions);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Object e : this.stack) {
            buf.append(e.toString());
        }
        return buf.toString();
    }
}

