/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.BinaryOperatorExpression;
import org.ibatis.persist.impl.expression.ExpressionImpl;
import org.ibatis.persist.impl.expression.LiteralExpression;

public class BinaryArithmeticOperation<N extends Number>
extends ExpressionImpl<N>
implements BinaryOperatorExpression<N> {
    private final Operation operator;
    private final Expression<? extends N> rhs;
    private final Expression<? extends N> lhs;

    public static Class<? extends Number> determineReturnType(Class<? extends Number> defaultType, Expression<? extends Number> expression) {
        return expression == null || expression.getJavaType() == null ? defaultType : expression.getJavaType();
    }

    public static Class<? extends Number> determineReturnType(Class<? extends Number> defaultType, Number numberLiteral) {
        return numberLiteral == null ? defaultType : numberLiteral.getClass();
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> resultType, Operation operator, Expression<? extends N> lhs, Expression<? extends N> rhs) {
        super(criteriaBuilder, resultType);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> javaType, Operation operator, Expression<? extends N> lhs, N rhs) {
        super(criteriaBuilder, javaType);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = new LiteralExpression<N>(criteriaBuilder, rhs);
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> javaType, Operation operator, N lhs, Expression<? extends N> rhs) {
        super(criteriaBuilder, javaType);
        this.operator = operator;
        this.lhs = new LiteralExpression<N>(criteriaBuilder, lhs);
        this.rhs = rhs;
    }

    public Operation getOperator() {
        return this.operator;
    }

    @Override
    public Expression<? extends N> getRightHandOperand() {
        return this.rhs;
    }

    @Override
    public Expression<? extends N> getLeftHandOperand() {
        return this.lhs;
    }

    @Override
    public void render(RenderingContext rc) {
        this.getOperator().apply(rc, (Renderable)((Object)this.getLeftHandOperand()), (Renderable)((Object)this.getRightHandOperand()));
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        this.render(rc);
        if (this.getAlias() != null) {
            rc.append(" AS ").append(this.getAlias());
        }
    }

    public static enum Operation {
        ADD{

            @Override
            void apply(RenderingContext rc, Renderable lhs, Renderable rhs) {
                Operation.applyPrimitive(rc, lhs, '+', rhs);
            }
        }
        ,
        SUBTRACT{

            @Override
            void apply(RenderingContext rc, Renderable lhs, Renderable rhs) {
                Operation.applyPrimitive(rc, lhs, '-', rhs);
            }
        }
        ,
        MULTIPLY{

            @Override
            void apply(RenderingContext rc, Renderable lhs, Renderable rhs) {
                Operation.applyPrimitive(rc, lhs, '*', rhs);
            }
        }
        ,
        DIVIDE{

            @Override
            void apply(RenderingContext rc, Renderable lhs, Renderable rhs) {
                Operation.applyPrimitive(rc, lhs, '/', rhs);
            }
        }
        ,
        QUOT{

            @Override
            void apply(RenderingContext rc, Renderable lhs, Renderable rhs) {
                Operation.applyPrimitive(rc, lhs, '/', rhs);
            }
        }
        ,
        MOD{

            @Override
            void apply(RenderingContext rc, Renderable lhs, Renderable rhs) {
                rc.append("mod(");
                lhs.render(rc);
                rc.append(",");
                rhs.render(rc);
                rc.append(")");
            }
        };

        private static final char LEFT_PAREN = '(';
        private static final char RIGHT_PAREN = ')';

        abstract void apply(RenderingContext var1, Renderable var2, Renderable var3);

        private static void applyPrimitive(RenderingContext rc, Renderable lhs, char operator, Renderable rhs) {
            rc.append('(');
            lhs.render(rc);
            rc.append(operator);
            rhs.render(rc);
            rc.append(')');
        }
    }
}

